/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.manager;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.common.lifecycle.LifeCycleListener;
import org.exoplatform.social.core.identity.IdentityProvider;
import org.exoplatform.social.core.identity.IdentityProviderPlugin;
import org.exoplatform.social.core.identity.ProfileFilterListAccess;
import org.exoplatform.social.core.identity.SpaceMemberFilterListAccess;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.profile.ProfileLifeCycle;
import org.exoplatform.social.core.profile.ProfileListener;
import org.exoplatform.social.core.profile.ProfileListenerPlugin;
import org.exoplatform.social.core.profile.UserProfileComparator;
import org.exoplatform.social.core.search.Sorting;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.storage.api.IdentityStorage;

public class IdentityManagerImpl
implements IdentityManager {
    private static final Log LOG = ExoLogger.getExoLogger(IdentityManagerImpl.class);
    private static final int OFFSET = 0;
    private static final int LIMIT = 200;
    protected Map<String, IdentityProvider<?>> identityProviders = new HashMap();
    protected Map<String, ProfileListener> profileListeners = new HashMap<String, ProfileListener>();
    protected IdentityStorage identityStorage;
    protected RelationshipManager relationshipManager;
    protected ProfileLifeCycle profileLifeCycle = new ProfileLifeCycle();
    private Sorting defaultSorting = DEFAULT_SORTING;
    private String firstCharacterFiltering = DEFAULT_FIRST_CHAR_FILTERING;
    private int imageUploadLimit = 2;

    public IdentityManagerImpl(IdentityStorage identityStorage, IdentityProvider<?> defaultIdentityProvider, InitParams initParams) {
        this.identityStorage = identityStorage;
        this.addIdentityProvider(defaultIdentityProvider);
        if (initParams != null) {
            Sorting configuredSorting;
            String uploadLimit;
            String sortFieldName = this.defaultSorting.sortBy.getFieldName();
            if (initParams.containsKey((Object)"sort.field.name")) {
                sortFieldName = initParams.getValueParam("sort.field.name").getValue();
            }
            String sortDirection = this.defaultSorting.orderBy.name();
            if (initParams.containsKey((Object)"sort.order.direction")) {
                sortDirection = initParams.getValueParam("sort.order.direction").getValue();
            }
            if (initParams.containsKey((Object)"upload.limit.size") && StringUtils.isNotBlank((CharSequence)(uploadLimit = initParams.getValueParam("upload.limit.size").getValue()))) {
                this.imageUploadLimit = Integer.parseInt(uploadLimit.trim());
                this.identityStorage.setImageUploadLimit(this.imageUploadLimit);
            }
            if ((configuredSorting = Sorting.valueOf((String)sortFieldName, (String)sortDirection)) != null) {
                this.defaultSorting = configuredSorting;
            }
            String firstCharacterFilteringField = DEFAULT_FIRST_CHAR_FILTERING;
            if (initParams.containsKey((Object)"firstChar.field.name")) {
                firstCharacterFilteringField = initParams.getValueParam("firstChar.field.name").getValue();
            }
            if ((configuredSorting = Sorting.valueOf((String)firstCharacterFilteringField, (String)"ASC")) != null && configuredSorting.sortBy != null) {
                this.firstCharacterFiltering = configuredSorting.sortBy.getFieldName();
            }
        }
    }

    public int getImageUploadLimit() {
        return this.imageUploadLimit;
    }

    public Sorting getDefaultSorting() {
        return this.defaultSorting;
    }

    public String getFirstCharacterFiltering() {
        return this.firstCharacterFiltering;
    }

    public List<Identity> getLastIdentities(int limit) {
        ProfileFilter profileFilter = new ProfileFilter();
        profileFilter.setSorting(new Sorting(Sorting.SortBy.DATE, Sorting.OrderBy.DESC));
        return this.identityStorage.getIdentitiesForUnifiedSearch("organization", profileFilter, 0L, (long)limit);
    }

    public ListAccess<Identity> getConnectionsWithListAccess(Identity identity) {
        return this.getRelationshipManager().getConnections(identity);
    }

    public ListAccess<Identity> getIdentitiesByProfileFilter(String providerId, ProfileFilter profileFilter, boolean forceLoadProfile) {
        if (profileFilter == null) {
            profileFilter = new ProfileFilter();
        }
        if (profileFilter.isSortingEmpty()) {
            profileFilter.setSorting(this.defaultSorting);
        }
        if (StringUtils.isBlank((CharSequence)profileFilter.getFirstCharFieldName())) {
            profileFilter.setFirstCharFieldName(this.firstCharacterFiltering);
        }
        return new ProfileFilterListAccess(this.identityStorage, providerId, profileFilter, forceLoadProfile);
    }

    public ListAccess<Identity> getSpaceIdentityByProfileFilter(Space space, ProfileFilter profileFilter, SpaceMemberFilterListAccess.Type type, boolean forceLoadProfile) {
        return new SpaceMemberFilterListAccess(this.identityStorage, space, profileFilter, type);
    }

    public Profile getProfile(Identity identity) {
        Profile profile = identity.getProfile();
        if (profile.getId() == null) {
            profile = this.identityStorage.loadProfile(profile);
            identity.setProfile(profile);
        }
        return profile;
    }

    public InputStream getAvatarInputStream(Identity identity) throws IOException {
        if (identity == null) {
            return null;
        }
        return this.identityStorage.getAvatarInputStreamById(identity);
    }

    public InputStream getBannerInputStream(Identity identity) throws IOException {
        if (identity == null) {
            return null;
        }
        return this.identityStorage.getBannerInputStreamById(identity);
    }

    public void updateProfile(Profile existingProfile) {
        this.updateProfile(existingProfile, false);
    }

    public void updateProfile(Profile specificProfile, boolean broadcastChanges) {
        if (broadcastChanges) {
            this.detectChanges(specificProfile);
        }
        this.identityStorage.updateProfile(specificProfile);
        this.broadcastUpdateProfileEvent(specificProfile);
        this.getIdentityProvider(specificProfile.getIdentity().getProviderId()).onUpdateProfile(specificProfile);
    }

    private void detectChanges(Profile specificProfile) {
        if (specificProfile.getId() != null) {
            String identityId = specificProfile.getId();
            Identity identity = this.getIdentity(identityId);
            if (identity == null) {
                return;
            }
            Profile existingProfile = identity.getProfile();
            if (existingProfile == null) {
                return;
            }
            ArrayList<Profile.UpdateType> list = new ArrayList<Profile.UpdateType>();
            if (UserProfileComparator.hasChanged(specificProfile, existingProfile, new String[]{"aboutMe"})) {
                list.add(Profile.UpdateType.ABOUT_ME);
            }
            if (UserProfileComparator.hasChanged(specificProfile, existingProfile, "firstName", "lastName", "email", "position", "gender", "phones", "ims", "urls", "external", "lastLoginTime")) {
                list.add(Profile.UpdateType.CONTACT);
            }
            if (UserProfileComparator.hasChanged(specificProfile, existingProfile, new String[]{"experiences"})) {
                list.add(Profile.UpdateType.EXPERIENCES);
            }
            if (specificProfile.getProperty("avatar") != null) {
                list.add(Profile.UpdateType.AVATAR);
            }
            if (UserProfileComparator.hasChanged(specificProfile, existingProfile, "lastLoginTime", "enrollmentDate")) {
                list.add(Profile.UpdateType.TECHNICAL);
            }
            specificProfile.setListUpdateTypes(list);
        }
    }

    public void registerProfileListener(ProfileListenerPlugin profileListenerPlugin) {
        this.profileLifeCycle.addListener((LifeCycleListener)profileListenerPlugin);
    }

    public Identity updateIdentity(Identity identity) {
        return this.identityStorage.updateIdentity(identity);
    }

    public void addIdentityProvider(IdentityProvider<?> idProvider) {
        if (idProvider != null) {
            LOG.debug((Object)("Registering identity provider for " + idProvider.getName() + ": " + idProvider));
            this.identityProviders.put(idProvider.getName(), idProvider);
        }
    }

    public void removeIdentityProvider(IdentityProvider<?> identityProvider) {
        if (identityProvider != null) {
            LOG.debug((Object)("Removing identity provider for " + identityProvider.getName() + ": " + identityProvider));
            this.identityProviders.remove(identityProvider.getName());
        }
    }

    public void deleteIdentity(Identity identity) {
        if (identity.getId() == null) {
            LOG.warn((Object)("identity.getId() must not be null of [" + identity + "]"));
            return;
        }
        this.getIdentityStorage().deleteIdentity(identity);
    }

    public void hardDeleteIdentity(Identity identity) {
        if (identity.getId() == null) {
            LOG.warn((Object)("identity.getId() must not be null of [" + identity + "]"));
            return;
        }
        this.getIdentityStorage().hardDeleteIdentity(identity);
    }

    public List<Identity> getConnections(Identity ownerIdentity) throws Exception {
        return Arrays.asList((Identity[])this.getConnectionsWithListAccess(ownerIdentity).load(0, 200));
    }

    public List<Identity> getIdentities(String providerId) throws Exception {
        return this.getIdentities(providerId, true);
    }

    public List<Identity> getIdentities(String providerId, boolean loadProfile) throws Exception {
        return Arrays.asList((Identity[])this.getIdentitiesByProfileFilter(providerId, new ProfileFilter(), loadProfile).load(0, 200));
    }

    public List<Identity> getIdentitiesByProfileFilter(String providerId, ProfileFilter profileFilter) throws Exception {
        return Arrays.asList((Identity[])this.getIdentitiesByProfileFilter(providerId, profileFilter, false).load(0, 200));
    }

    public ListAccess<Identity> getIdentitiesForUnifiedSearch(String providerId, ProfileFilter profileFilter) {
        return new ProfileFilterListAccess(this.identityStorage, providerId, profileFilter, true, ProfileFilterListAccess.Type.UNIFIED_SEARCH);
    }

    public List<Identity> getIdentitiesByProfileFilter(String providerId, ProfileFilter profileFilter, long offset, long limit) throws Exception {
        return Arrays.asList((Identity[])this.getIdentitiesByProfileFilter(providerId, profileFilter, false).load((int)offset, (int)limit));
    }

    public List<Identity> getIdentitiesByProfileFilter(ProfileFilter profileFilter) throws Exception {
        return Arrays.asList((Identity[])this.getIdentitiesByProfileFilter(null, profileFilter, false).load(0, 200));
    }

    public List<Identity> getIdentitiesByProfileFilter(ProfileFilter profileFilter, long offset, long limit) throws Exception {
        return Arrays.asList((Identity[])this.getIdentitiesByProfileFilter(null, profileFilter, false).load((int)offset, (int)limit));
    }

    public List<Identity> getIdentitiesFilterByAlphaBet(String providerId, ProfileFilter profileFilter) throws Exception {
        return Arrays.asList((Identity[])this.getIdentitiesByProfileFilter(providerId, profileFilter, false).load(0, 200));
    }

    public List<Identity> getIdentitiesFilterByAlphaBet(String providerId, ProfileFilter profileFilter, long offset, long limit) throws Exception {
        return Arrays.asList((Identity[])this.getIdentitiesByProfileFilter(providerId, profileFilter, false).load((int)offset, (int)limit));
    }

    public List<Identity> getIdentitiesFilterByAlphaBet(ProfileFilter profileFilter) throws Exception {
        return Arrays.asList((Identity[])this.getIdentitiesByProfileFilter(null, profileFilter, false).load(0, 200));
    }

    public Identity getIdentity(String id) {
        return this.getIdentity(id, true);
    }

    public long getIdentitiesCount(String providerId) {
        return this.identityStorage.getIdentitiesCount(providerId);
    }

    public Identity getIdentity(String identityId, boolean forceLoadOrReloadProfile) {
        Identity returnIdentity = this.getIdentityStorage().findIdentityById(identityId);
        if (returnIdentity != null) {
            if (forceLoadOrReloadProfile) {
                Profile profile = this.getIdentityStorage().loadProfile(returnIdentity.getProfile());
                returnIdentity.setProfile(profile);
            }
        } else {
            LOG.info((Object)("Can not get identity with id: " + identityId));
        }
        return returnIdentity;
    }

    public Identity getIdentity(String providerId, String remoteId, boolean loadProfile) {
        return this.getOrCreateIdentity(providerId, remoteId, loadProfile);
    }

    public Identity getOrCreateIdentity(String providerId, String remoteId) {
        return this.getOrCreateIdentity(providerId, remoteId, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Identity getOrCreateIdentity(String providerId, String remoteId, boolean forceLoadOrReloadProfile) {
        Identity returnIdentity = null;
        IdentityProvider<?> identityProvider = this.getIdentityProvider(providerId);
        Identity identityFoundByRemoteProvider = identityProvider.getIdentityByRemoteId(remoteId);
        Identity result = this.getIdentityStorage().findIdentity(providerId, remoteId);
        if (result == null) {
            if (identityFoundByRemoteProvider == null) return result;
            this.saveIdentity(identityFoundByRemoteProvider);
            this.getIdentityStorage().saveProfile(identityFoundByRemoteProvider.getProfile());
            result = identityFoundByRemoteProvider;
            if (!"organization".equals(providerId)) return result;
            this.profileLifeCycle.createProfile(result.getProfile());
            return result;
        } else {
            if (identityFoundByRemoteProvider == null && !result.isDeleted()) {
                LOG.warn((Object)("User " + remoteId + " not found in remote provider " + providerId + " but his social identity is not marked as deleted"), (Throwable)new IllegalStateException("User '" + remoteId + "' should be marked as deleted since it wasn't found in IDM store"));
            }
            Profile profile = this.getIdentityStorage().loadProfile(result.getProfile());
            profile.setIdentity(result);
            result.setProfile(profile);
        }
        return result;
    }

    public boolean identityExisted(String providerId, String remoteId) {
        IdentityProvider<?> identityProvider = this.getIdentityProvider(providerId);
        return identityProvider.getIdentityByRemoteId(remoteId) != null;
    }

    public void registerIdentityProviders(IdentityProviderPlugin plugin) {
        List pluginProviders = plugin.getProviders();
        if (pluginProviders != null) {
            for (IdentityProvider identityProvider : pluginProviders) {
                this.addIdentityProvider(identityProvider);
            }
        }
    }

    public void saveIdentity(Identity identity) {
        this.getIdentityStorage().saveIdentity(identity);
        this.getIdentityProvider(identity.getProviderId()).onSaveIdentity(identity);
    }

    public void saveProfile(Profile profile) {
        this.getIdentityStorage().saveProfile(profile);
        this.getIdentityProvider(profile.getIdentity().getProviderId()).onSaveProfile(profile);
    }

    public void updateAvatar(Profile p) {
        this.updateProfile(p);
    }

    public void updateBasicInfo(Profile p) throws Exception {
        this.updateProfile(p);
    }

    public void updateContactSection(Profile p) throws Exception {
        this.updateProfile(p);
    }

    public void updateExperienceSection(Profile p) throws Exception {
        this.updateProfile(p);
    }

    public void updateHeaderSection(Profile p) throws Exception {
        this.updateProfile(p);
    }

    public IdentityProvider<?> getIdentityProvider(String providerId) {
        IdentityProvider<?> provider = this.identityProviders.get(providerId);
        if (provider == null) {
            throw new RuntimeException("No suitable identity provider exists for " + providerId);
        }
        return provider;
    }

    public IdentityStorage getIdentityStorage() {
        return this.identityStorage;
    }

    public void setIdentityStorage(IdentityStorage identityStorage) {
        this.identityStorage = identityStorage;
    }

    public RelationshipManager getRelationshipManager() {
        if (this.relationshipManager == null) {
            this.relationshipManager = (RelationshipManager)PortalContainer.getInstance().getComponentInstanceOfType(RelationshipManager.class);
        }
        return this.relationshipManager;
    }

    public void addProfileListener(ProfileListenerPlugin plugin) {
        this.registerProfileListener(plugin);
    }

    public void registerProfileListener(ProfileListener listener) {
        this.profileLifeCycle.addListener((LifeCycleListener)listener);
    }

    public void unregisterProfileListener(ProfileListener listener) {
        this.profileLifeCycle.removeListener((LifeCycleListener)listener);
    }

    public void addOrModifyProfileProperties(Profile profile) throws Exception {
        this.getIdentityStorage().addOrModifyProfileProperties(profile);
        this.getIdentityProvider(profile.getIdentity().getProviderId()).onSaveProfile(profile);
    }

    public IdentityStorage getStorage() {
        return this.identityStorage;
    }

    protected void broadcastUpdateProfileEvent(Profile profile) {
        for (Profile.UpdateType type : profile.getListUpdateTypes()) {
            type.updateActivity(this.profileLifeCycle, profile);
        }
    }

    public void processEnabledIdentity(String remoteId, boolean isEnable) {
        Identity identity = this.getOrCreateIdentity("organization", remoteId, false);
        this.getIdentityStorage().processEnabledIdentity(identity, isEnable);
    }

    public List<String> sortIdentities(List<String> identityRemoteIds, String firstCharacterFieldName, char firstCharacter, String sortField, String sortDirection, boolean filterDisabled) {
        if (StringUtils.isBlank((CharSequence)firstCharacterFieldName)) {
            firstCharacterFieldName = this.getFirstCharacterFiltering();
        }
        if (StringUtils.isBlank((CharSequence)sortField)) {
            sortField = this.getDefaultSorting().sortBy.getFieldName();
        }
        if (StringUtils.isBlank((CharSequence)sortDirection)) {
            sortDirection = this.getDefaultSorting().orderBy.name();
        }
        return this.identityStorage.sortIdentities(identityRemoteIds, firstCharacterFieldName, firstCharacter, sortField, sortDirection, filterDisabled);
    }

    public List<String> sortIdentities(List<String> identityRemoteIds, String firstCharacterFieldName, char firstCharacter, String sortField, String sortDirection) {
        return this.sortIdentities(identityRemoteIds, firstCharacterFieldName, firstCharacter, sortField, sortDirection, true);
    }

    private String getValue(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        return value;
    }
}

