/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mfa.api.otp;

import java.time.Clock;
import java.util.HashMap;
import java.util.Locale;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.mfa.api.MfaService;
import org.exoplatform.mfa.api.MfaSystemService;
import org.exoplatform.mfa.api.otp.OtpConnector;
import org.exoplatform.services.resources.ResourceBundleService;

public class OtpService
implements MfaSystemService {
    private static final String TYPE = "OTP";
    private HashMap<String, OtpConnector> otpConnectors = new HashMap();
    private String activeConnector;
    private MfaService mfaService;
    private ResourceBundleService resourceBundleService;

    public OtpService(InitParams initParams, MfaService mfaService, ResourceBundleService resourceBundleService) {
        ValueParam activeConnectorParam = initParams.getValueParam("activeConnector");
        if (activeConnectorParam != null) {
            this.activeConnector = activeConnectorParam.getValue();
        }
        this.mfaService = mfaService;
        this.resourceBundleService = resourceBundleService;
    }

    public boolean validateToken(String user, String token) {
        boolean isValidToken = this.getActiveConnector().validateToken(user, token, Clock.systemDefaultZone());
        if (isValidToken) {
            this.mfaService.deleteRevocationRequest(user, TYPE);
        }
        return isValidToken;
    }

    public void addConnector(OtpConnector mfaConnector) {
        this.otpConnectors.put(mfaConnector.getName(), mfaConnector);
    }

    private OtpConnector getActiveConnector() {
        return this.otpConnectors.get(this.activeConnector);
    }

    public boolean isMfaInitializedForUser(String userId) {
        return this.getActiveConnector().isMfaInitializedForUser(userId);
    }

    public String generateSecret(String userId) {
        return this.getActiveConnector().generateSecret(userId);
    }

    @Override
    public void removeSecret(String userId) {
        this.getActiveConnector().removeSecret(userId);
    }

    public String generateUrlFromSecret(String user, String secret) {
        return this.getActiveConnector().generateUrlFromSecret(user, secret);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public String getHelpTitle(Locale locale) {
        return this.resourceBundleService.getResourceBundle("locale.portlet.mfaAccess.mfaAccess", locale).getString("mfa.otp.help.title");
    }

    @Override
    public String getHelpContent(Locale locale) {
        return this.resourceBundleService.getResourceBundle("locale.portlet.mfaAccess.mfaAccess", locale).getString("mfa.otp.help.content");
    }
}

