/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.kudos.listener;

import org.exoplatform.kudos.model.Kudos;
import org.exoplatform.kudos.model.KudosEntityType;
import org.exoplatform.kudos.service.KudosService;
import org.exoplatform.kudos.service.utils.Utils;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;

public class NewKudosSentActivityGeneratorListener
extends Listener<KudosService, Kudos> {
    private static final Log LOG = ExoLogger.getLogger(NewKudosSentActivityGeneratorListener.class);
    private ActivityManager activityManager;

    public NewKudosSentActivityGeneratorListener(ActivityManager activityManager) {
        this.activityManager = activityManager;
    }

    public void onEvent(Event<KudosService, Kudos> event) throws Exception {
        Kudos kudos = (Kudos)event.getData();
        KudosService kudosService = (KudosService)event.getSource();
        if (KudosEntityType.valueOf(kudos.getEntityType()) == KudosEntityType.ACTIVITY || KudosEntityType.valueOf(kudos.getEntityType()) == KudosEntityType.COMMENT) {
            String activityId = kudos.getEntityId();
            try {
                String parentCommentId = null;
                ExoSocialActivity activity = null;
                if (KudosEntityType.valueOf(kudos.getEntityType()) == KudosEntityType.COMMENT) {
                    ExoSocialActivity comment = this.activityManager.getActivity(activityId);
                    if (comment != null) {
                        activity = this.activityManager.getParentActivity(comment);
                        parentCommentId = comment.getParentCommentId() != null ? comment.getParentCommentId() : comment.getId();
                    }
                } else {
                    activity = this.activityManager.getActivity(activityId);
                }
                if (activity == null) {
                    throw new IllegalStateException("Activity with id '" + activityId + "' wasn't found");
                }
                ExoSocialActivity activityComment = this.createActivity(kudos, parentCommentId);
                this.activityManager.saveComment(activity, activityComment);
                long commentId = Utils.getActivityId(activityComment.getId());
                kudos.setActivityId(commentId);
                kudosService.updateKudosGeneratedActivityId(kudos.getTechnicalId(), kudos.getActivityId());
            }
            catch (Exception e) {
                LOG.warn((Object)("Error adding comment on activity with id '" + activityId + "' for Kudos with id " + kudos.getTechnicalId()), (Throwable)e);
            }
        } else {
            Identity owner;
            ExoSocialActivity activity = this.createActivity(kudos, null);
            String providerId = "organization";
            if ("space".equals(kudos.getReceiverType())) {
                providerId = "space";
            }
            if ((owner = org.exoplatform.social.notification.Utils.getIdentityManager().getOrCreateIdentity(providerId, kudos.getReceiverId())) == null) {
                LOG.warn("Can't find receiver identity with type/id", new Object[]{kudos.getReceiverType(), kudos.getReceiverId()});
            } else {
                this.activityManager.saveActivityNoReturn(owner, activity);
                kudosService.updateKudosGeneratedActivityId(kudos.getTechnicalId(), Utils.getActivityId(activity.getId()));
            }
        }
    }

    private ExoSocialActivity createActivity(Kudos kudos, String parentCommentId) {
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setParentCommentId(parentCommentId);
        activity.setType("exokudos:activity");
        activity.setTitle("Kudos to " + kudos.getReceiverFullName());
        activity.setBody("Kudos to " + kudos.getReceiverFullName());
        activity.setUserId(kudos.getSenderIdentityId());
        Utils.computeKudosActivityProperties((ExoSocialActivity)activity, kudos);
        return activity;
    }
}

