/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.service;

import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wallet.model.ContractDetail;
import org.exoplatform.wallet.model.settings.GlobalSettings;
import org.exoplatform.wallet.service.WalletContractService;
import org.exoplatform.wallet.service.WalletService;
import org.exoplatform.wallet.service.WalletTokenAdminService;
import org.exoplatform.wallet.utils.WalletUtils;
import org.json.JSONArray;
import org.picocontainer.Startable;

public class WalletContractServiceImpl
implements WalletContractService,
Startable {
    private static final Log LOG = ExoLogger.getLogger(WalletContractServiceImpl.class);
    private static final String ADDRESS_PARAMETER_IS_MANDATORY_MESSAGE = "address parameter is mandatory";
    private ConfigurationManager configurationManager;
    private String contractAbiPath;
    private JSONArray contractAbi;
    private String contractBinaryPath;
    private String contractBinary;
    private SettingService settingService;
    private ListenerService listenerService;
    private WalletService walletService;
    private WalletTokenAdminService walletTokenAdminService;

    public WalletContractServiceImpl(SettingService settingService, ConfigurationManager configurationManager, InitParams params) {
        this.configurationManager = configurationManager;
        this.settingService = settingService;
        if (params.containsKey((Object)"contract.abi.path")) {
            this.contractAbiPath = params.getValueParam("contract.abi.path").getValue();
        }
        if (StringUtils.isBlank((String)this.contractAbiPath)) {
            LOG.warn((Object)"Contract ABI path is empty, thus no contract deployment is possible");
        }
        if (params.containsKey((Object)"contract.bin.path")) {
            this.contractBinaryPath = params.getValueParam("contract.bin.path").getValue();
        }
        if (StringUtils.isBlank((String)this.contractBinaryPath)) {
            LOG.warn((Object)"Contract BIN path is empty, thus no contract deployment is possible");
        }
    }

    public void start() {
        try {
            String contractAbiString = IOUtil.getStreamContentAsString((InputStream)this.configurationManager.getInputStream(this.contractAbiPath));
            this.contractAbi = new JSONArray(contractAbiString);
            this.contractBinary = IOUtil.getStreamContentAsString((InputStream)this.configurationManager.getInputStream(this.contractBinaryPath));
            if (!this.contractBinary.startsWith("0x")) {
                this.contractBinary = "0x" + this.contractBinary;
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Can't read ABI/BIN files content", (Throwable)e);
        }
    }

    public void stop() {
    }

    public boolean isContract(String address) {
        return this.getContractDetail(address) != null;
    }

    public void saveContractDetail(ContractDetail contractDetail) {
        if (contractDetail == null) {
            throw new IllegalArgumentException("contractDetail is mandatory");
        }
        String contractAddress = contractDetail.getAddress();
        if (StringUtils.isBlank((String)contractAddress)) {
            throw new IllegalArgumentException(ADDRESS_PARAMETER_IS_MANDATORY_MESSAGE);
        }
        String contractDetailString = WalletUtils.toJsonString((Object)contractDetail);
        this.settingService.set(WalletUtils.WALLET_CONTEXT, WalletUtils.WALLET_SCOPE, StringUtils.lowerCase((String)contractAddress), SettingValue.create((String)contractDetailString));
        this.getWalletService().setConfiguredContractDetail(contractDetail);
    }

    public ContractDetail getContractDetail(String address) {
        if (StringUtils.isBlank((String)address)) {
            return null;
        }
        SettingValue contractDetailValue = this.settingService.get(WalletUtils.WALLET_CONTEXT, WalletUtils.WALLET_SCOPE, StringUtils.lowerCase((String)address));
        if (contractDetailValue != null && contractDetailValue.getValue() != null) {
            String value = contractDetailValue.getValue().toString();
            try {
                return (ContractDetail)WalletUtils.fromJsonString((String)value, ContractDetail.class);
            }
            catch (Exception e) {
                LOG.debug("Remove old data stored in settings service for wallet with address '{}', having as value '{}'", new Object[]{address, value, e});
                this.settingService.remove(WalletUtils.WALLET_CONTEXT, WalletUtils.WALLET_SCOPE, StringUtils.lowerCase((String)address));
                return null;
            }
        }
        return null;
    }

    public void refreshContractDetail(Set<String> contractModifications) {
        GlobalSettings settings = WalletUtils.getSettings();
        String contractAddress = settings.getContractAddress();
        ContractDetail contractDetail = this.getContractDetail(contractAddress);
        if (contractDetail == null) {
            contractDetail = new ContractDetail();
            contractDetail.setAddress(contractAddress);
        }
        this.getWalletTokenAdminService().refreshContractDetailFromBlockchain(contractDetail, contractModifications);
        this.getWalletService().setConfiguredContractDetail(contractDetail);
        try {
            this.getListenerService().broadcast("exo.wallet.contract.modified", null, (Object)contractDetail);
        }
        catch (Exception e) {
            LOG.error((Object)"Error while broadcasting contract modification event", (Throwable)e);
        }
    }

    public JSONArray getContractAbi() {
        return this.contractAbi;
    }

    public String getContractBinary() {
        return this.contractBinary;
    }

    public String getContractFileContent(String name, String extension) throws IOException {
        try (InputStream abiInputStream = this.getClass().getClassLoader().getResourceAsStream("org/exoplatform/wallet/contract/" + name + "." + extension);){
            String string = IOUtils.toString((InputStream)abiInputStream);
            return string;
        }
    }

    private WalletService getWalletService() {
        if (this.walletService == null) {
            this.walletService = (WalletService)CommonsUtils.getService(WalletService.class);
        }
        return this.walletService;
    }

    private WalletTokenAdminService getWalletTokenAdminService() {
        if (this.walletTokenAdminService == null) {
            this.walletTokenAdminService = (WalletTokenAdminService)CommonsUtils.getService(WalletTokenAdminService.class);
        }
        return this.walletTokenAdminService;
    }

    private ListenerService getListenerService() {
        if (this.listenerService == null) {
            this.listenerService = (ListenerService)CommonsUtils.getService(ListenerService.class);
        }
        return this.listenerService;
    }
}

