/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.tree;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.mow.api.PermissionType;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.tree.TreeNode;
import org.exoplatform.wiki.tree.TreeNodeType;
import org.exoplatform.wiki.tree.utils.TreeUtils;
import org.exoplatform.wiki.utils.Utils;

public class PageTreeNode
extends TreeNode {
    private static final Log log = ExoLogger.getLogger(PageTreeNode.class);
    private Page page;
    private WikiService wikiService = (WikiService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(WikiService.class);

    public PageTreeNode(Page page) throws Exception {
        super(page.getTitle(), TreeNodeType.PAGE);
        this.page = page;
        this.id = page.getId();
        this.path = this.buildPath();
        this.hasChild = !this.wikiService.getChildrenPageOf(page).isEmpty();
    }

    public Page getPage() {
        return this.page;
    }

    public void setPage(Page page) {
        this.page = page;
    }

    @Override
    protected void addChildren(HashMap<String, Object> context) throws Exception {
        List<Page> pages = this.wikiService.getChildrenPageOf(this.page);
        Iterator childPageIterator = pages.iterator();
        int size = this.getNumberOfChildren(context, pages.size());
        Page currentPage = (Page)context.get("selectedPage");
        for (int count = 0; childPageIterator.hasNext() && count < size; ++count) {
            Page childPage = (Page)childPageIterator.next();
            if (!this.wikiService.hasPermissionOnPage(childPage, PermissionType.VIEWPAGE, ConversationState.getCurrent().getIdentity()) && (currentPage == null || !Utils.isDescendantPage(currentPage, childPage))) continue;
            PageTreeNode child = new PageTreeNode(childPage);
            this.children.add(child);
        }
        super.addChildren(context);
    }

    public PageTreeNode getChildByName(String name) throws Exception {
        for (TreeNode child : this.children) {
            if (!child.getName().equals(name)) continue;
            return (PageTreeNode)child;
        }
        return null;
    }

    @Override
    public String buildPath() {
        try {
            WikiPageParams params = new WikiPageParams(this.page.getWikiType(), this.page.getWikiOwner(), this.page.getName());
            return TreeUtils.getPathFromPageParams(params);
        }
        catch (Exception e) {
            log.error((Object)("Cannot build path of wiki page " + this.page.getWikiType() + ":" + this.page.getWikiOwner() + ":" + this.page.getName() + " - Cause : " + e.getMessage()), (Throwable)e);
            return null;
        }
    }
}

