/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mfa.rest.mfa;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.annotation.security.RolesAllowed;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.exoplatform.mfa.api.MfaService;
import org.exoplatform.mfa.rest.entities.RevocationRequestEntity;
import org.exoplatform.mfa.storage.dto.RevocationRequest;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Path(value="/mfa")
@Api(value="/mfa")
public class MfaRestService
implements ResourceContainer {
    private MfaService mfaService;
    private static final Log LOG = ExoLogger.getLogger(MfaRestService.class);

    public MfaRestService(MfaService mfaService) {
        this.mfaService = mfaService;
    }

    @Path(value="/settings")
    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Get Activated MFA System", httpMethod="GET", response=Response.class, produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getMfaSystem(@Context HttpServletRequest request) {
        JSONObject result = new JSONObject();
        Locale locale = request == null ? Locale.ENGLISH : request.getLocale();
        try {
            result.put("mfaSystem", (Object)this.mfaService.getMfaSystemService().getType());
            result.put("helpTitle", (Object)this.mfaService.getMfaSystemService().getHelpTitle(locale));
            result.put("helpContent", (Object)this.mfaService.getMfaSystemService().getHelpContent(locale));
            return Response.ok().entity((Object)result.toString()).build();
        }
        catch (JSONException e) {
            return Response.serverError().build();
        }
    }

    @Path(value="/available")
    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Get Activated MFA System", httpMethod="GET", response=Response.class, produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getAvalailableMfaSystems() {
        JSONObject result = new JSONObject();
        try {
            result.put("available", this.mfaService.getAvailableMfaSystems());
            return Response.ok().entity((Object)result.toString()).build();
        }
        catch (JSONException e) {
            return Response.serverError().build();
        }
    }

    @Path(value="/changeMfaFeatureActivation/{status}")
    @PUT
    @Produces(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    @ApiOperation(value="Switch the Activated MFA System", httpMethod="PUT", response=Response.class, produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response changeMfaFeatureActivation(@ApiParam(value="Switch the Activated MFA System to avtivated or deactivated", required=true) String status) {
        this.mfaService.saveActiveFeature(status);
        return Response.ok().type("text/plain").build();
    }

    @Path(value="/revocations")
    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    @ApiOperation(value="Get Revocation Request list", httpMethod="GET", response=Response.class, produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getRevocationRequests() {
        List<RevocationRequest> revocationRequests = this.mfaService.getAllRevocationRequests();
        try {
            JSONObject result = new JSONObject();
            result.put("requests", (Collection)revocationRequests.stream().map(this::buildRevocationRequest).map(revocationRequestEntity -> new JSONObject(revocationRequestEntity.asMap())).collect(Collectors.toList()));
            return Response.ok().entity((Object)result.toString()).build();
        }
        catch (JSONException e) {
            LOG.error((Object)"Unable to build get revocation request answer", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @Path(value="/revocations/{id}")
    @PUT
    @Produces(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    @ApiOperation(value="Update a revocation request", httpMethod="PUT", response=Response.class, produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response updateRevocationRequests(@ApiParam(value="RevocationRequest id", required=true) @PathParam(value="id") String id, @ApiParam(value="RevocationRequest status confirm/cancel", required=true) @QueryParam(value="status") String status) {
        RevocationRequest revocationRequest = this.mfaService.getRevocationRequestById(Long.parseLong(id));
        if (revocationRequest != null) {
            switch (status) {
                case "confirm": {
                    this.mfaService.confirmRevocationRequest(Long.parseLong(id));
                    break;
                }
                case "cancel": {
                    this.mfaService.cancelRevocationRequest(Long.parseLong(id));
                    break;
                }
                default: {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
                }
            }
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
    }

    @Path(value="/revocations")
    @POST
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Create a Revocation Request", httpMethod="POST", response=Response.class, produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response addRevocationRequest(String type) {
        String userId = ConversationState.getCurrent().getIdentity().getUserId();
        boolean result = this.mfaService.addRevocationRequest(userId, type);
        return Response.ok().entity((Object)("{\"result\":\"" + result + "\"}")).build();
    }

    private RevocationRequestEntity buildRevocationRequest(RevocationRequest revocationRequest) {
        return new RevocationRequestEntity(revocationRequest.getId(), revocationRequest.getUser(), revocationRequest.getType());
    }

    @Path(value="/changeMfaSystem/{mfaSystem}")
    @PUT
    @Produces(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    @ApiOperation(value="Change the MFA System", httpMethod="PUT", response=Response.class, produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response changeMfaSystem(@ApiParam(value="Change the MFA MFA System", required=true) String mfaSystem) {
        if (this.mfaService.setMfaSystem(mfaSystem)) {
            return Response.ok().type("text/plain").build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
    }

    @POST
    @Path(value="/saveProtectedGroups")
    @RolesAllowed(value={"administrators"})
    @ApiOperation(value="set mfa groups", httpMethod="POST", response=Response.class, produces="application/json", notes="set mfa groups")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response saveProtectedGroups(@ApiParam(value="groups", required=true) String groups) {
        this.mfaService.saveProtectedGroups(groups);
        return Response.ok().entity((Object)("{\"groups\":\"" + groups + "\"}")).build();
    }

    @Path(value="/getProtectedGroups")
    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    @ApiOperation(value="Get protected groups for MFA System", httpMethod="GET", response=Response.class, produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getProtectedGroups() {
        JSONArray groups = new JSONArray();
        this.mfaService.getProtectedGroups().stream().forEach(arg_0 -> ((JSONArray)groups).put(arg_0));
        return Response.ok().entity((Object)("{\"protectedGroups\":" + groups + "}")).build();
    }
}

