/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.api;

import java.io.Serializable;
import org.gatein.common.util.ParameterValidation;
import org.gatein.pc.api.PortletStateType;
import org.gatein.pc.api.StatefulPortletContext;

public class PortletContext
implements Serializable {
    private static final String PREFIX = "/";
    private static final char SEPARATOR = ':';
    public static final String INVOKER_SEPARATOR = ".";
    public static final String PRODUCER_CLONE_ID_PREFIX = "_";
    public static final int PRODUCER_CLONE_PREFIX_LENGTH = "_".length();
    public static final String CONSUMER_CLONE_ID_PREFIX = "@";
    public static final int CONSUMER_CLONE_PREFIX_LENGTH = "@".length();
    public static final String CONSUMER_CLONE_DUMMY_STATE_ID = "dumbvalue";
    public static final String CONSUMER_CLONE_ID = "_dumbvalue";
    public static final PortletContext LOCAL_CONSUMER_CLONE = PortletContext.createPortletContext("local._dumbvalue");
    public static final String INVALID_PORTLET_CONTEXT = "Invalid portlet context: ";
    private final Components components;

    protected PortletContext(String id) throws IllegalArgumentException {
        this(id, true);
    }

    protected PortletContext(String id, boolean interpret) {
        Components components;
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)id, (String)"portlet id", (String)"PortletContext");
        if (interpret) {
            ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)id, (String)"portlet id", (String)"PortletContext");
            components = this.interpretIntoComponents(id);
        } else {
            components = new UninterpretedPortletContextComponents(id);
        }
        this.components = components;
    }

    private Components interpretIntoComponents(String id) {
        String trimmedId = id.trim();
        try {
            int prefixLength;
            if (trimmedId.startsWith(PREFIX)) {
                int separator = trimmedId.indexOf(58);
                String portletName = trimmedId.substring(separator + 1).trim();
                String appName = trimmedId.substring(1, separator).trim();
                if (separator != -1 && appName.length() > 0 && portletName.length() > 0) {
                    return new InterpretedPortletContextComponents(null, appName, portletName, null);
                }
                throw new IllegalArgumentException("Application name and portlet names were both empty.");
            }
            if (!trimmedId.startsWith(PRODUCER_CLONE_ID_PREFIX) && !trimmedId.startsWith(CONSUMER_CLONE_ID_PREFIX)) {
                String portletNameOrStateId;
                String invokerId;
                int invoker = trimmedId.indexOf(INVOKER_SEPARATOR);
                int prefix = trimmedId.indexOf(PREFIX);
                boolean isCompoundAppPortlet = false;
                if (prefix != -1 && invoker > 0 && invoker < prefix) {
                    invokerId = trimmedId.substring(0, invoker).trim();
                    int separator = trimmedId.indexOf(58, prefix);
                    if (separator != -1) {
                        String portletName = trimmedId.substring(separator + 1).trim();
                        trimmedId = trimmedId.substring(invoker + 1).trim();
                        String applicationName = trimmedId.substring(1, trimmedId.indexOf(58)).trim();
                        boolean bl = isCompoundAppPortlet = invokerId.length() > 0 && applicationName.length() > 0 && portletName.length() > 0;
                        if (isCompoundAppPortlet) {
                            return new InterpretedPortletContextComponents(invokerId, applicationName, portletName, null);
                        }
                    }
                }
                if (!isCompoundAppPortlet && invoker > 0 && (invokerId = trimmedId.substring(0, invoker).trim()).length() > 0 && (portletNameOrStateId = trimmedId.substring(invoker + 1).trim()).length() > 0) {
                    boolean isProducerClone = portletNameOrStateId.startsWith(PRODUCER_CLONE_ID_PREFIX);
                    boolean isConsumerClone = portletNameOrStateId.startsWith(CONSUMER_CLONE_ID_PREFIX);
                    if (isProducerClone || isConsumerClone) {
                        int prefixLength2 = isProducerClone ? PRODUCER_CLONE_PREFIX_LENGTH : CONSUMER_CLONE_PREFIX_LENGTH;
                        if ((portletNameOrStateId = portletNameOrStateId.substring(prefixLength2).trim()).length() > 0) {
                            return new InterpretedPortletContextComponents(invokerId, null, portletNameOrStateId, isProducerClone);
                        }
                    } else {
                        return new InterpretedPortletContextComponents(invokerId, null, portletNameOrStateId, null);
                    }
                }
                throw new IllegalArgumentException("'" + trimmedId + "' doesn't fit any known PortletContext formats");
            }
            boolean isProducerClone = trimmedId.startsWith(PRODUCER_CLONE_ID_PREFIX);
            boolean isConsumerClone = trimmedId.startsWith(CONSUMER_CLONE_ID_PREFIX);
            if ((isProducerClone || isConsumerClone) && (trimmedId = trimmedId.substring(prefixLength = isProducerClone ? PRODUCER_CLONE_PREFIX_LENGTH : CONSUMER_CLONE_PREFIX_LENGTH).trim()).length() > 0) {
                return new InterpretedPortletContextComponents(null, null, trimmedId, isProducerClone);
            }
            throw new IllegalArgumentException("'" + trimmedId + "' doesn't fit any known PortletContext formats");
        }
        catch (Exception e) {
            throw new IllegalArgumentException(INVALID_PORTLET_CONTEXT + id, e);
        }
    }

    protected PortletContext(Components components) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)components, (String)"portlet context components");
        this.components = components;
    }

    public static PortletContext dereference(PortletContext compoundPortletContext) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)compoundPortletContext, (String)"PortletContext to dereference");
        Components components = compoundPortletContext.getInternalComponents();
        if (!components.isInterpreted()) {
            try {
                components = compoundPortletContext.interpret();
            }
            catch (IllegalArgumentException e) {
                return compoundPortletContext;
            }
        }
        return PortletContext.createCopyWithNewComponents(compoundPortletContext, components.createCopyWithoutInvoker());
    }

    protected Components interpret() {
        return this.interpretIntoComponents(this.components.getId());
    }

    public static PortletContext reference(String invokerId, PortletContext portletContext) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)portletContext, (String)"PortletContext to reference");
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)invokerId, (String)"Invoker id to reference with", null);
        Components newComponents = portletContext.getInternalComponents().createCopyWithInvoker(invokerId);
        return PortletContext.createCopyWithNewComponents(portletContext, newComponents);
    }

    private static PortletContext createCopyWithNewComponents(PortletContext portletContextToCopy, Components newComponents) {
        if (portletContextToCopy instanceof StatefulPortletContext) {
            StatefulPortletContext compoundStatefulPortletContext = (StatefulPortletContext)portletContextToCopy;
            return StatefulPortletContext.create(newComponents, compoundStatefulPortletContext);
        }
        return new PortletContext(newComponents);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof PortletContext) {
            PortletContext that = (PortletContext)o;
            return this.getId().equals(that.getId());
        }
        return false;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String getId() {
        return this.components.getId();
    }

    public String toString() {
        return "PortletContext[" + this.getId() + "]";
    }

    @Deprecated
    public static PortletContext createPortletContext(String id, byte[] state) {
        return PortletContext.createPortletContext(id, state, true);
    }

    @Deprecated
    public static StatefulPortletContext<byte[]> createStatefulPortletContext(String id, byte[] state) {
        return new StatefulPortletContext<byte[]>(id, PortletStateType.OPAQUE, state, true);
    }

    public static PortletContext createPortletContext(String portletId) {
        return PortletContext.createPortletContext(portletId, true);
    }

    public static PortletContext createPortletContext(String portletId, boolean interpret) {
        return PortletContext.createPortletContext(portletId, null, interpret);
    }

    public static PortletContext createPortletContext(String portletId, byte[] state, boolean interpret) {
        if (state != null && state.length > 0) {
            return new StatefulPortletContext<byte[]>(portletId, PortletStateType.OPAQUE, state, interpret);
        }
        return new PortletContext(portletId, interpret);
    }

    public static PortletContext createPortletContext(String applicationName, String portletName) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)applicationName, (String)"portlet application id", (String)"PortletContext");
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)portletName, (String)"container id", (String)"PortletContext");
        if (applicationName.startsWith(PREFIX)) {
            applicationName = applicationName.substring(1);
        }
        return new PortletContext(new InterpretedPortletContextComponents(null, applicationName, portletName, null));
    }

    public PortletContextComponents getComponents() {
        return this.getInternalComponents();
    }

    private Components getInternalComponents() {
        return this.components;
    }

    private static class UninterpretedPortletContextComponents
    implements Components,
    Serializable {
        private static final String ERROR = "This PortletContext was not intepreted, only the portlet name is available!";
        private final String portletName;

        private UninterpretedPortletContextComponents(String portletName) {
            this.portletName = portletName;
        }

        @Override
        public String getApplicationName() {
            throw new IllegalStateException(ERROR);
        }

        @Override
        public String getPortletName() {
            return this.portletName;
        }

        @Override
        public String getInvokerName() {
            throw new IllegalStateException(ERROR);
        }

        @Override
        public boolean isCloned() {
            throw new IllegalStateException(ERROR);
        }

        @Override
        public boolean isProducerCloned() {
            throw new IllegalStateException(ERROR);
        }

        @Override
        public boolean isConsumerCloned() {
            throw new IllegalStateException(ERROR);
        }

        @Override
        public String getStateId() {
            throw new IllegalStateException(ERROR);
        }

        @Override
        public String getId() {
            return this.portletName;
        }

        @Override
        public boolean isInterpreted() {
            return false;
        }

        @Override
        public Components createCopyWithoutInvoker() {
            throw new IllegalStateException(ERROR);
        }

        @Override
        public Components createCopyWithInvoker(String invoker) {
            return new InterpretedPortletContextComponents(invoker, null, this.portletName, null);
        }
    }

    private static class InterpretedPortletContextComponents
    implements Components,
    Serializable {
        private final String applicationName;
        private final String portletName;
        private final String invokerName;
        private final Boolean producerCloned;
        private final String id;

        InterpretedPortletContextComponents(String invokerName, String applicationName, String portletNameOrStateId, Boolean producerCloned) {
            this.producerCloned = producerCloned;
            if (this.isCloned() && !ParameterValidation.isNullOrEmpty((String)applicationName)) {
                throw new IllegalArgumentException("Cannot be a clone if applicationName is provided");
            }
            this.applicationName = applicationName;
            this.portletName = portletNameOrStateId;
            this.invokerName = invokerName;
            this.id = (String)(invokerName == null ? "" : invokerName + PortletContext.INVOKER_SEPARATOR) + (String)(applicationName == null ? "" : PortletContext.PREFIX + applicationName + ":") + (String)(this.portletName == null ? "" : (producerCloned != null ? (producerCloned.booleanValue() ? PortletContext.PRODUCER_CLONE_ID_PREFIX : PortletContext.CONSUMER_CLONE_ID_PREFIX) : "") + this.portletName);
        }

        @Override
        public String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public String getPortletName() {
            return this.isCloned() ? null : this.portletName;
        }

        @Override
        public String getInvokerName() {
            return this.invokerName;
        }

        @Override
        public boolean isCloned() {
            return this.producerCloned != null;
        }

        @Override
        public boolean isProducerCloned() {
            return this.isCloned() && this.producerCloned != false;
        }

        @Override
        public boolean isConsumerCloned() {
            return this.isCloned() && this.producerCloned == false;
        }

        @Override
        public String getStateId() {
            return this.isCloned() ? this.portletName : null;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public boolean isInterpreted() {
            return true;
        }

        @Override
        public Components createCopyWithoutInvoker() {
            return new InterpretedPortletContextComponents(null, this.applicationName, this.portletName, this.producerCloned);
        }

        @Override
        public Components createCopyWithInvoker(String invoker) {
            return new InterpretedPortletContextComponents(invoker, this.applicationName, this.portletName, this.producerCloned);
        }
    }

    protected static interface Components
    extends PortletContextComponents,
    Serializable {
        public Components createCopyWithoutInvoker();

        public Components createCopyWithInvoker(String var1);
    }

    public static interface PortletContextComponents
    extends Serializable {
        public String getApplicationName();

        public String getPortletName();

        public String getInvokerName();

        public boolean isCloned();

        public boolean isProducerCloned();

        public boolean isConsumerCloned();

        public String getStateId();

        public String getId();

        public boolean isInterpreted();
    }
}

