/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.rest.impl.activity;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.common.RealtimeListAccess;
import org.exoplatform.social.core.activity.filter.ActivitySearchFilter;
import org.exoplatform.social.core.activity.model.ActivitySearchResult;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.jpa.search.ActivitySearchConnector;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.storage.api.ActivityStorage;
import org.exoplatform.social.rest.api.EntityBuilder;
import org.exoplatform.social.rest.api.RestUtils;
import org.exoplatform.social.rest.entity.ActivityEntity;
import org.exoplatform.social.rest.entity.ActivitySearchResultEntity;
import org.exoplatform.social.rest.entity.CollectionEntity;
import org.exoplatform.social.rest.entity.CommentEntity;
import org.exoplatform.social.rest.entity.DataEntity;

@Path(value="v1/social/activities")
@Api(tags={"v1/social/activities"}, value="v1/social/activities", description="Managing activities together with comments and likes")
public class ActivityRestResourcesV1
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(ActivityRestResourcesV1.class);
    private ActivityManager activityManager;
    private IdentityManager identityManager;
    private SpaceService spaceService;
    private ActivitySearchConnector activitySearchConnector;

    public ActivityRestResourcesV1(ActivityManager activityManager, IdentityManager identityManager, SpaceService spaceService, ActivitySearchConnector activitySearchConnector) {
        this.activityManager = activityManager;
        this.identityManager = identityManager;
        this.spaceService = spaceService;
        this.activitySearchConnector = activitySearchConnector;
    }

    @GET
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Gets activities of a specific user", httpMethod="GET", response=Response.class, notes="This returns an activity in the list in the following cases: <br/><ul><li>this is a user activity and the owner of the activity is the authenticated user or one of his connections</li><li>this is a space activity and the authenticated user is a member of the space</li></ul>")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=500, message="Internal server error")})
    public Response getActivities(@Context UriInfo uriInfo, @ApiParam(value="Space technical identifier", required=false) @QueryParam(value="spaceId") String spaceId, @ApiParam(value="offset time to use for searching newer activities until a time identified using format yyyy-MM-dd HH:mm:ss", required=false, defaultValue="0") @QueryParam(value="beforeTime") String beforeTime, @ApiParam(value="offset time to use for searching newer activities since a time identified using format yyyy-MM-dd HH:mm:ss", required=false, defaultValue="0") @QueryParam(value="afterTime") String afterTime, @ApiParam(value="Offset", required=false) @QueryParam(value="offset") int offset, @ApiParam(value="Limit", required=false, defaultValue="20") @QueryParam(value="limit") int limit, @ApiParam(value="Returning the number of activities or not", defaultValue="false") @QueryParam(value="returnSize") boolean returnSize, @ApiParam(value="Asking for a full representation of a specific subresource, ex: <em>comments</em> or <em>likes</em>", required=false) @QueryParam(value="expand") String expand) {
        boolean canPost;
        RealtimeListAccess listAccess;
        offset = offset > 0 ? offset : RestUtils.getOffset(uriInfo);
        limit = limit > 0 ? limit : RestUtils.getLimit(uriInfo);
        Identity currentUser = ConversationState.getCurrent().getIdentity();
        String authenticatedUser = currentUser.getUserId();
        org.exoplatform.social.core.identity.model.Identity currentUserIdentity = this.identityManager.getOrCreateIdentity("organization", authenticatedUser);
        if (currentUserIdentity == null) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        if (StringUtils.isBlank((CharSequence)spaceId)) {
            listAccess = this.activityManager.getActivityFeedWithListAccess(currentUserIdentity);
            canPost = this.activityManager.canPostActivityInStream(currentUser, currentUserIdentity);
        } else {
            Space space = this.spaceService.getSpaceById(spaceId);
            if (space == null || !this.spaceService.isMember(space, authenticatedUser) && !this.spaceService.isSuperManager(authenticatedUser)) {
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            org.exoplatform.social.core.identity.model.Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", space.getPrettyName());
            listAccess = this.activityManager.getActivitiesOfSpaceWithListAccess(spaceIdentity);
            canPost = this.activityManager.canPostActivityInStream(currentUser, spaceIdentity);
        }
        String entitiesName = null;
        List<Object> activityEntities = null;
        boolean retrieveIds = StringUtils.contains((CharSequence)expand, (CharSequence)"ids");
        List activityIds = null;
        if (retrieveIds) {
            activityIds = listAccess.loadIdsAsList(offset, limit);
            activityEntities = activityIds.stream().map(id -> {
                DataEntity dataEntity = new DataEntity();
                dataEntity.setProperty("id", id);
                return dataEntity;
            }).collect(Collectors.toList());
            entitiesName = "activityIds";
        } else {
            List activities = null;
            if (StringUtils.isNotBlank((CharSequence)afterTime)) {
                try {
                    activities = listAccess.loadNewer(Long.valueOf(RestUtils.getBaseTime(afterTime)), limit);
                }
                catch (ParseException e) {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"afterTime Date has to be of format yyyy-MM-dd HH:mm:ss").build();
                }
            } else if (StringUtils.isNotBlank((CharSequence)beforeTime)) {
                try {
                    activities = listAccess.loadOlder(Long.valueOf(RestUtils.getBaseTime(beforeTime)), limit);
                }
                catch (ParseException e) {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"afterTime Date has to be of format yyyy-MM-dd HH:mm:ss").build();
                }
            } else {
                activities = listAccess.loadAsList(offset, limit);
            }
            activityEntities = this.convertToEntities(activities, currentUserIdentity, uriInfo, expand);
            entitiesName = "activities";
        }
        CollectionEntity collectionActivity = new CollectionEntity(activityEntities, entitiesName, offset, limit);
        if (returnSize) {
            collectionActivity.setSize(listAccess.getSize());
        }
        collectionActivity.put("canPost", canPost);
        Response.ResponseBuilder responseBuilder = EntityBuilder.getResponseBuilder(collectionActivity, uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
        if (activityIds != null && !activityIds.isEmpty()) {
            int preloadLimit = limit / 2;
            String preloadExpand = expand.replaceFirst(",?ids,?", "");
            this.addPreloadActivityIds(activityIds, preloadLimit, preloadExpand, responseBuilder);
        }
        return responseBuilder.build();
    }

    @POST
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Posts an activity to a specific space", httpMethod="POST", response=Response.class, produces="application/json", notes="This posts the activity if the authenticated user is a member of the space or a spaces super manager.")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input")})
    public Response postActivity(@Context UriInfo uriInfo, @ApiParam(value="Space id", required=true) @QueryParam(value="spaceId") String spaceId, @ApiParam(value="Asking for a full representation of a specific subresource, ex: comments or likes", required=false) @QueryParam(value="expand") String expand, @ApiParam(value="Activity object to be created", required=true) ActivityEntity model) {
        if (model == null) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        Identity currentUser = ConversationState.getCurrent().getIdentity();
        String authenticatedUser = currentUser.getUserId();
        org.exoplatform.social.core.identity.model.Identity authenticatedUserIdentity = this.identityManager.getOrCreateIdentity("organization", authenticatedUser);
        org.exoplatform.social.core.identity.model.Identity spaceIdentity = null;
        if (StringUtils.isNotBlank((CharSequence)spaceId)) {
            Space space = this.spaceService.getSpaceById(spaceId);
            if (space == null) {
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            spaceIdentity = this.identityManager.getOrCreateIdentity("space", space.getPrettyName());
            if (!this.activityManager.canPostActivityInStream(currentUser, spaceIdentity)) {
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
        } else if (!this.activityManager.canPostActivityInStream(currentUser, authenticatedUserIdentity)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        if (StringUtils.isBlank((CharSequence)model.getTitle())) {
            activity.setTitle("");
        } else {
            activity.setTitle(model.getTitle());
        }
        activity.setBody(model.getBody());
        activity.setType(model.getType());
        activity.setUserId(authenticatedUserIdentity.getId());
        activity.setFiles(model.getFiles());
        EntityBuilder.buildActivityParamsFromEntity((ExoSocialActivity)activity, model.getTemplateParams());
        if (StringUtils.isBlank((CharSequence)spaceId)) {
            this.activityManager.saveActivityNoReturn(authenticatedUserIdentity, (ExoSocialActivity)activity);
        } else {
            this.activityManager.saveActivityNoReturn(spaceIdentity, (ExoSocialActivity)activity);
        }
        ActivityEntity activityEntity = EntityBuilder.buildEntityFromActivity((ExoSocialActivity)activity, authenticatedUserIdentity, uriInfo.getPath(), expand);
        return EntityBuilder.getResponse(activityEntity.getDataEntity(), uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @GET
    @Path(value="{activityId}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Gets a specific activity by id", httpMethod="GET", response=Response.class, notes="This returns the activity in the following cases: <br/><ul><li>this is a user activity and the owner of the activity is the authenticated user or one of his connections</li><li>this is a space activity and the authenticated user is a member of the space</li><li>the authenticated user is the super user</li></ul>")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input")})
    public Response getActivityById(@Context UriInfo uriInfo, @Context Request request, @ApiParam(value="Activity id", required=true) @PathParam(value="activityId") String activityId, @ApiParam(value="Asking for a full representation of a specific subresource, ex: comments or likes", required=false) @QueryParam(value="expand") String expand) {
        Identity authenticatedUserIdentity = ConversationState.getCurrent().getIdentity();
        String authenticatedUser = authenticatedUserIdentity.getUserId();
        org.exoplatform.social.core.identity.model.Identity currentUser = this.identityManager.getOrCreateIdentity("organization", authenticatedUser);
        ExoSocialActivity activity = this.activityManager.getActivity(activityId);
        if (activity == null || !this.activityManager.isActivityViewable(activity, authenticatedUserIdentity)) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        long cacheTime = activity.getCacheTime();
        String eTagValue = expand == null ? String.valueOf(cacheTime) : String.valueOf((long)expand.hashCode() + cacheTime);
        EntityTag eTag = new EntityTag(eTagValue, true);
        Response.ResponseBuilder builder = request.evaluatePreconditions(eTag);
        if (builder == null) {
            ActivityEntity activityEntity = EntityBuilder.buildEntityFromActivity(activity, currentUser, uriInfo.getPath(), expand);
            builder = Response.ok((Object)activityEntity.getDataEntity(), (String)"application/json");
            builder.tag(eTag);
            builder.lastModified(new Date(cacheTime));
            builder.expires(new Date(cacheTime));
        }
        return builder.build();
    }

    @PUT
    @Path(value="{activityId}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Updates a specific activity by id", httpMethod="PUT", response=Response.class, notes="This updates the activity in the following cases: <br/><ul><li>this is a user activity and the owner of the activity is the authenticated user</li><li>the authenticated user is the super user</li></ul>")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input")})
    public Response updateActivityById(@Context UriInfo uriInfo, @ApiParam(value="Activity id", required=true) @PathParam(value="activityId") String activityId, @ApiParam(value="Asking for a full representation of a specific subresource, ex: comments or likes", required=false) @QueryParam(value="expand") String expand, @ApiParam(value="Activity object to be updated, ex: <br/>{<br/>\"title\" : \"My activity\"<br/>}", required=true) ActivityEntity model) {
        if (model == null) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        Identity authenticatedUserIdentity = ConversationState.getCurrent().getIdentity();
        String authenticatedUser = authenticatedUserIdentity.getUserId();
        org.exoplatform.social.core.identity.model.Identity currentUser = this.identityManager.getOrCreateIdentity("organization", authenticatedUser);
        ExoSocialActivity activity = this.activityManager.getActivity(activityId);
        if (!this.activityManager.isActivityEditable(activity, authenticatedUserIdentity)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        EntityBuilder.buildActivityFromEntity(model, activity);
        activity.setFiles(model.getFiles());
        activity.setUpdated(Long.valueOf(System.currentTimeMillis()));
        this.activityManager.updateActivity(activity, true);
        ActivityEntity activityInfo = EntityBuilder.buildEntityFromActivity(activity, currentUser, uriInfo.getPath(), expand);
        return EntityBuilder.getResponse(activityInfo.getDataEntity(), uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @DELETE
    @Path(value="{activityId}")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Deletes a specific activity by id", httpMethod="DELETE", response=Response.class, notes="This deletes the activity in the following cases: <br/><ul><li>this is a user activity and the owner of the activity is the authenticated user</li><li>the authenticated user is the super user</li></ul>")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input")})
    public Response deleteActivityById(@Context UriInfo uriInfo, @ApiParam(value="Activity id", required=true) @PathParam(value="activityId") String activityId, @ApiParam(value="Whether to just hide the activity or effectively delete it from database", defaultValue="false", required=false) @QueryParam(value="hide") boolean hide, @ApiParam(value="Asking for a full representation of a specific subresource if any", required=false) @QueryParam(value="expand") String expand) {
        ActivityEntity activityEntity;
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        org.exoplatform.social.core.identity.model.Identity currentUser = this.identityManager.getOrCreateIdentity("organization", authenticatedUser);
        ExoSocialActivity activity = this.activityManager.getActivity(activityId);
        if (activity == null || !this.activityManager.isActivityDeletable(activity, ConversationState.getCurrent().getIdentity())) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        if (hide) {
            activity = this.activityManager.hideActivity(activity.getId());
            activityEntity = EntityBuilder.buildEntityFromActivity(activity, currentUser, uriInfo.getPath(), expand);
        } else {
            activityEntity = EntityBuilder.buildEntityFromActivity(activity, currentUser, uriInfo.getPath(), expand);
            this.activityManager.deleteActivity(activity);
        }
        return EntityBuilder.getResponse(activityEntity.getDataEntity(), uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @GET
    @Path(value="{activityId}/comments")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Gets comments of a specific activity", httpMethod="GET", response=Response.class, notes="This returns a list of comments if the authenticated user has permissions to see the activity.")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input")})
    public Response getComments(@Context UriInfo uriInfo, @ApiParam(value="Activity id", required=true) @PathParam(value="activityId") String activityId, @ApiParam(value="Offset", required=false, defaultValue="0") @QueryParam(value="offset") int offset, @ApiParam(value="Limit", required=false, defaultValue="20") @QueryParam(value="limit") int limit, @ApiParam(value="Returning the number of activities or not", defaultValue="false") @QueryParam(value="returnSize") boolean returnSize, @ApiParam(value="Retrieve comments by last post time or by first post time", defaultValue="false") @QueryParam(value="sortDescending") boolean sortDescending, @ApiParam(value="Asking for a full representation of a specific subresource if any", required=false) @QueryParam(value="expand") String expand) {
        offset = offset > 0 ? offset : RestUtils.getOffset(uriInfo);
        limit = limit > 0 ? limit : RestUtils.getLimit(uriInfo);
        Identity currentUserIdentity = ConversationState.getCurrent().getIdentity();
        String authenticatedUser = currentUserIdentity.getUserId();
        org.exoplatform.social.core.identity.model.Identity currentUser = this.identityManager.getOrCreateIdentity("organization", authenticatedUser);
        ExoSocialActivity activity = this.activityManager.getActivity(activityId);
        if (activity == null || !this.activityManager.isActivityViewable(activity, currentUserIdentity)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        List<DataEntity> commentsEntity = EntityBuilder.buildEntityFromComment(activity, currentUser, uriInfo.getPath(), expand, sortDescending, offset, limit);
        CollectionEntity collectionComment = new CollectionEntity(commentsEntity, "comments", offset, limit);
        if (returnSize) {
            boolean expandSubComments = EntityBuilder.expandSubComments(expand);
            RealtimeListAccess listAccess = this.activityManager.getCommentsWithListAccess(activity, expandSubComments);
            collectionComment.setSize(listAccess.getSize());
        }
        return EntityBuilder.getResponse(collectionComment, uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @POST
    @Path(value="{activityId}/comments")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Posts a comment on a specific activity", httpMethod="POST", response=Response.class, notes="This posts the comment if the authenticated user has permissions to see the activity.")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input")})
    public Response postComment(@Context UriInfo uriInfo, @ApiParam(value="Activity id", required=true) @PathParam(value="activityId") String activityId, @ApiParam(value="Asking for a full representation of a specific subresource if any", required=false) @QueryParam(value="expand") String expand, @ApiParam(value="Comment object to be posted, ex: <br/>{<br/>\"title\" : \"My comment\"<br/>}", required=true) CommentEntity model) {
        if (model == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Comment entity is mandatory").build();
        }
        if (StringUtils.isNotBlank((CharSequence)model.getId())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"comment identifier is not expected for comment creation").build();
        }
        if (StringUtils.isBlank((CharSequence)model.getTitle())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"comment title is mandatory").build();
        }
        Identity authenticatedUserIdentity = ConversationState.getCurrent().getIdentity();
        String authenticatedUser = authenticatedUserIdentity.getUserId();
        org.exoplatform.social.core.identity.model.Identity currentUser = this.identityManager.getOrCreateIdentity("organization", authenticatedUser);
        ExoSocialActivity activity = this.activityManager.getActivity(activityId);
        if (activity == null || !this.activityManager.isActivityViewable(activity, authenticatedUserIdentity)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        ExoSocialActivityImpl comment = new ExoSocialActivityImpl();
        comment.setParentCommentId(model.getParentCommentId());
        comment.setPosterId(currentUser.getId());
        comment.setUserId(currentUser.getId());
        EntityBuilder.buildActivityFromEntity(model, (ExoSocialActivity)comment);
        this.activityManager.saveComment(activity, (ExoSocialActivity)comment);
        CommentEntity commentEntity = EntityBuilder.buildEntityFromComment(this.activityManager.getActivity(comment.getId()), currentUser, uriInfo.getPath(), expand, false);
        return EntityBuilder.getResponse(commentEntity.getDataEntity(), uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @PUT
    @Path(value="{activityId}/comments")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Updates an existing comment", httpMethod="PUT", response=Response.class, notes="This updates an existing comment if the authenticated user is poster of the comment.")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input")})
    public Response updateComment(@Context UriInfo uriInfo, @ApiParam(value="Activity id", required=true) @PathParam(value="activityId") String activityId, @ApiParam(value="Asking for a full representation of a specific subresource if any", required=false) @QueryParam(value="expand") String expand, @ApiParam(value="Comment object to be posted, ex: <br/>{<br/>\"title\" : \"My comment\"<br/>}", required=true) CommentEntity model) {
        if (model == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Comment entity is mandatory").build();
        }
        if (StringUtils.isBlank((CharSequence)model.getId())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"comment identifier id mandatory").build();
        }
        if (StringUtils.isBlank((CharSequence)model.getTitle())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"comment title is mandatory").build();
        }
        Identity authenticatedUserIdentity = ConversationState.getCurrent().getIdentity();
        String authenticatedUser = authenticatedUserIdentity.getUserId();
        org.exoplatform.social.core.identity.model.Identity currentUser = this.identityManager.getOrCreateIdentity("organization", authenticatedUser);
        ExoSocialActivity comment = this.activityManager.getActivity(model.getId());
        if (comment == null) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        if (!comment.isComment() || StringUtils.isBlank((CharSequence)comment.getParentId())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"activity can't be updated as a comment").build();
        }
        if (!StringUtils.equals((CharSequence)comment.getParentId(), (CharSequence)activityId)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"Can't move a comment from an activity to another").build();
        }
        if (!StringUtils.equals((CharSequence)comment.getParentCommentId(), (CharSequence)model.getParentCommentId())) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"Can't move a comment reply from a comment to another").build();
        }
        if (!this.activityManager.isActivityEditable(comment, authenticatedUserIdentity)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        EntityBuilder.buildActivityFromEntity(model, comment);
        comment.setFiles(model.getFiles());
        comment.setUpdated(Long.valueOf(System.currentTimeMillis()));
        this.activityManager.updateActivity(comment, true);
        CommentEntity commentEntity = EntityBuilder.buildEntityFromComment(this.activityManager.getActivity(comment.getId()), currentUser, uriInfo.getPath(), expand, false);
        return EntityBuilder.getResponse(commentEntity.getDataEntity(), uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @POST
    @Path(value="{activityId}/share")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Shares a specific activity to specific spaces", httpMethod="POST", response=Response.class, notes="This shares the given activity to the target spaces if the authenticated user has permissions to post to the target spaces")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input")})
    public Response shareActivity(@Context UriInfo uriInfo, @ApiParam(value="Activity id", required=true) @PathParam(value="activityId") String activityId, @ApiParam(value="Asking for a full representation of a specific subresource, ex: comments or likes", required=false) @QueryParam(value="expand") String expand, @ApiParam(value="Share target spaces", required=true) ActivityEntity model) {
        List sharedActivities;
        if (StringUtils.isBlank((CharSequence)activityId)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (model == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        List<String> targetSpaces = model.getTargetSpaces();
        if (targetSpaces == null || targetSpaces.isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        Identity currentUser = ConversationState.getCurrent().getIdentity();
        String authenticatedUser = currentUser.getUserId();
        org.exoplatform.social.core.identity.model.Identity authenticatedUserIdentity = this.identityManager.getOrCreateIdentity("organization", authenticatedUser);
        ExoSocialActivityImpl activityTemplate = new ExoSocialActivityImpl();
        activityTemplate.setTitle(model.getTitle());
        activityTemplate.setBody(model.getBody());
        activityTemplate.setType(model.getType());
        activityTemplate.setUserId(authenticatedUserIdentity.getId());
        activityTemplate.setFiles(model.getFiles());
        EntityBuilder.buildActivityParamsFromEntity((ExoSocialActivity)activityTemplate, model.getTemplateParams());
        try {
            sharedActivities = this.activityManager.shareActivity((ExoSocialActivity)activityTemplate, activityId, targetSpaces, currentUser);
        }
        catch (IllegalAccessException e) {
            LOG.warn("User {} doesn't have access to share activity {}", new Object[]{authenticatedUser, activityId, e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (ObjectNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)e.getMessage()).build();
        }
        List<DataEntity> sharedActivityEntities = this.convertToEntities(sharedActivities, authenticatedUserIdentity, uriInfo, expand);
        CollectionEntity collectionActivity = new CollectionEntity(sharedActivityEntities, "activities", 0, sharedActivityEntities.size());
        return EntityBuilder.getResponse(collectionActivity, uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @GET
    @Path(value="{activityId}/likes")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Gets likes of a specific activity", httpMethod="GET", response=Response.class, produces="application/json", notes="This returns a list of likes if the authenticated user has permissions to see the activity.")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input")})
    public Response getLikesOfActivity(@Context UriInfo uriInfo, @ApiParam(value="Activity id", required=true) @PathParam(value="activityId") String activityId, @ApiParam(value="Offset", required=false, defaultValue="0") @QueryParam(value="offset") int offset, @ApiParam(value="Limit", required=false, defaultValue="20") @QueryParam(value="limit") int limit, @ApiParam(value="Asking for a full representation of a specific subresource if any", required=false) @QueryParam(value="expand") String expand) {
        offset = offset > 0 ? offset : RestUtils.getOffset(uriInfo);
        limit = limit > 0 ? limit : RestUtils.getLimit(uriInfo);
        Identity authenticatedUserIdentity = ConversationState.getCurrent().getIdentity();
        ExoSocialActivity activity = this.activityManager.getActivity(activityId);
        if (activity == null || !this.activityManager.isActivityViewable(activity, authenticatedUserIdentity)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        List<DataEntity> likesEntity = EntityBuilder.buildEntityFromLike(activity, uriInfo.getPath(), expand, offset, limit);
        CollectionEntity collectionLike = new CollectionEntity(likesEntity, "likes", offset, limit);
        collectionLike.setSize(activity.getLikeIdentityIds() == null ? 0 : activity.getLikeIdentityIds().length);
        return EntityBuilder.getResponse(collectionLike, uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @POST
    @Path(value="{activityId}/likes")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Adds a like to a specific activity", httpMethod="POST", response=Response.class, produces="application/json", notes="This adds the like if the authenticated user has permissions to see the activity.")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input")})
    public Response addLike(@Context UriInfo uriInfo, @Context Request request, @ApiParam(value="Activity id", required=true) @PathParam(value="activityId") String activityId) {
        Identity authenticatedUserIdentity = ConversationState.getCurrent().getIdentity();
        String authenticatedUser = authenticatedUserIdentity.getUserId();
        org.exoplatform.social.core.identity.model.Identity currentUser = this.identityManager.getOrCreateIdentity("organization", authenticatedUser);
        ExoSocialActivity activity = this.activityManager.getActivity(activityId);
        if (activity == null || !this.activityManager.isActivityViewable(activity, authenticatedUserIdentity)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        this.activityManager.saveLike(activity, currentUser);
        return this.getLikesOfActivity(uriInfo, activityId, 0, 20, null);
    }

    @DELETE
    @Path(value="{activityId}/likes")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Deletes a like of a specific user for a given activity", httpMethod="DELETE", response=Response.class, produces="application/json", notes="This deletes the like of authenticated user from an activity")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input")})
    public Response deleteLike(@Context UriInfo uriInfo, @Context Request request, @ApiParam(value="Activity id", required=true) @PathParam(value="activityId") String activityId) {
        Identity authenticatedUserIdentity = ConversationState.getCurrent().getIdentity();
        String authenticatedUser = authenticatedUserIdentity.getUserId();
        org.exoplatform.social.core.identity.model.Identity currentUser = this.identityManager.getOrCreateIdentity("organization", authenticatedUser);
        ExoSocialActivity activity = this.activityManager.getActivity(activityId);
        if (activity == null || !this.activityManager.isActivityViewable(activity, authenticatedUserIdentity)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        this.activityManager.deleteLike(activity, currentUser);
        return this.getLikesOfActivity(uriInfo, activityId, 0, 20, null);
    }

    @GET
    @Path(value="search")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Search activities using a query", httpMethod="GET", response=Response.class, notes="This returns a list of activities found by using search term")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input")})
    public Response searchActivities(@Context UriInfo uriInfo, @ApiParam(value="Term to search", required=true) @QueryParam(value="q") String query, @ApiParam(value="Offset", required=false, defaultValue="0") @QueryParam(value="offset") int offset, @ApiParam(value="Limit", required=false, defaultValue="20") @QueryParam(value="limit") int limit) {
        offset = offset > 0 ? offset : RestUtils.getOffset(uriInfo);
        int n = limit = limit > 0 ? limit : RestUtils.getLimit(uriInfo);
        if (StringUtils.isBlank((CharSequence)query)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"'q' parameter is mandatory").build();
        }
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        org.exoplatform.social.core.identity.model.Identity currentUser = this.identityManager.getOrCreateIdentity("organization", authenticatedUser);
        ActivitySearchFilter filter = new ActivitySearchFilter(query);
        List searchResults = this.activitySearchConnector.search(currentUser, filter, (long)offset, (long)limit);
        List results = searchResults.stream().map(searchResult -> {
            ActivitySearchResultEntity entity = new ActivitySearchResultEntity((ActivitySearchResult)searchResult);
            entity.setPoster(EntityBuilder.buildEntityIdentity(searchResult.getPoster(), uriInfo.getPath(), "all"));
            entity.setStreamOwner(EntityBuilder.buildEntityIdentity(searchResult.getStreamOwner(), uriInfo.getPath(), "all"));
            ActivitySearchResult comment = searchResult.getComment();
            if (comment != null) {
                ActivitySearchResultEntity commentEntity = new ActivitySearchResultEntity(comment);
                commentEntity.setPoster(EntityBuilder.buildEntityIdentity(comment.getPoster(), uriInfo.getPath(), "all"));
                commentEntity.setStreamOwner(EntityBuilder.buildEntityIdentity(comment.getStreamOwner(), uriInfo.getPath(), "all"));
                entity.setComment(commentEntity);
            }
            ActivityStorage activityStorage = (ActivityStorage)CommonsUtils.getService(ActivityStorage.class);
            ExoSocialActivity existingActivity = activityStorage.getActivity(entity.getId());
            int commentsCount = activityStorage.getNumberOfComments(existingActivity);
            entity.setCommentsCount(commentsCount);
            entity.setLikesCount(existingActivity.getNumberOfLikes());
            return entity;
        }).collect(Collectors.toList());
        return Response.ok(results).build();
    }

    private List<DataEntity> convertToEntities(List<ExoSocialActivity> activities, org.exoplatform.social.core.identity.model.Identity currentUserIdentity, UriInfo uriInfo, String expand) {
        ArrayList<DataEntity> activityEntities = new ArrayList<DataEntity>();
        for (ExoSocialActivity activity : activities) {
            ActivityEntity activityEntity = EntityBuilder.buildEntityFromActivity(activity, currentUserIdentity, uriInfo.getPath(), expand);
            activityEntities.add(activityEntity.getDataEntity());
        }
        return activityEntities;
    }

    private void addPreloadActivityIds(List<String> activityIds, int preloadLimit, String expand, Response.ResponseBuilder responseBuilder) {
        List<String> preloadActivities = activityIds.size() >= preloadLimit ? activityIds.subList(0, preloadLimit) : activityIds;
        preloadActivities.forEach(activityId -> {
            String activityLoadingURL = "/portal/rest/v1/social/activities/" + activityId + "?expand=" + expand;
            responseBuilder.header("Link", (Object)("<" + activityLoadingURL + ">; rel=preload; as=fetch; crossorigin=use-credentials"));
        });
    }
}

