/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.kudos.service.utils;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.notification.model.ArgumentLiteral;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.kudos.entity.KudosEntity;
import org.exoplatform.kudos.model.GlobalSettings;
import org.exoplatform.kudos.model.Kudos;
import org.exoplatform.kudos.model.KudosEntityType;
import org.exoplatform.kudos.model.KudosPeriod;
import org.exoplatform.kudos.model.KudosPeriodType;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.processor.I18NActivityUtils;
import org.exoplatform.social.core.service.LinkProvider;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public class Utils {
    private static final Log LOG = ExoLogger.getLogger(Utils.class);
    public static final String KUDOS_ICON = "<i class='uiIcon fa fa-award uiIconKudos uiIconBlue'></i>";
    public static final String SCOPE_NAME = "ADDONS_KUDOS";
    public static final String SETTINGS_KEY_NAME = "ADDONS_KUDOS_SETTINGS";
    public static final Context KUDOS_CONTEXT = Context.GLOBAL;
    public static final Scope KUDOS_SCOPE = Scope.APPLICATION.id("ADDONS_KUDOS");
    public static final String SPACE_ACCOUNT_TYPE = "space";
    public static final String USER_ACCOUNT_TYPE = "user";
    public static final String DEFAULT_ACCESS_PERMISSION = "defaultAccessPermission";
    public static final String DEFAULT_KUDOS_PER_PERIOD = "defaultKudosPerPeriod";
    public static final String KUDOS_RECEIVER_NOTIFICATION_ID = "KudosActivityReceiverNotificationPlugin";
    public static final String KUDOS_SENT_EVENT = "exo.kudos.sent";
    public static final String KUDOS_ACTIVITY_EVENT = "exo.kudos.activity";
    public static final String GAMIFICATION_GENERIC_EVENT = "exo.gamification.generic.action";
    public static final String KUDOS_ACTIVITY_COMMENT_TYPE = "exokudos:activity";
    public static final String KUDOS_ACTIVITY_COMMENT_TITLE_ID = "activity_kudos_content";
    public static final String KUDOS_MESSAGE_PARAM = "kudosMessage";
    public static final ArgumentLiteral<Kudos> KUDOS_DETAILS_PARAMETER = new ArgumentLiteral(Kudos.class, "kudos");
    public static final String ACTIVITY_COMMENT_ID_PREFIX = "comment";

    private Utils() {
    }

    public static Space getSpace(String id) {
        SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
        if (id.indexOf("/spaces") >= 0) {
            return spaceService.getSpaceByGroupId(id);
        }
        Space space = spaceService.getSpaceById(id);
        if (space == null && (space = spaceService.getSpaceByPrettyName(id)) == null && (space = spaceService.getSpaceByGroupId("/spaces/" + id)) == null && (space = spaceService.getSpaceByDisplayName(id)) == null) {
            space = spaceService.getSpaceByUrl(id);
        }
        return space;
    }

    public static final String getCurrentUserId() {
        if (ConversationState.getCurrent() != null && ConversationState.getCurrent().getIdentity() != null) {
            return ConversationState.getCurrent().getIdentity().getUserId();
        }
        return null;
    }

    public static List<String> getNotificationReceiversUsers(String receiverType, String receiverId, String senderId) {
        if (SPACE_ACCOUNT_TYPE.equals(receiverType)) {
            Space space = Utils.getSpace(receiverId);
            if (space == null) {
                return Collections.singletonList(receiverId);
            }
            String[] members = space.getMembers();
            if (members == null || members.length == 0) {
                return Collections.emptyList();
            }
            if (StringUtils.isBlank((CharSequence)senderId)) {
                return Arrays.asList(members);
            }
            return Arrays.stream(members).filter(member -> !senderId.equals(member)).collect(Collectors.toList());
        }
        return Collections.singletonList(receiverId);
    }

    public static String getReceiverIdentityProviderType(String receiverType) {
        return SPACE_ACCOUNT_TYPE.equals(receiverType) ? SPACE_ACCOUNT_TYPE : "organization";
    }

    public static String getReceiverType(String receiverType) {
        return SPACE_ACCOUNT_TYPE.equals(receiverType) ? SPACE_ACCOUNT_TYPE : USER_ACCOUNT_TYPE;
    }

    public static Kudos fromEntity(KudosEntity kudosEntity) {
        if (kudosEntity == null) {
            return null;
        }
        Kudos kudos = new Kudos();
        kudos.setTechnicalId(kudosEntity.getId());
        kudos.setMessage(kudosEntity.getMessage());
        kudos.setEntityId(String.valueOf(kudosEntity.getEntityId()));
        kudos.setActivityId(kudosEntity.getActivityId());
        if (kudosEntity.getParentEntityId() != null && kudosEntity.getParentEntityId() != 0L) {
            kudos.setParentEntityId(String.valueOf(kudosEntity.getParentEntityId()));
        }
        kudos.setEntityType(KudosEntityType.values()[kudosEntity.getEntityType()].name());
        kudos.setTimeInSeconds(kudosEntity.getCreatedDate());
        if (kudosEntity.isReceiverUser()) {
            Identity receiverIdentity = Utils.getIdentityById(kudosEntity.getReceiverId());
            kudos.setReceiverId(receiverIdentity.getRemoteId());
            kudos.setReceiverIdentityId(Utils.getIdentityIdByType(receiverIdentity));
            kudos.setReceiverType(USER_ACCOUNT_TYPE);
            kudos.setReceiverFullName(receiverIdentity.getProfile().getFullName());
            kudos.setReceiverURL(LinkProvider.getUserProfileUri((String)receiverIdentity.getRemoteId()));
            kudos.setReceiverAvatar(Utils.getAvatar(receiverIdentity, null));
        } else {
            Space space = Utils.getSpace(String.valueOf(kudosEntity.getReceiverId()));
            if (space != null) {
                kudos.setReceiverId(space.getPrettyName());
                kudos.setReceiverIdentityId(String.valueOf(kudosEntity.getReceiverId()));
                kudos.setReceiverType(SPACE_ACCOUNT_TYPE);
                kudos.setReceiverFullName(space.getDisplayName());
                kudos.setReceiverURL(LinkProvider.getActivityUriForSpace((String)space.getPrettyName(), (String)space.getGroupId().replace("/spaces/", "")));
                kudos.setReceiverAvatar(Utils.getAvatar(null, space));
            }
        }
        Identity senderIdentity = Utils.getIdentityById(kudosEntity.getSenderId());
        kudos.setSenderId(senderIdentity.getRemoteId());
        kudos.setSenderIdentityId(Utils.getIdentityIdByType(senderIdentity));
        kudos.setSenderFullName(senderIdentity.getProfile().getFullName());
        kudos.setSenderURL(LinkProvider.getUserProfileUri((String)senderIdentity.getRemoteId()));
        kudos.setSenderAvatar(Utils.getAvatar(senderIdentity, null));
        return kudos;
    }

    public static KudosEntity toEntity(Kudos kudos) {
        KudosEntity kudosEntity = new KudosEntity();
        kudosEntity.setId(kudos.getTechnicalId());
        kudosEntity.setMessage(kudos.getMessage());
        kudosEntity.setEntityId(Long.parseLong(kudos.getEntityId()));
        kudosEntity.setActivityId(kudos.getActivityId());
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{kudos.getParentEntityId()})) {
            kudosEntity.setParentEntityId(Long.parseLong(kudos.getParentEntityId()));
        }
        kudosEntity.setEntityType(KudosEntityType.valueOf(kudos.getEntityType()).ordinal());
        kudosEntity.setSenderId(Long.parseLong(kudos.getSenderIdentityId()));
        boolean isReceiverUser = "organization".equals(kudos.getReceiverType()) || USER_ACCOUNT_TYPE.equals(kudos.getReceiverType());
        kudosEntity.setReceiverUser(isReceiverUser);
        kudosEntity.setReceiverId(Long.parseLong(kudos.getReceiverIdentityId()));
        kudosEntity.setCreatedDate(kudos.getTimeInSeconds());
        return kudosEntity;
    }

    public static LocalDateTime timeFromSeconds(long createdDate) {
        return LocalDateTime.ofInstant(Instant.ofEpochSecond(createdDate), TimeZone.getDefault().toZoneId());
    }

    public static long timeToSeconds(LocalDateTime time) {
        return time.atZone(ZoneId.systemDefault()).toEpochSecond();
    }

    public static KudosPeriod getCurrentPeriod(GlobalSettings globalSettings) {
        return Utils.getPeriodOfTime(globalSettings, LocalDateTime.now());
    }

    public static Identity getIdentityByTypeAndId(String type, String name) {
        IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
        return identityManager.getOrCreateIdentity(type, name);
    }

    public static KudosPeriod getPeriodOfTime(GlobalSettings globalSettings, LocalDateTime localDateTime) {
        KudosPeriodType kudosPeriodType = Utils.getPeriodType(globalSettings);
        return kudosPeriodType.getPeriodOfTime(localDateTime);
    }

    public static KudosPeriodType getPeriodType(GlobalSettings globalSettings) {
        KudosPeriodType kudosPeriodType = null;
        if (globalSettings == null || globalSettings.getKudosPeriodType() == null) {
            LOG.warn((Object)("Provided globalSettings doesn't have a parametred kudos period type, using MONTH period type: " + globalSettings), (Throwable)new RuntimeException());
            kudosPeriodType = KudosPeriodType.DEFAULT;
        } else {
            kudosPeriodType = globalSettings.getKudosPeriodType();
        }
        return kudosPeriodType;
    }

    public static void computeKudosActivityProperties(ExoSocialActivity activity, Kudos kudos) {
        Object message;
        Object senderLink = "<a href='" + kudos.getSenderURL() + "'>" + kudos.getSenderFullName() + "</a>";
        senderLink = StringEscapeUtils.unescapeHtml((String)senderLink);
        Object receiverLink = "<a href='" + kudos.getReceiverURL() + "'>" + kudos.getReceiverFullName() + "</a>";
        receiverLink = StringEscapeUtils.unescapeHtml((String)receiverLink);
        String kudosMessage = kudos.getMessage();
        Object object = message = StringUtils.isBlank((CharSequence)kudosMessage) ? "." : ": " + kudosMessage;
        if (activity.getTemplateParams() != null) {
            activity.getTemplateParams().remove("registeredKeysForProcessor");
            activity.getTemplateParams().remove("RESOURCE_BUNDLE_KEY_TO_PROCESS");
            activity.getTemplateParams().remove("RESOURCE_BUNDLE_VALUES_PARAM");
            activity.getTemplateParams().remove(KUDOS_MESSAGE_PARAM);
        }
        activity.setTitleId(null);
        I18NActivityUtils.addResourceKeyToProcess((ExoSocialActivity)activity, (String)KUDOS_ACTIVITY_COMMENT_TITLE_ID);
        I18NActivityUtils.addResourceKey((ExoSocialActivity)activity, (String)KUDOS_ACTIVITY_COMMENT_TITLE_ID, (String[])new String[]{senderLink, receiverLink, message, KUDOS_ICON});
        activity.getTemplateParams().put("registeredKeysForProcessor", "RESOURCE_BUNDLE_VALUES_PARAM\\|kudosMessage");
        activity.getTemplateParams().put(KUDOS_MESSAGE_PARAM, kudosMessage);
    }

    private static String getIdentityIdByType(Identity receiverIdentity) {
        Space space;
        if (SPACE_ACCOUNT_TYPE.equals(receiverIdentity.getProviderId()) && (space = Utils.getSpace(receiverIdentity.getRemoteId())) != null) {
            return space.getId();
        }
        return receiverIdentity.getId();
    }

    private static Identity getIdentityById(long identityId) {
        IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
        return identityManager.getIdentity(String.valueOf(identityId));
    }

    private static String getAvatar(Identity identity, Space space) {
        Object avatarUrl = null;
        if (identity != null && identity.getProfile() != null) {
            avatarUrl = identity.getProfile().getAvatarUrl();
            if (StringUtils.isBlank((CharSequence)avatarUrl)) {
                avatarUrl = "/rest/v1/social/users/" + identity.getRemoteId() + "/avatar";
            }
        } else if (space != null && StringUtils.isBlank((CharSequence)(avatarUrl = space.getAvatarUrl()))) {
            avatarUrl = "/rest/v1/social/spaces/" + space.getPrettyName() + "/avatar";
        }
        return avatarUrl;
    }

    public static long getActivityId(String id) {
        return StringUtils.isBlank((CharSequence)id) ? null : Long.valueOf(id.replace(ACTIVITY_COMMENT_ID_PREFIX, ""));
    }
}

