/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata;

import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.apache.sis.internal.jaxb.lan.LocaleAndCharset;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.metadata.CacheKey;
import org.apache.sis.metadata.KeyNamePolicy;
import org.apache.sis.metadata.PropertyAccessor;
import org.apache.sis.metadata.SpecialCases;
import org.apache.sis.metadata.TreeNodeChildren;
import org.apache.sis.metadata.TreeTableView;
import org.apache.sis.metadata.TypeValuePolicy;
import org.apache.sis.metadata.ValueExistencePolicy;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Classes;
import org.apache.sis.util.ObjectConverters;
import org.apache.sis.util.collection.CheckedContainer;
import org.apache.sis.util.collection.TableColumn;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;

class TreeNode
implements TreeTable.Node {
    private static final Collection<TreeTable.Node> LEAF = Collections.emptySet();
    final TreeTableView table;
    private final TreeNode parent;
    final Object metadata;
    final Class<?> baseType;
    private transient CharSequence name;
    private transient Collection<TreeTable.Node> children;
    transient Object cachedValue;

    TreeNode(TreeTableView treeTableView, Object object, Class<?> clazz) {
        this.table = treeTableView;
        this.parent = null;
        this.metadata = object;
        this.baseType = clazz;
    }

    private TreeNode(TreeNode treeNode, Object object, Class<?> clazz) {
        this.table = treeNode.table;
        this.parent = treeNode;
        this.metadata = object;
        this.baseType = clazz;
        if (!this.isMetadata(clazz)) {
            this.children = LEAF;
        }
    }

    final boolean isMetadata(Class<?> clazz) {
        return this.table.standard.isMetadata(clazz);
    }

    private CacheKey key() {
        return new CacheKey(this.metadata.getClass(), this.baseType);
    }

    String getIdentifier() {
        Class clazz = this.table.standard.getInterface(this.key());
        String string = Types.getStandardName(clazz);
        return string != null ? string : Classes.getShortName(clazz);
    }

    Integer getIndex() {
        return null;
    }

    CharSequence getName() {
        return CharSequences.camelCaseToSentence((CharSequence)Classes.getShortName(this.table.standard.getInterface(this.key()))).toString();
    }

    CharSequence getRemarks() {
        return null;
    }

    void appendIdentifier(StringBuilder stringBuilder) {
        stringBuilder.append(Classes.getShortClassName((Object)this.metadata));
    }

    public Object getUserObject() {
        return this.metadata;
    }

    void setUserObject(Object object) throws UnsupportedOperationException {
        throw new UnsupportedOperationException(this.unmodifiableCellValue(TableColumn.VALUE));
    }

    boolean isWritable() {
        return false;
    }

    public boolean equals(Object object) {
        return object != null && object.getClass() == this.getClass() && ((TreeNode)object).metadata == this.metadata && ((TreeNode)object).baseType == this.baseType;
    }

    public int hashCode() {
        return System.identityHashCode(this.metadata) ^ Objects.hashCode(this.baseType);
    }

    public final TreeTable.Node getParent() {
        return this.parent;
    }

    public final boolean isLeaf() {
        return this.children == LEAF;
    }

    public final Collection<TreeTable.Node> getChildren() {
        if (!this.isLeaf()) {
            Object object = this.cachedValue;
            if (object == null && (object = this.getUserObject()) == null) {
                this.children = null;
                return LEAF;
            }
            this.cachedValue = null;
            if (this.children == null || ((TreeNodeChildren)this.children).metadata != object) {
                PropertyAccessor propertyAccessor = this.table.standard.getAccessor(new CacheKey(object.getClass(), this.baseType), true);
                this.children = new TreeNodeChildren(this, object, propertyAccessor);
            }
        }
        return this.children;
    }

    public final TreeTable.Node newChild() throws UnsupportedOperationException {
        if (this.isLeaf()) {
            throw new UnsupportedOperationException(Errors.format((short)99, (Object)this));
        }
        return new NewChild();
    }

    private TreeNodeChildren getCompactChildren() {
        Collection<TreeTable.Node> collection;
        if (this.table.valuePolicy == ValueExistencePolicy.COMPACT && (collection = this.getChildren()) instanceof TreeNodeChildren) {
            return (TreeNodeChildren)collection;
        }
        return null;
    }

    public final <V> V getValue(TableColumn<V> tableColumn) {
        Object object = null;
        ArgumentChecks.ensureNonNull((String)"column", tableColumn);
        if (tableColumn == TableColumn.IDENTIFIER) {
            object = this.getIdentifier();
        } else if (tableColumn == TableColumn.INDEX) {
            object = this.getIndex();
        } else if (tableColumn == TableColumn.NAME) {
            if (this.name == null) {
                this.name = this.getName();
            }
            object = this.name;
        } else if (tableColumn == TableColumn.TYPE) {
            TreeNodeChildren treeNodeChildren = this.getCompactChildren();
            if (treeNodeChildren == null || (object = treeNodeChildren.getParentType()) == null) {
                object = this.baseType;
            }
        } else if (tableColumn == TableColumn.VALUE) {
            if (this.isLeaf()) {
                object = this.cachedValue;
                this.cachedValue = null;
                if (object == null) {
                    object = this.getUserObject();
                }
            } else {
                TreeNodeChildren treeNodeChildren = this.getCompactChildren();
                if (treeNodeChildren != null) {
                    object = treeNodeChildren.getParentTitle();
                }
            }
        } else if (tableColumn == TableColumn.REMARKS) {
            object = this.getRemarks();
        }
        return (V)tableColumn.getElementType().cast(object);
    }

    public final <V> void setValue(TableColumn<V> tableColumn, V v) throws UnsupportedOperationException {
        ArgumentChecks.ensureNonNull((String)"column", tableColumn);
        if (tableColumn == TableColumn.VALUE) {
            ArgumentChecks.ensureNonNull((String)"value", v);
            this.cachedValue = null;
            TreeNodeChildren treeNodeChildren = this.getCompactChildren();
            if (treeNodeChildren == null || !treeNodeChildren.setParentTitle(v)) {
                this.setUserObject(v);
            }
        } else {
            if (TreeTableView.COLUMNS.contains(tableColumn)) {
                throw new UnsupportedOperationException(this.unmodifiableCellValue(tableColumn));
            }
            throw new IllegalArgumentException(Errors.format((short)45, (Object)"column", tableColumn));
        }
    }

    private String unmodifiableCellValue(TableColumn<?> tableColumn) {
        return Errors.format((short)151, this.getValue(TableColumn.NAME), (Object)tableColumn.getHeader());
    }

    public final boolean isEditable(TableColumn<?> tableColumn) {
        ArgumentChecks.ensureNonNull((String)"column", tableColumn);
        return tableColumn == TableColumn.VALUE && this.isWritable();
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder(60);
        this.appendStringTo(stringBuilder);
        return stringBuilder.toString();
    }

    final void appendStringTo(StringBuilder stringBuilder) {
        this.appendIdentifier(stringBuilder.append("Node["));
        stringBuilder.append(" : ").append(Classes.getShortName(this.baseType)).append(']');
    }

    private final class NewChild
    implements TreeTable.Node {
        private int indexInData = -1;
        private TreeNode delegate;

        private NewChild() {
        }

        private TreeNode delegate() throws IllegalStateException {
            if (this.delegate != null) {
                return this.delegate;
            }
            throw new IllegalStateException(Errors.format((short)90, (Object)(this.indexInData < 0 ? TableColumn.IDENTIFIER : TableColumn.VALUE).getHeader()));
        }

        private TreeNodeChildren getSiblings() {
            return (TreeNodeChildren)TreeNode.this.getChildren();
        }

        public <V> void setValue(TableColumn<V> tableColumn, V v) {
            if (this.delegate == null) {
                if (tableColumn == TableColumn.IDENTIFIER) {
                    ArgumentChecks.ensureNonNull((String)"value", v);
                    this.indexInData = this.getSiblings().accessor.indexOf((String)v, true);
                    return;
                }
                if (tableColumn == TableColumn.VALUE) {
                    ArgumentChecks.ensureNonNull((String)"value", v);
                    if (this.indexInData < 0) {
                        throw new IllegalStateException(Errors.format((short)90, (Object)TableColumn.IDENTIFIER.getHeader()));
                    }
                    TreeNodeChildren treeNodeChildren = this.getSiblings();
                    int n = treeNodeChildren.isCollectionOrMap(this.indexInData) ? CollectionsExt.size((Object)treeNodeChildren.valueAt(this.indexInData)) : -1;
                    if (!treeNodeChildren.add(this.indexInData, v)) {
                        throw new IllegalArgumentException(Errors.format((short)27, v));
                    }
                    this.delegate = treeNodeChildren.childAt(this.indexInData, n);
                    return;
                }
            }
            this.delegate().setValue(tableColumn, v);
        }

        public TreeTable.Node getParent() {
            return TreeNode.this;
        }

        public boolean isLeaf() {
            return this.delegate().isLeaf();
        }

        public Collection<TreeTable.Node> getChildren() {
            return this.delegate().getChildren();
        }

        public TreeTable.Node newChild() {
            return this.delegate().newChild();
        }

        public <V> V getValue(TableColumn<V> tableColumn) {
            return this.delegate().getValue(tableColumn);
        }

        public boolean isEditable(TableColumn<?> tableColumn) {
            return this.delegate().isEditable(tableColumn);
        }

        public Object getUserObject() {
            return this.delegate().getUserObject();
        }
    }

    static final class CollectionElement
    extends Element {
        final int indexInList;

        CollectionElement(TreeNode treeNode, Object object, PropertyAccessor propertyAccessor, int n, int n2) {
            super(treeNode, object, propertyAccessor, n);
            this.indexInList = n2;
        }

        @Override
        void appendIdentifier(StringBuilder stringBuilder) {
            super.appendIdentifier(stringBuilder);
            stringBuilder.append('[').append(this.indexInList).append(']');
        }

        @Override
        Integer getIndex() {
            return this.indexInList;
        }

        @Override
        CharSequence getName() {
            CharSequence charSequence = super.getName();
            int n = CollectionsExt.size((Object)super.getUserObject());
            if (n >= 2) {
                charSequence = Vocabulary.formatInternational((short)78, (Object[])new Object[]{charSequence, this.indexInList + 1, n});
            }
            return charSequence;
        }

        @Override
        public Object getUserObject() {
            Object object = super.getUserObject();
            Set set = object instanceof Collection ? (Set)object : ((Map)object).entrySet();
            if (this.indexInList == 0 && this.table.valuePolicy.substituteByNullElement(set)) {
                return null;
            }
            try {
                if (set instanceof List) {
                    return ((List)((Object)set)).get(this.indexInList);
                }
                Iterator iterator = set.iterator();
                for (int i = 0; i < this.indexInList; ++i) {
                    iterator.next();
                }
                return iterator.next();
            }
            catch (IndexOutOfBoundsException | NullPointerException | NoSuchElementException runtimeException) {
                throw new ConcurrentModificationException(runtimeException);
            }
        }

        @Override
        void setUserObject(Object object) {
            Collection collection = (Collection)super.getUserObject();
            if (!(collection instanceof List)) {
                throw new UnsupportedOperationException(Errors.format((short)162, (Object)"setValue"));
            }
            Class clazz = collection instanceof CheckedContainer ? ((CheckedContainer)collection).getElementType() : this.baseType;
            object = ObjectConverters.convert((Object)object, (Class)clazz);
            try {
                ((List)collection).set(this.indexInList, object);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException(indexOutOfBoundsException);
            }
        }

        @Override
        public boolean equals(Object object) {
            return super.equals(object) && ((CollectionElement)object).indexInList == this.indexInList;
        }

        @Override
        public int hashCode() {
            return super.hashCode() ^ this.indexInList;
        }
    }

    static class Element
    extends TreeNode {
        private final PropertyAccessor accessor;
        private final int indexInData;
        final Function<TreeNode, TreeTable.Node> decorator;

        Element(TreeNode treeNode, Object object, PropertyAccessor propertyAccessor, int n) {
            super(treeNode, object, propertyAccessor.type(n, TypeValuePolicy.ELEMENT_TYPE));
            this.accessor = propertyAccessor;
            this.indexInData = n;
            this.decorator = SpecialCases.isLocaleAndCharset(propertyAccessor, n) ? LocaleAndCharset::new : null;
        }

        @Override
        final String getIdentifier() {
            return this.accessor.name(this.indexInData, KeyNamePolicy.UML_IDENTIFIER);
        }

        @Override
        void appendIdentifier(StringBuilder stringBuilder) {
            super.appendIdentifier(stringBuilder);
            stringBuilder.append('.').append(this.accessor.name(this.indexInData, KeyNamePolicy.JAVABEANS_PROPERTY));
        }

        @Override
        CharSequence getName() {
            Class<?> clazz;
            Object object;
            String string = this.getIdentifier();
            if (string.equalsIgnoreCase(Classes.getShortName((Class)this.baseType)) && (object = this.getUserObject()) != null && (clazz = this.standardSubType(Classes.getLeafInterfaces(object.getClass(), (Class)this.baseType))) != null && clazz != Void.TYPE) {
                string = Classes.getShortName(clazz);
            }
            string = SpecialCases.rename(string);
            return CharSequences.camelCaseToSentence((CharSequence)string).toString();
        }

        private Class<?> standardSubType(Class<?>[] classArray) {
            Class<?> clazz = null;
            for (Class<?> clazz2 : classArray) {
                if (!this.baseType.isAssignableFrom(clazz2)) continue;
                if (!this.isMetadata(clazz2)) {
                    clazz2 = this.standardSubType(clazz2.getInterfaces());
                }
                if (clazz == null) {
                    clazz = clazz2;
                    continue;
                }
                if (clazz == clazz2) continue;
                return Void.TYPE;
            }
            return clazz;
        }

        @Override
        final CharSequence getRemarks() {
            return this.accessor.remarks(this.indexInData, this.metadata);
        }

        @Override
        public Object getUserObject() {
            return this.accessor.get(this.indexInData, this.metadata);
        }

        @Override
        void setUserObject(Object object) {
            this.accessor.set(this.indexInData, this.metadata, object, 0);
        }

        @Override
        final boolean isWritable() {
            return this.accessor.isWritable(this.indexInData);
        }

        @Override
        public boolean equals(Object object) {
            return super.equals(object) && ((Element)object).indexInData == this.indexInData;
        }

        @Override
        public int hashCode() {
            return super.hashCode() ^ 31 * this.indexInData;
        }
    }
}

