/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.router;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import juzu.impl.common.MimeType;
import juzu.impl.common.UriBuilder;
import juzu.impl.router.PathParam;
import juzu.impl.router.Route;
import juzu.io.UndeclaredIOException;

public class RouteMatch {
    final Route route;
    final Map<PathParam, String> matched;
    final Map<String, String> unmatched;

    RouteMatch(Route route, Map<PathParam, String> matched) {
        this.route = route;
        this.matched = Collections.unmodifiableMap(matched);
        this.unmatched = Collections.emptyMap();
    }

    RouteMatch(Route route, Map<String, String> unmatched, Map<PathParam, String> matched) {
        this.route = route;
        this.matched = Collections.unmodifiableMap(matched);
        this.unmatched = Collections.unmodifiableMap(unmatched);
    }

    public Route getRoute() {
        return this.route;
    }

    public Map<PathParam, String> getMatched() {
        return Collections.unmodifiableMap(this.matched);
    }

    public Map<String, String> getUnmatched() {
        return this.unmatched;
    }

    public void render(UriBuilder writer) throws IOException {
        this.route.renderPath(this, writer, false);
    }

    public String render() {
        try {
            StringBuilder sb = new StringBuilder();
            UriBuilder writer = new UriBuilder(sb, MimeType.PLAIN);
            this.render(writer);
            return sb.toString();
        }
        catch (IOException e) {
            throw new UndeclaredIOException(e);
        }
    }
}

