/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.integration.gamification;

import org.exoplatform.addons.gamification.service.configuration.RuleService;
import org.exoplatform.addons.gamification.service.effective.GamificationService;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.wiki.WikiException;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.service.PageUpdateType;
import org.exoplatform.wiki.service.listener.PageWikiListener;

@Asynchronous
public class GamificationWikiListener
extends PageWikiListener {
    private static final Log LOG = ExoLogger.getLogger(GamificationWikiListener.class);
    private static final String GAMIFICATION_WIKI_ADD_PAGE = "addWikiPage";
    private static final String GAMIFICATION_WIKI_UPDATE_PAGE = "updateWikiPage";
    protected RuleService ruleService;
    protected IdentityManager identityManager;
    protected GamificationService gamificationService;

    public GamificationWikiListener(RuleService ruleService, IdentityManager identityManager, GamificationService gamificationService) {
        this.ruleService = ruleService;
        this.identityManager = identityManager;
        this.gamificationService = gamificationService;
    }

    public void postAddPage(String wikiType, String wikiOwner, String pageId, Page page) throws WikiException {
        if ("Home".equals(pageId)) {
            return;
        }
        Object aHistory = null;
        String actorUsername = ConversationState.getCurrent().getIdentity().getUserId();
        String actorId = this.identityManager.getOrCreateIdentity("organization", actorUsername, false).getId();
        this.gamificationService.createHistory(GAMIFICATION_WIKI_ADD_PAGE, actorId, actorId, page.getUrl());
    }

    public void postDeletePage(String wikiType, String wikiOwner, String pageId, Page page) throws WikiException {
    }

    public void postgetPagefromTree(String wikiType, String wikiOwner, String pageId, Page page) throws WikiException {
    }

    public void postgetPagefromBreadCrumb(String wikiType, String wikiOwner, String pageId, Page page) throws WikiException {
    }

    public void postUpdatePage(String wikiType, String wikiOwner, String pageId, Page page, PageUpdateType wikiUpdateType) throws WikiException {
        if (page != null && wikiUpdateType != null && (wikiUpdateType.equals((Object)PageUpdateType.ADD_PAGE) || wikiUpdateType.equals((Object)PageUpdateType.EDIT_PAGE_CONTENT) || wikiUpdateType.equals((Object)PageUpdateType.EDIT_PAGE_CONTENT_AND_TITLE))) {
            String actorUsername = ConversationState.getCurrent().getIdentity().getUserId();
            String actorId = this.identityManager.getOrCreateIdentity("organization", actorUsername, false).getId();
            this.gamificationService.createHistory(GAMIFICATION_WIKI_UPDATE_PAGE, actorId, actorId, page.getUrl());
        }
    }
}

