/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage;

import java.util.Arrays;
import java.util.Optional;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.internal.storage.AbstractResource;
import org.apache.sis.internal.storage.MetadataBuilder;
import org.apache.sis.internal.storage.Resources;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.spatial.DimensionNameType;

public abstract class AbstractGridResource
extends AbstractResource
implements GridCoverageResource {
    protected AbstractGridResource(StoreListeners storeListeners) {
        super(storeListeners);
    }

    @Override
    public Optional<Envelope> getEnvelope() throws DataStoreException {
        GridGeometry gridGeometry = this.getGridGeometry();
        if (gridGeometry != null && gridGeometry.isDefined(2)) {
            return Optional.of(gridGeometry.getEnvelope());
        }
        return Optional.empty();
    }

    @Override
    protected void createMetadata(MetadataBuilder metadataBuilder) throws DataStoreException {
        super.createMetadata(metadataBuilder);
        metadataBuilder.addSpatialRepresentation(null, this.getGridGeometry(), false);
        for (SampleDimension sampleDimension : this.getSampleDimensions()) {
            metadataBuilder.addNewBand(sampleDimension);
        }
    }

    protected final RangeArgument validateRangeArgument(int n, int[] nArray) {
        int n2;
        int n3;
        ArgumentChecks.ensureStrictlyPositive((String)"numSampleDimensions", (int)n);
        if (nArray == null || nArray.length == 0) {
            long[] lArray = new long[n];
            for (int i = 1; i < n; ++i) {
                lArray[i] = (long)i << 32 | (long)i;
            }
            return new RangeArgument(lArray);
        }
        long[] lArray = new long[nArray.length];
        for (n3 = 0; n3 < nArray.length; ++n3) {
            n2 = nArray[n3];
            if (n2 < 0 || n2 >= n) {
                throw new IllegalArgumentException(Resources.forLocale(this.getLocale()).getString((short)52, n - 1, n2));
            }
            lArray[n3] = (long)n2 << 32 | (long)n3;
        }
        Arrays.sort(lArray);
        n3 = -1;
        for (n2 = 0; n2 < lArray.length; ++n2) {
            int n4 = (int)(lArray[n2] >>> 32);
            if (n4 == n3) {
                throw new IllegalArgumentException(Resources.forLocale(this.getLocale()).getString((short)53, n4));
            }
            n3 = n4;
        }
        return new RangeArgument(lArray);
    }

    protected static final class RangeArgument {
        private static final DimensionNameType BAND = DimensionNameType.valueOf((String)"BAND");
        private final long[] packed;
        private int first;
        private int last;
        private int interval;
        private SampleDimension.Builder builder;

        RangeArgument(long[] lArray) {
            this.packed = lArray;
            this.interval = 1;
        }

        public int getNumBands() {
            return this.packed.length;
        }

        public int getFirstSpecified() {
            for (long l : this.packed) {
                if ((int)l != 0) continue;
                return (int)(l >>> 32);
            }
            throw new IllegalStateException();
        }

        public int getSourceIndex(int n) {
            return (int)(this.packed[n] >>> 32);
        }

        public int getTargetIndex(int n) {
            return (int)this.packed[n];
        }

        public int getSubsampledIndex(int n) {
            return (this.getSourceIndex(n) - this.first) / this.interval;
        }

        public int getPixelStride() {
            return (this.last - this.first) / this.interval + 1;
        }

        public GridExtent insertBandDimension(GridExtent gridExtent, int n) {
            this.first = this.getSourceIndex(0);
            this.last = this.getSourceIndex(this.packed.length - 1);
            return gridExtent.insert(n, BAND, (long)this.first, (long)this.last, true);
        }

        public int[] insertSubsampling(int[] nArray, int n) {
            int[] nArray2 = new int[this.packed.length - 1];
            for (int i = 0; i < nArray2.length; ++i) {
                nArray2[i] = this.getSourceIndex(i + 1) - this.getSourceIndex(i);
            }
            int[] nArray3 = MathFunctions.commonDivisors((int[])nArray2);
            this.interval = nArray3.length != 0 ? nArray3[nArray3.length - 1] : 1;
            nArray = ArraysExt.insert((int[])nArray, (int)n, (int)1);
            nArray[n] = this.interval;
            return nArray;
        }

        public SampleDimension.Builder builder() {
            if (this.builder == null) {
                this.builder = new SampleDimension.Builder();
            } else {
                this.builder.clear();
            }
            return this.builder;
        }
    }
}

