/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.geometry;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Objects;
import org.apache.sis.geometry.AbstractDirectPosition;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GeneralDirectPosition
extends AbstractDirectPosition
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -1775358214919832302L;
    private static volatile Field coordinatesField;
    public final double[] coordinates;
    @Deprecated
    public transient double[] ordinates;
    private CoordinateReferenceSystem crs;

    public GeneralDirectPosition(CoordinateReferenceSystem coordinateReferenceSystem) {
        this(coordinateReferenceSystem.getCoordinateSystem().getDimension());
        this.crs = coordinateReferenceSystem;
    }

    public GeneralDirectPosition(int n) throws NegativeArraySizeException {
        this.coordinates = new double[n];
        this.ordinates = this.coordinates;
    }

    public GeneralDirectPosition(double ... dArray) {
        this.coordinates = dArray;
        this.ordinates = dArray;
    }

    public GeneralDirectPosition(DirectPosition directPosition) {
        this.coordinates = directPosition.getCoordinate();
        this.crs = directPosition.getCoordinateReferenceSystem();
        ArgumentChecks.ensureDimensionMatches((String)"crs", (int)this.coordinates.length, (CoordinateReferenceSystem)this.crs);
        this.ordinates = this.coordinates;
    }

    public GeneralDirectPosition(CharSequence charSequence) throws IllegalArgumentException {
        this.coordinates = GeneralDirectPosition.parse(charSequence);
        if (this.coordinates == null) {
            throw new IllegalArgumentException(Errors.format((short)154, (Object)"POINT", (Object)charSequence));
        }
        this.ordinates = this.coordinates;
    }

    public final int getDimension() {
        return this.coordinates.length;
    }

    public final CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    public void setCoordinateReferenceSystem(CoordinateReferenceSystem coordinateReferenceSystem) throws MismatchedDimensionException {
        ArgumentChecks.ensureDimensionMatches((String)"crs", (int)this.getDimension(), (CoordinateReferenceSystem)coordinateReferenceSystem);
        this.crs = coordinateReferenceSystem;
    }

    @Override
    public final double[] getCoordinate() {
        return (double[])this.coordinates.clone();
    }

    public void setCoordinate(double ... dArray) throws MismatchedDimensionException {
        if (dArray == null) {
            Arrays.fill(this.coordinates, Double.NaN);
        } else {
            ArgumentChecks.ensureDimensionMatches((String)"coordinates", (int)this.coordinates.length, (double[])dArray);
            System.arraycopy(dArray, 0, this.coordinates, 0, dArray.length);
        }
    }

    public final double getOrdinate(int n) throws IndexOutOfBoundsException {
        return this.coordinates[n];
    }

    public void setOrdinate(int n, double d) throws IndexOutOfBoundsException {
        this.coordinates[n] = d;
    }

    @Override
    public void setLocation(DirectPosition directPosition) throws MismatchedDimensionException {
        if (directPosition == null) {
            Arrays.fill(this.coordinates, Double.NaN);
        } else {
            ArgumentChecks.ensureDimensionMatches((String)"position", (int)this.coordinates.length, (DirectPosition)directPosition);
            this.setCoordinateReferenceSystem(directPosition.getCoordinateReferenceSystem());
            for (int i = 0; i < this.coordinates.length; ++i) {
                this.coordinates[i] = directPosition.getOrdinate(i);
            }
        }
    }

    @Override
    public String toString() {
        return GeneralDirectPosition.toString(this, ArraysExt.isSinglePrecision((double[])this.coordinates));
    }

    static Field getCoordinatesField(Class<?> clazz) throws NoSuchFieldException {
        Field field = clazz.getDeclaredField("coordinates");
        AccessController.doPrivileged(() -> {
            field.setAccessible(true);
            return null;
        });
        return field;
    }

    public GeneralDirectPosition clone() {
        try {
            Field field = coordinatesField;
            if (field == null) {
                coordinatesField = field = GeneralDirectPosition.getCoordinatesField(GeneralDirectPosition.class);
            }
            GeneralDirectPosition generalDirectPosition = (GeneralDirectPosition)super.clone();
            field.set(generalDirectPosition, this.coordinates.clone());
            generalDirectPosition.ordinates = generalDirectPosition.coordinates;
            return generalDirectPosition;
        }
        catch (CloneNotSupportedException | ReflectiveOperationException exception) {
            throw new AssertionError((Object)exception);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.ordinates = this.coordinates;
    }

    @Override
    public int hashCode() {
        int n = Arrays.hashCode(this.coordinates) + Objects.hashCode(this.getCoordinateReferenceSystem());
        assert (n == super.hashCode());
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof GeneralDirectPosition) {
            GeneralDirectPosition generalDirectPosition = (GeneralDirectPosition)object;
            return Arrays.equals(this.coordinates, generalDirectPosition.coordinates) && Objects.equals(this.crs, generalDirectPosition.crs);
        }
        return super.equals(object);
    }
}

