/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.internal.ast.tree;

import antlr.SemanticException;
import org.hibernate.hql.internal.ast.tree.ExpectedTypeAwareNode;
import org.hibernate.hql.internal.ast.tree.Node;
import org.hibernate.hql.internal.ast.tree.OperatorNode;
import org.hibernate.hql.internal.ast.tree.SqlNode;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

public class BetweenOperatorNode
extends SqlNode
implements OperatorNode {
    @Override
    public void initialize() throws SemanticException {
        Node fixture = this.getFixtureOperand();
        if (fixture == null) {
            throw new SemanticException("fixture operand of a between operator was null");
        }
        Node low = this.getLowOperand();
        if (low == null) {
            throw new SemanticException("low operand of a between operator was null");
        }
        Node high = this.getHighOperand();
        if (high == null) {
            throw new SemanticException("high operand of a between operator was null");
        }
        this.check(fixture, low, high);
        this.check(low, high, fixture);
        this.check(high, fixture, low);
    }

    @Override
    public Type getDataType() {
        return StandardBasicTypes.BOOLEAN;
    }

    public Node getFixtureOperand() {
        return (Node)this.getFirstChild();
    }

    public Node getLowOperand() {
        return (Node)this.getFirstChild().getNextSibling();
    }

    public Node getHighOperand() {
        return (Node)this.getFirstChild().getNextSibling().getNextSibling();
    }

    private void check(Node check, Node first, Node second) {
        if (ExpectedTypeAwareNode.class.isAssignableFrom(((Object)((Object)check)).getClass())) {
            Type expectedType = null;
            if (SqlNode.class.isAssignableFrom(((Object)((Object)first)).getClass())) {
                expectedType = ((SqlNode)first).getDataType();
            }
            if (expectedType == null && SqlNode.class.isAssignableFrom(((Object)((Object)second)).getClass())) {
                expectedType = ((SqlNode)second).getDataType();
            }
            ((ExpectedTypeAwareNode)((Object)check)).setExpectedType(expectedType);
        }
    }
}

