/*
 * Decompiled with CFR 0.152.
 */
package ucar.units;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import ucar.units.BaseQuantity;
import ucar.units.BaseUnit;
import ucar.units.Unit;
import ucar.units.UnitDB;
import ucar.units.UnitDBImpl;
import ucar.units.UnitExistsException;
import ucar.units.UnitSystem;

public class UnitSystemImpl
implements UnitSystem,
Serializable {
    private static final long serialVersionUID = 1L;
    private final HashMap<BaseQuantity, BaseUnit> quantityMap;
    private final UnitDB baseUnitDB;
    private final UnitDBImpl acceptableUnitDB;

    protected UnitSystemImpl(UnitDBImpl baseUnitDB, UnitDBImpl derivedUnitDB) throws UnitExistsException {
        this.quantityMap = new HashMap(baseUnitDB.nameCount());
        Iterator iter = baseUnitDB.getIterator();
        while (iter.hasNext()) {
            Unit unit = (Unit)iter.next();
            BaseUnit baseUnit = (BaseUnit)unit;
            this.quantityMap.put(baseUnit.getBaseQuantity(), baseUnit);
        }
        this.baseUnitDB = baseUnitDB;
        this.acceptableUnitDB = new UnitDBImpl(baseUnitDB.nameCount() + derivedUnitDB.nameCount(), baseUnitDB.symbolCount() + derivedUnitDB.symbolCount());
        this.acceptableUnitDB.add(baseUnitDB);
        this.acceptableUnitDB.add(derivedUnitDB);
    }

    @Override
    public final UnitDB getBaseUnitDB() {
        return this.baseUnitDB;
    }

    @Override
    public final UnitDB getUnitDB() {
        return this.acceptableUnitDB;
    }

    @Override
    public final BaseUnit getBaseUnit(BaseQuantity quantity) {
        return this.quantityMap.get(quantity);
    }
}

