/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.database;

import org.exoplatform.services.database.DBObject;
import org.exoplatform.services.database.ExoDatasource;
import org.exoplatform.services.database.MSSQLServerTableManager;
import org.exoplatform.services.database.OracleTableManager;
import org.exoplatform.services.database.StandardSQLTableManager;

public abstract class DBTableManager {
    public abstract <T extends DBObject> void createTable(Class<T> var1, boolean var2) throws Exception;

    public abstract <T extends DBObject> void dropTable(Class<T> var1) throws Exception;

    public abstract <T extends DBObject> boolean hasTable(Class<T> var1) throws Exception;

    public static final DBTableManager createDBTableManager(ExoDatasource datasource) {
        if (datasource.getDatabaseType() == 1) {
            return new StandardSQLTableManager(datasource);
        }
        if (5 == datasource.getDatabaseType()) {
            return new OracleTableManager(datasource);
        }
        if (6 == datasource.getDatabaseType()) {
            return new MSSQLServerTableManager(datasource);
        }
        return new StandardSQLTableManager(datasource);
    }
}

