/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.transaction;

import net.sf.ehcache.CacheEntry;
import net.sf.ehcache.store.Store;
import net.sf.ehcache.transaction.StoreWriteCommand;
import net.sf.ehcache.writer.CacheWriterManager;

public class StoreRemoveCommand
implements StoreWriteCommand {
    private final CacheEntry entry;

    public StoreRemoveCommand(CacheEntry entry) {
        this.entry = entry;
    }

    public boolean execute(Store store) {
        return store.remove(this.entry.getKey()) != null;
    }

    public boolean execute(CacheWriterManager cacheWriterManager) {
        return false;
    }

    public boolean isPut(Object key) {
        return false;
    }

    public boolean isRemove(Object key) {
        return this.entry.getKey().equals(key);
    }

    public String getCommandName() {
        return "REMOVE";
    }

    public Object getKey() {
        return this.entry.getKey();
    }

    public CacheEntry getEntry() {
        return this.entry;
    }
}

