/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport.jgroups;

import org.infinispan.remoting.responses.ExceptionResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.rpc.ResponseFilter;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.blocks.RspFilter;

public final class JGroupsResponseFilterAdapter
implements RspFilter {
    private static final Log log = LogFactory.getLog(JGroupsResponseFilterAdapter.class);
    final ResponseFilter r;

    public JGroupsResponseFilterAdapter(ResponseFilter r) {
        this.r = r;
    }

    public boolean isAcceptable(Object response, Address sender) {
        try {
            if (response instanceof Exception) {
                response = new ExceptionResponse((Exception)response);
            } else if (response instanceof Throwable) {
                response = new ExceptionResponse(new RuntimeException((Throwable)response));
            }
            return this.r.isAcceptable((Response)response, JGroupsTransport.fromJGroupsAddress(sender));
        }
        catch (Throwable t) {
            log.error("Exception in response filter: ", t);
            throw t;
        }
    }

    public boolean needMoreResponses() {
        return this.r.needMoreResponses();
    }
}

