/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.sql;

import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.sql.DataSource;
import org.apache.sis.internal.metadata.sql.SQLBuilder;
import org.apache.sis.metadata.MetadataStandard;
import org.apache.sis.metadata.TitleProperty;
import org.apache.sis.metadata.TypeValuePolicy;
import org.apache.sis.metadata.ValueExistencePolicy;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.metadata.sql.IdentifierGenerator;
import org.apache.sis.metadata.sql.MetadataSource;
import org.apache.sis.metadata.sql.MetadataStoreException;
import org.apache.sis.metadata.sql.TableHierarchy;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Messages;
import org.apache.sis.xml.IdentifiedObject;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.CodeList;
import org.opengis.util.FactoryException;

public class MetadataWriter
extends MetadataSource {
    private static final String CODE_COLUMN = "CODE";
    private static final int MINIMAL_LIMIT = 5;
    private final int maximumIdentifierLength;
    private final int maximumValueLength;
    private final ValueExistencePolicy columnCreationPolicy;

    public MetadataWriter(MetadataStandard metadataStandard, DataSource dataSource, String string, Map<String, ?> map) {
        super(metadataStandard, dataSource, string, map);
        Integer n = (Integer)Containers.property(map, (Object)"maximumIdentifierLength", Integer.class);
        Integer n2 = (Integer)Containers.property(map, (Object)"maximumValueLength", Integer.class);
        ValueExistencePolicy valueExistencePolicy = (ValueExistencePolicy)((Object)Containers.property(map, (Object)"columnCreationPolicy", ValueExistencePolicy.class));
        if (n != null) {
            ArgumentChecks.ensureBetween((String)"maximumIdentifierLength", (int)5, (int)100, (int)n);
            this.maximumIdentifierLength = n;
        } else {
            this.maximumIdentifierLength = 24;
        }
        if (n2 != null) {
            ArgumentChecks.ensureBetween((String)"maximumValueLength", (int)5, (int)Short.MAX_VALUE, (int)n2);
            this.maximumValueLength = n2;
        } else {
            this.maximumValueLength = 1000;
        }
        this.columnCreationPolicy = valueExistencePolicy != null ? valueExistencePolicy : ValueExistencePolicy.NON_EMPTY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String add(Object object) throws MetadataStoreException {
        String string = this.proxy(object);
        if (string == null) {
            try {
                MetadataWriter metadataWriter = this;
                synchronized (metadataWriter) {
                    Connection connection = this.connection();
                    connection.setAutoCommit(false);
                    boolean bl = false;
                    try {
                        try (Statement statement = connection.createStatement();){
                            string = object instanceof CodeList ? this.addCode(statement, (CodeList)object) : this.add(statement, object, new IdentityHashMap<Object, String>(), null);
                        }
                        bl = true;
                    }
                    finally {
                        if (bl) {
                            connection.commit();
                        } else {
                            connection.rollback();
                        }
                        connection.setAutoCommit(true);
                    }
                }
            }
            catch (ClassCastException classCastException) {
                throw new MetadataStoreException(Errors.format((short)42, (Object)"metadata", object.getClass()));
            }
            catch (SQLException sQLException) {
                throw new MetadataStoreException(sQLException.getLocalizedMessage(), Exceptions.unwrap((Exception)sQLException));
            }
            catch (FactoryException factoryException) {
                throw new MetadataStoreException(factoryException.getLocalizedMessage(), (Exception)((Object)factoryException));
            }
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private String add(Statement statement, Object object, Map<Object, String> map, String string) throws ClassCastException, SQLException, FactoryException {
        Object object2;
        Object object3;
        String string2;
        int n;
        Class<Object> clazz;
        Object object42;
        Object object5;
        Set<String> set;
        SQLBuilder sQLBuilder = this.helper();
        Map<String, Object> map2 = this.asValueMap(object);
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> clazz22 : map2.entrySet()) {
            linkedHashMap.put(clazz22.getKey(), MetadataWriter.extractFromCollection(clazz22.getValue()));
        }
        Class<?> clazz3 = object.getClass();
        Class clazz2 = this.standard.getInterface(clazz3);
        String string3 = MetadataWriter.getTableName(clazz2);
        String string4 = this.search(string3, set = this.getExistingColumns(string3), linkedHashMap, statement, sQLBuilder);
        if (string4 != null) {
            if (map.put(object, string4) != null) {
                throw new AssertionError(object);
            }
            return string4;
        }
        if (this.columnCreationPolicy != ValueExistencePolicy.ALL) {
            object5 = linkedHashMap.values().iterator();
            while (object5.hasNext()) {
                if (object5.next() != null) continue;
                object5.remove();
            }
        }
        if ((object5 = this.createTable(statement, clazz2, string3, set)) == null) {
            object5 = this.isChildTable(clazz2);
        }
        Map<String, Class<?>> map3 = null;
        Map<String, Class<?>> map4 = null;
        LinkedHashMap linkedHashMap2 = new LinkedHashMap();
        for (Object object42 : linkedHashMap.keySet()) {
            void clazz4;
            Class clazz5;
            if (set.contains(object42)) continue;
            if (map3 == null) {
                map3 = this.standard.asTypeMap(clazz3, NAME_POLICY, TypeValuePolicy.ELEMENT_TYPE);
                map4 = this.standard.asTypeMap(clazz3, NAME_POLICY, TypeValuePolicy.DECLARING_INTERFACE);
            }
            String i = string3;
            if (sQLBuilder.dialect.isTableInheritanceSupported && !clazz2.isAssignableFrom(clazz5 = (Class)map4.get(object42))) {
                i = MetadataWriter.getTableName(clazz5);
            }
            int entry = this.maximumValueLength;
            clazz = map3.get(object42);
            boolean bl = CodeList.class.isAssignableFrom(clazz);
            if (bl || this.standard.isMetadata(clazz)) {
                if (!(bl && Modifier.isAbstract(clazz.getModifiers()) || linkedHashMap2.put(object42, new FKey(i, clazz, null)) == null)) {
                    throw new AssertionError(object42);
                }
                clazz = null;
                entry = this.maximumIdentifierLength;
            } else if (clazz.isEnum()) {
                int string7 = this.maximumIdentifierLength;
            }
            statement.executeUpdate(sQLBuilder.createColumn(this.schema(), i, (String)object42, clazz, (int)clazz4));
            set.add((String)object42);
        }
        string4 = MetadataWriter.nonEmpty(MetadataWriter.removeReservedChars(this.suggestIdentifier(object, map2), null));
        if (string4 == null && (string4 = string) == null) {
            string4 = "unknown";
            for (Object object42 : linkedHashMap.values()) {
                if (object42 == null || this.standard.isMetadata(object42.getClass())) continue;
                string4 = MetadataWriter.abbreviation(object42.toString());
                break;
            }
        }
        if (((Boolean)object5).booleanValue()) {
            string4 = TableHierarchy.encode(string3, string4);
            n = string3.length() + 2;
        } else {
            n = 0;
        }
        object42 = new IdentifierGenerator(this, this.schema(), string3, "ID", sQLBuilder);
        try {
            for (int i = 0; i < 4; ++i) {
                int entry = this.maximumIdentifierLength - i;
                if (entry < n) {
                } else {
                    if (string4.length() > entry) {
                        string4 = string4.substring(0, entry);
                    }
                    if ((string4 = ((IdentifierGenerator)object42).identifier(string4)).length() > this.maximumIdentifierLength) continue;
                }
                break;
            }
        }
        finally {
            ((IdentifierGenerator)object42).close();
        }
        if (map.put(object, string4) != null) {
            throw new AssertionError(object);
        }
        object42 = null;
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            clazz = entry.getValue();
            Class<?> clazz6 = clazz.getClass();
            if (CodeList.class.isAssignableFrom(clazz6)) {
                clazz = this.addCode(statement, (CodeList)clazz);
            } else if (clazz6.isEnum()) {
                clazz = ((Enum)((Object)clazz)).name();
            } else if (this.standard.isMetadata(clazz6)) {
                String string5 = this.proxy(clazz);
                if (string5 == null && (string5 = map.get(clazz)) == null) {
                    string5 = this.add(statement, clazz, map, string4);
                    assert (map.get(clazz) == string5);
                    Objects.requireNonNull(sQLBuilder.dialect);
                    string2 = (String)entry.getKey();
                    object3 = this.standard.getInterface(clazz.getClass());
                    object2 = (FKey)linkedHashMap2.get(string2);
                    if (object2 != null && !((Class)object3).isAssignableFrom(((FKey)object2).tableType)) {
                        ((FKey)object2).tableType = object3;
                    }
                    if (object2 == null) {
                        if (object42 == null) {
                            object42 = new HashMap<String, FKey>();
                            try (ResultSet resultSet = statement.getConnection().getMetaData().getImportedKeys(this.catalog, this.schema(), string3);){
                                while (resultSet.next()) {
                                    if (this.schema() != null && !this.schema().equals(resultSet.getString("PKTABLE_SCHEM")) || this.catalog != null && !this.catalog.equals(resultSet.getString("PKTABLE_CAT"))) continue;
                                    object42.put(resultSet.getString("FKCOLUMN_NAME"), new FKey(resultSet.getString("PKTABLE_NAME"), null, resultSet.getString("FK_NAME")));
                                }
                            }
                        }
                        if ((object2 = (FKey)object42.remove(string2)) != null && !((FKey)object2).tableName.equals(MetadataWriter.getTableName(object3))) {
                            statement.executeUpdate(sQLBuilder.clear().append("ALTER TABLE ").appendIdentifier(this.schema(), string3).append(" DROP CONSTRAINT ").appendIdentifier(((FKey)object2).keyName).toString());
                            this.warning(MetadataWriter.class, "add", Messages.getResources(null).getLogRecord(Level.WARNING, (short)32, (Object)(string3 + '.' + string2 + " \u21d2 " + ((FKey)object2).tableName + '.' + "ID")));
                        }
                    }
                }
                clazz = string5;
            }
            entry.setValue(clazz);
        }
        if (!linkedHashMap2.isEmpty()) {
            for (Map.Entry entry : linkedHashMap2.entrySet()) {
                clazz = (FKey)entry.getValue();
                Class<?> clazz7 = ((FKey)((Object)clazz)).tableType;
                boolean bl = CodeList.class.isAssignableFrom(clazz7);
                if (bl) {
                    string2 = CODE_COLUMN;
                } else {
                    string2 = "ID";
                    clazz7 = this.standard.getInterface(clazz7);
                }
                object3 = (String)entry.getKey();
                object2 = MetadataWriter.getTableName(clazz7);
                statement.executeUpdate(sQLBuilder.createForeignKey(this.schema(), ((FKey)((Object)clazz)).tableName, (String)object3, (String)object2, string2, !bl));
                Objects.requireNonNull(sQLBuilder.dialect);
                if (string3.equals(((FKey)((Object)clazz)).tableName)) continue;
                statement.executeUpdate(sQLBuilder.createForeignKey(this.schema(), string3, (String)object3, (String)object2, string2, !bl));
            }
        }
        sQLBuilder.clear().append("INSERT INTO ").appendIdentifier(this.schema(), string3).append(" (").appendIdentifier("ID");
        for (String string6 : linkedHashMap.keySet()) {
            sQLBuilder.append(", ").appendIdentifier(string6);
        }
        sQLBuilder.append(") VALUES (").appendValue(string4);
        for (Map.Entry entry : linkedHashMap.values()) {
            sQLBuilder.append(", ").appendValue(entry);
        }
        String string7 = sQLBuilder.append(')').toString();
        if (statement.executeUpdate(string7) != 1) {
            throw new SQLException(Errors.format((short)174, (Object)0, (Object)string3, (Object)string4));
        }
        return string4;
    }

    private static Class<?>[] getParentTypes(Class<?> clazz) {
        Class<?>[] classArray;
        if (clazz.isInterface()) {
            classArray = clazz.getInterfaces();
        } else {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = clazz.getSuperclass();
        }
        return classArray;
    }

    private Boolean isChildTable(Class<?> clazz) {
        for (Class<?> clazz2 : MetadataWriter.getParentTypes(clazz)) {
            if (!this.standard.isMetadata(clazz2)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    /*
     * WARNING - void declaration
     */
    private Boolean createTable(Statement statement, Class<?> clazz, String string, Set<String> set) throws SQLException {
        Boolean bl = null;
        if (set.isEmpty()) {
            void var7_10;
            bl = Boolean.FALSE;
            StringBuilder stringBuilder = null;
            for (Class<?> clazz2 : MetadataWriter.getParentTypes(clazz)) {
                if (!this.standard.isMetadata(clazz2)) continue;
                bl = Boolean.TRUE;
                SQLBuilder sQLBuilder = this.helper();
                if (!sQLBuilder.dialect.isTableInheritanceSupported) continue;
                String string2 = MetadataWriter.getTableName(clazz2);
                this.createTable(statement, clazz2, string2, this.getExistingColumns(string2));
                if (stringBuilder == null) {
                    sQLBuilder.clear().append("CREATE TABLE ").appendIdentifier(this.schema(), string);
                    Objects.requireNonNull(sQLBuilder.dialect);
                    sQLBuilder.append("(CONSTRAINT ").appendIdentifier(string + "_pkey").append(" PRIMARY KEY (").appendIdentifier("ID").append(")) ");
                    stringBuilder = new StringBuilder(sQLBuilder.append(" INHERITS (").toString());
                } else {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(sQLBuilder.clear().appendIdentifier(this.schema(), string2));
            }
            if (stringBuilder != null) {
                String string3 = stringBuilder.append(')').toString();
            } else {
                String string4 = this.createTable(string, "ID");
            }
            statement.executeUpdate((String)var7_10);
            set.add("ID");
        }
        return bl;
    }

    private String createTable(String string, String string2) throws SQLException {
        return this.helper().clear().append("CREATE TABLE ").appendIdentifier(this.schema(), string).append(" (").appendIdentifier(string2).append(" VARCHAR(").append(this.maximumIdentifierLength).append(") NOT NULL PRIMARY KEY)").toString();
    }

    private String addCode(Statement statement, CodeList<?> codeList) throws SQLException, FactoryException {
        boolean bl;
        assert (Thread.holdsLock(this));
        String string = MetadataWriter.getTableName(codeList.getClass());
        Set<String> set = this.getExistingColumns(string);
        if (set.isEmpty()) {
            statement.executeUpdate(this.createTable(string, CODE_COLUMN));
            set.add(CODE_COLUMN);
        }
        String string2 = Types.getCodeName(codeList);
        String string3 = this.helper().clear().append("SELECT ").appendIdentifier(CODE_COLUMN).append(" FROM ").appendIdentifier(this.schema(), string).append(" WHERE ").appendIdentifier(CODE_COLUMN).appendCondition(string2).toString();
        try (Object object = statement.executeQuery(string3);){
            bl = object.next();
        }
        if (!bl && statement.executeUpdate((String)(object = this.helper().clear().append("INSERT INTO ").appendIdentifier(this.schema(), string).append(" (").appendIdentifier(CODE_COLUMN).append(") VALUES (").appendValue(string2).append(')').toString())) != 1) {
            throw new SQLException(Errors.format((short)174, (Object)0, (Object)string, (Object)string2));
        }
        return string2;
    }

    protected String suggestIdentifier(Object object, Map<String, Object> map) throws SQLException {
        Object object2;
        String string = null;
        Collection<Object> collection = object instanceof Identifier ? Collections.singleton((Identifier)object) : (object instanceof IdentifiedObject ? ((IdentifiedObject)object).getIdentifiers() : Collections.emptySet());
        Object object3 = collection.iterator();
        while (object3.hasNext()) {
            String string2;
            object2 = (Identifier)object3.next();
            string = MetadataWriter.nonEmpty(object2.getCode());
            if (string == null) continue;
            if (!(object2 instanceof ReferenceIdentifier) || (string2 = MetadataWriter.nonEmpty(((ReferenceIdentifier)object2).getCodeSpace())) == null) break;
            string = string2 + ':' + string;
            break;
        }
        if (string == null && object instanceof Citation) {
            string = MetadataWriter.nonEmpty(Citations.toCodeSpace((Citation)object));
        }
        if (string == null && (object3 = object.getClass().getAnnotation(TitleProperty.class)) != null && (object2 = map.get(MetadataWriter.nonEmpty(object3.name()))) != null) {
            string = MetadataWriter.nonEmpty(object2.toString());
        }
        if (string != null && string.length() >= 8) {
            string = MetadataWriter.abbreviation(string);
        }
        return string;
    }

    private static String abbreviation(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            int n = stringTokenizer.nextToken().codePointAt(0);
            if (MetadataWriter.isReservedChar(n)) continue;
            stringBuilder.appendCodePoint(n);
        }
        if (stringBuilder.length() >= 3) {
            return stringBuilder.toString();
        }
        stringBuilder.setLength(0);
        return MetadataWriter.removeReservedChars(string, stringBuilder.append(string));
    }

    private static String removeReservedChars(String string, StringBuilder stringBuilder) {
        if (string != null) {
            boolean bl = false;
            int n = string.length();
            while (--n >= 0) {
                char c = string.charAt(n);
                if (!MetadataWriter.isReservedChar(c)) continue;
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder(string);
                }
                stringBuilder.deleteCharAt(n);
                bl = true;
            }
            if (bl) {
                return stringBuilder.toString();
            }
        }
        return string;
    }

    private static boolean isReservedChar(int n) {
        return n == 123 || n == 125;
    }

    private static String nonEmpty(String string) {
        if (string != null && (string = string.trim()).isEmpty()) {
            string = null;
        }
        return string;
    }

    private static final class FKey {
        final String tableName;
        Class<?> tableType;
        final String keyName;

        FKey(String string, Class<?> clazz, String string2) {
            this.tableName = string;
            this.tableType = clazz;
            this.keyName = string2;
        }
    }
}

