/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.sis.internal.metadata.Identifiers;
import org.apache.sis.internal.metadata.NameMeaning;
import org.apache.sis.internal.metadata.NameToIdentifier;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.referencing.AbstractIdentifiedObject;
import org.apache.sis.referencing.AuthorityFactories;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.Properties;
import org.apache.sis.referencing.factory.GeodeticAuthorityFactory;
import org.apache.sis.referencing.factory.IdentifiedObjectFinder;
import org.apache.sis.referencing.factory.NoSuchAuthorityFactoryException;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Static;
import org.apache.sis.util.logging.Logging;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.ConcatenatedOperation;
import org.opengis.util.FactoryException;
import org.opengis.util.GenericName;

public final class IdentifiedObjects
extends Static {
    private IdentifiedObjects() {
    }

    public static Map<String, ?> getProperties(IdentifiedObject identifiedObject, String ... stringArray) {
        ArgumentChecks.ensureNonNull((String)"object", (Object)identifiedObject);
        ArgumentChecks.ensureNonNull((String)"excludes", (Object)stringArray);
        return new Properties(identifiedObject, stringArray);
    }

    public static Set<String> getNames(IdentifiedObject identifiedObject, Citation citation) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(8);
        IdentifiedObjects.getName(identifiedObject, citation, linkedHashSet);
        return linkedHashSet;
    }

    public static String getName(IdentifiedObject identifiedObject, Citation citation) {
        return IdentifiedObjects.getName(identifiedObject, citation, null);
    }

    private static String getName(IdentifiedObject identifiedObject, Citation citation, Collection<String> collection) {
        block12: {
            if (identifiedObject == null) break block12;
            ReferenceIdentifier referenceIdentifier = identifiedObject.getName();
            if (citation == null) {
                Object object;
                if (referenceIdentifier != null && (object = referenceIdentifier.getCode()) != null) {
                    if (collection == null) {
                        return object;
                    }
                    collection.add((String)object);
                }
                object = CollectionsExt.iterator((Collection)identifiedObject.getAlias());
                while (object.hasNext()) {
                    String string;
                    GenericName genericName = (GenericName)object.next();
                    if (genericName == null || (string = genericName instanceof Identifier ? ((Identifier)genericName).getCode() : genericName.toString()) == null) continue;
                    if (collection == null) {
                        return string;
                    }
                    collection.add(string);
                }
            } else {
                Object object;
                if (referenceIdentifier != null && Citations.identifierMatches((Citation)citation, (Citation)referenceIdentifier.getAuthority()) && (object = referenceIdentifier.getCode()) != null) {
                    if (collection == null) {
                        return object;
                    }
                    collection.add((String)object);
                }
                object = CollectionsExt.iterator((Collection)identifiedObject.getAlias());
                while (object.hasNext()) {
                    String string;
                    GenericName genericName;
                    Object object2;
                    GenericName genericName2 = (GenericName)object.next();
                    if (genericName2 == null) continue;
                    if (genericName2 instanceof Identifier) {
                        referenceIdentifier = (Identifier)genericName2;
                        if (!Citations.identifierMatches((Citation)citation, (Citation)referenceIdentifier.getAuthority()) || (object2 = referenceIdentifier.getCode()) == null) continue;
                        if (collection == null) {
                            return object2;
                        }
                        collection.add((String)object2);
                        continue;
                    }
                    object2 = genericName2.scope();
                    if (object2 == null || (genericName = object2.name()) == null || !Citations.identifierMatches((Citation)citation, (String)genericName.toString()) || (string = genericName2.toString()) == null) continue;
                    if (collection == null) {
                        return string;
                    }
                    collection.add(string);
                }
            }
        }
        return null;
    }

    public static Identifier getIdentifier(IdentifiedObject identifiedObject, Citation citation) {
        if (identifiedObject != null) {
            Iterator iterator = CollectionsExt.iterator((Collection)identifiedObject.getIdentifiers());
            while (iterator.hasNext()) {
                Identifier identifier = (Identifier)iterator.next();
                if (identifier == null || citation != null && !Citations.identifierMatches((Citation)citation, (Citation)identifier.getAuthority())) continue;
                return identifier;
            }
        }
        return null;
    }

    public static String getIdentifierOrName(IdentifiedObject identifiedObject) {
        if (identifiedObject != null) {
            String string;
            Iterator iterator = CollectionsExt.iterator((Collection)identifiedObject.getIdentifiers());
            while (iterator.hasNext()) {
                string = IdentifiedObjects.toString((Identifier)iterator.next());
                if (string == null) continue;
                return string;
            }
            string = IdentifiedObjects.toString((Identifier)identifiedObject.getName());
            if (string != null) {
                return string;
            }
        }
        return null;
    }

    public static String getSimpleNameOrIdentifier(IdentifiedObject identifiedObject) {
        if (identifiedObject != null) {
            String string;
            Object object;
            Object object2;
            ReferenceIdentifier referenceIdentifier = identifiedObject.getName();
            if (referenceIdentifier != null && CharSequences.isUnicodeIdentifier((CharSequence)(object2 = referenceIdentifier.getCode()))) {
                return object2;
            }
            object2 = CollectionsExt.iterator((Collection)identifiedObject.getAlias());
            while (object2.hasNext()) {
                object = (GenericName)object2.next();
                if (object == null || (object = object.tip()) == null || !CharSequences.isUnicodeIdentifier((CharSequence)(string = object.toString()))) continue;
                return string;
            }
            object = CollectionsExt.iterator((Collection)identifiedObject.getIdentifiers());
            while (object.hasNext()) {
                referenceIdentifier = (Identifier)object.next();
                if (referenceIdentifier == null || !CharSequences.isUnicodeIdentifier((CharSequence)(string = referenceIdentifier.getCode()))) continue;
                return string;
            }
        }
        return null;
    }

    @Deprecated
    public static String getUnicodeIdentifier(IdentifiedObject identifiedObject) {
        return IdentifiedObjects.getSimpleNameOrIdentifier(identifiedObject);
    }

    public static String lookupURN(IdentifiedObject identifiedObject, Citation citation) throws FactoryException {
        List list;
        IdentifiedObjectFinder identifiedObjectFinder;
        if (identifiedObject == null) {
            return null;
        }
        try {
            identifiedObjectFinder = IdentifiedObjects.newFinder(Citations.toCodeSpace((Citation)citation));
        }
        catch (NoSuchAuthorityFactoryException noSuchAuthorityFactoryException) {
            IdentifiedObjects.warning("lookupURN", (Exception)((Object)noSuchAuthorityFactoryException));
            identifiedObjectFinder = IdentifiedObjects.newFinder(null);
        }
        String string = IdentifiedObjects.lookupURN(identifiedObject, citation, identifiedObjectFinder);
        if (string != null) {
            return string;
        }
        if (identifiedObject instanceof CompoundCRS) {
            list = CRS.getSingleComponents((CoordinateReferenceSystem)((CompoundCRS)identifiedObject));
        } else if (identifiedObject instanceof ConcatenatedOperation) {
            list = ((ConcatenatedOperation)identifiedObject).getOperations();
        } else {
            return null;
        }
        StringBuilder stringBuilder = null;
        for (IdentifiedObject identifiedObject2 : list) {
            string = IdentifiedObjects.lookupURN(identifiedObject2, citation, identifiedObjectFinder);
            if (string == null) {
                return null;
            }
            assert (string.startsWith("urn:ogc:def")) : string;
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder(40).append("urn:ogc:def").append(':').append(NameMeaning.toObjectType(identifiedObject.getClass()));
            }
            stringBuilder.append(',').append(string, "urn:ogc:def".length() + 1, string.length());
        }
        return stringBuilder != null ? stringBuilder.toString() : null;
    }

    private static String lookupURN(IdentifiedObject identifiedObject, Citation citation, IdentifiedObjectFinder identifiedObjectFinder) throws FactoryException {
        String string = null;
        if (identifiedObject != null) {
            for (IdentifiedObject identifiedObject2 : identifiedObjectFinder.find(identifiedObject)) {
                String string2 = IdentifiedObjects.toURN(identifiedObject2.getClass(), IdentifiedObjects.getIdentifier(identifiedObject2, citation));
                if (string2 == null && citation == null) {
                    for (Identifier identifier : identifiedObject2.getIdentifiers()) {
                        string2 = IdentifiedObjects.toURN(identifiedObject2.getClass(), identifier);
                        if (string2 == null) continue;
                        break;
                    }
                }
                if (string2 == null) continue;
                if (string != null && !string.equals(string2)) {
                    return null;
                }
                string = string2;
            }
        }
        return string;
    }

    public static Integer lookupEPSG(IdentifiedObject identifiedObject) throws FactoryException {
        Integer n = null;
        if (identifiedObject != null) {
            for (IdentifiedObject identifiedObject2 : IdentifiedObjects.newFinder("EPSG").find(identifiedObject)) {
                Identifier identifier = IdentifiedObjects.getIdentifier(identifiedObject2, (Citation)Citations.EPSG);
                if (identifier == null) continue;
                try {
                    Integer n2 = n;
                    n = Integer.valueOf(identifier.getCode());
                    if (n2 == null || n2.equals(n)) continue;
                    return null;
                }
                catch (NumberFormatException numberFormatException) {
                    IdentifiedObjects.warning("lookupEPSG", numberFormatException);
                }
            }
        }
        return n;
    }

    private static void warning(String string, Exception exception) {
        Logging.recoverableException((Logger)Logging.getLogger((String)"org.apache.sis.referencing"), IdentifiedObjects.class, (String)string, (Throwable)exception);
    }

    public static IdentifiedObjectFinder newFinder(String string) throws NoSuchAuthorityFactoryException, FactoryException {
        GeodeticAuthorityFactory geodeticAuthorityFactory = string == null ? AuthorityFactories.ALL : AuthorityFactories.ALL.getAuthorityFactory(GeodeticAuthorityFactory.class, string, null);
        return ((GeodeticAuthorityFactory)geodeticAuthorityFactory).newIdentifiedObjectFinder();
    }

    public static boolean isHeuristicMatchForName(IdentifiedObject identifiedObject, String string) {
        ArgumentChecks.ensureNonNull((String)"name", (Object)string);
        if (identifiedObject == null) {
            return false;
        }
        if (identifiedObject instanceof AbstractIdentifiedObject) {
            return ((AbstractIdentifiedObject)identifiedObject).isHeuristicMatchForName(string);
        }
        return NameToIdentifier.isHeuristicMatchForName((Identifier)identifiedObject.getName(), (Collection)identifiedObject.getAlias(), (CharSequence)string, (NameToIdentifier.Simplifier)NameToIdentifier.Simplifier.DEFAULT);
    }

    public static String toURN(Class<?> clazz, Identifier identifier) {
        ArgumentChecks.ensureNonNull((String)"type", clazz);
        if (identifier == null) {
            return null;
        }
        String string = null;
        if (identifier instanceof ReferenceIdentifier) {
            string = ((ReferenceIdentifier)identifier).getCodeSpace();
        }
        if (string == null || string.isEmpty()) {
            string = Identifiers.getIdentifier((Citation)identifier.getAuthority(), (boolean)true);
        }
        return NameMeaning.toURN(clazz, (String)string, (String)(identifier instanceof ReferenceIdentifier ? ((ReferenceIdentifier)identifier).getVersion() : null), (String)identifier.getCode());
    }

    public static String toString(Identifier identifier) {
        if (identifier == null) {
            return null;
        }
        if (identifier instanceof GenericName) {
            return identifier.toString();
        }
        String string = identifier.getCode();
        String string2 = null;
        if (identifier instanceof ReferenceIdentifier) {
            string2 = ((ReferenceIdentifier)identifier).getCodeSpace();
        }
        if (string2 == null || string2.isEmpty()) {
            string2 = Citations.toCodeSpace((Citation)identifier.getAuthority());
        }
        if (string2 != null) {
            return string2 + ':' + string;
        }
        return string;
    }
}

