/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.navigation;

import java.io.Serializable;
import java.util.Date;
import org.exoplatform.commons.utils.Safe;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.Visibility;
import org.exoplatform.portal.mop.page.PageKey;

public final class NodeState
implements Serializable {
    public static final NodeState INITIAL = new Builder().build();
    private final String label;
    private final String icon;
    private final long startPublicationTime;
    private final long endPublicationTime;
    private final Visibility visibility;
    private final PageKey pageRef;
    private final SiteKey siteKey;

    public NodeState(String label, String icon, long startPublicationTime, long endPublicationTime, Visibility visibility, PageKey pageRef, SiteKey siteKey) {
        this.label = label;
        this.icon = icon;
        this.startPublicationTime = startPublicationTime;
        this.endPublicationTime = endPublicationTime;
        this.visibility = visibility;
        this.pageRef = pageRef;
        this.siteKey = siteKey;
    }

    public String getLabel() {
        return this.label;
    }

    public String getIcon() {
        return this.icon;
    }

    public long getStartPublicationTime() {
        return this.startPublicationTime;
    }

    Date getStartPublicationDate() {
        return this.startPublicationTime != -1L ? new Date(this.startPublicationTime) : null;
    }

    public long getEndPublicationTime() {
        return this.endPublicationTime;
    }

    Date getEndPublicationDate() {
        return this.endPublicationTime != -1L ? new Date(this.endPublicationTime) : null;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public PageKey getPageRef() {
        return this.pageRef;
    }

    public SiteKey getSiteKey() {
        return this.siteKey;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof NodeState) {
            NodeState that = (NodeState)o;
            return Safe.equals(this.label, that.label) && Safe.equals(this.icon, that.icon) && Safe.equals(this.startPublicationTime, that.startPublicationTime) && Safe.equals(this.endPublicationTime, that.endPublicationTime) && Safe.equals((Object)this.visibility, (Object)that.visibility) && Safe.equals(this.pageRef, that.pageRef);
        }
        return false;
    }

    public String toString() {
        return "NodeState[label=" + this.label + ",icon=" + this.icon + ",startPublicationTime=" + this.startPublicationTime + ",endPublicationTime=" + this.endPublicationTime + ",visibility=" + this.visibility + ",pageRef=" + this.pageRef + "]";
    }

    public Builder builder() {
        return new Builder(this);
    }

    public static class Builder {
        private String label;
        private String icon;
        private long startPublicationTime;
        private long endPublicationTime;
        private Visibility visibility;
        private PageKey pageRef;
        private SiteKey siteKey;

        public Builder() {
            this.icon = null;
            this.label = null;
            this.startPublicationTime = -1L;
            this.endPublicationTime = -1L;
            this.visibility = Visibility.DISPLAYED;
            this.pageRef = null;
        }

        public Builder(NodeState state) throws NullPointerException {
            if (state == null) {
                throw new NullPointerException();
            }
            this.label = state.label;
            this.icon = state.icon;
            this.startPublicationTime = state.startPublicationTime;
            this.endPublicationTime = state.endPublicationTime;
            this.visibility = state.visibility;
            this.pageRef = state.pageRef;
            this.siteKey = state.siteKey;
        }

        public Builder label(String label) {
            this.label = label;
            return this;
        }

        public Builder icon(String icon) {
            this.icon = icon;
            return this;
        }

        public Builder startPublicationTime(long startPublicationTime) {
            this.startPublicationTime = startPublicationTime;
            return this;
        }

        public Builder endPublicationTime(long endPublicationTime) {
            this.endPublicationTime = endPublicationTime;
            return this;
        }

        public Builder visibility(Visibility visibility) {
            this.visibility = visibility;
            return this;
        }

        public Builder pageRef(PageKey pageRef) {
            this.pageRef = pageRef;
            return this;
        }

        public Builder siteKey(SiteKey siteKey) {
            this.siteKey = siteKey;
            return this;
        }

        public NodeState build() {
            return new NodeState(this.label, this.icon, this.startPublicationTime, this.endPublicationTime, this.visibility, this.pageRef, this.siteKey);
        }
    }
}

