/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.util.Arrays;
import org.apache.sis.internal.referencing.ExtendedPrecisionMatrix;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.transform.AbstractLinearTransform;
import org.apache.sis.referencing.operation.transform.IterationStrategy;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.operation.Matrix;

final class TranslationTransform
extends AbstractLinearTransform
implements ExtendedPrecisionMatrix {
    private static final long serialVersionUID = 7382503993222285134L;
    private final double[] offsets;
    private final double[] errors;

    TranslationTransform(int n, double d) {
        this.offsets = new double[n];
        Arrays.fill(this.offsets, d);
        this.errors = null;
    }

    TranslationTransform(double[] dArray) {
        this.offsets = (double[])dArray.clone();
        this.errors = null;
    }

    TranslationTransform(int n, double[] dArray) {
        int n2 = n * n;
        int n3 = n - 1;
        this.offsets = new double[n3];
        double[] dArray2 = null;
        int n4 = -1;
        for (int i = 0; i < n3; ++i) {
            double d;
            int n5 = n3 + i * n;
            this.offsets[i] = dArray[n5];
            if ((n5 += n2) >= dArray.length || (d = dArray[n5]) == 0.0) continue;
            if (dArray2 == null) {
                dArray2 = new double[n3];
            }
            dArray2[i] = d;
            n4 = i;
        }
        this.errors = ArraysExt.resize(dArray2, (int)(n4 + 1));
    }

    @Override
    public double[] getExtendedElements() {
        int n = this.offsets.length;
        int n2 = this.getNumCol();
        int n3 = this.getNumRow() * n2;
        double[] dArray = new double[this.errors == null ? n3 : n3 << 1];
        for (int i = 0; i < n; ++i) {
            int n4 = i * n2;
            dArray[n4 + i] = 1.0;
            dArray[n4 += n] = this.offsets[i];
            if (this.errors == null || i >= this.errors.length) continue;
            dArray[n4 + n3] = this.errors[i];
        }
        dArray[n3 - 1] = 1.0;
        return dArray;
    }

    @Override
    public int getSourceDimensions() {
        return this.offsets.length;
    }

    @Override
    public int getTargetDimensions() {
        return this.offsets.length;
    }

    public double getElement(int n, int n2) {
        int n3 = this.offsets.length;
        ArgumentChecks.ensureBetween((String)"row", (int)0, (int)n3, (int)n);
        ArgumentChecks.ensureBetween((String)"column", (int)0, (int)n3, (int)n2);
        if (n2 == n) {
            return 1.0;
        }
        if (n2 == n3) {
            return this.offsets[n];
        }
        return 0.0;
    }

    @Override
    public boolean isIdentity() {
        for (int i = 0; i < this.offsets.length; ++i) {
            if (this.offsets[i] == 0.0) continue;
            return false;
        }
        return true;
    }

    @Override
    public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) {
        this.transform(dArray, n, dArray2, n2, 1);
        return bl ? this.derivative(null) : null;
    }

    @Override
    public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        int n4;
        if (dArray == dArray2 && IterationStrategy.suggest(n, n4 = this.offsets.length, n2, n4, n3) != IterationStrategy.ASCENDING) {
            dArray = Arrays.copyOfRange(dArray, n, n + n3 * n4);
            n = 0;
        }
        while (--n3 >= 0) {
            for (n4 = 0; n4 < this.offsets.length; ++n4) {
                dArray2[n2++] = dArray[n++] + this.offsets[n4];
            }
        }
    }

    @Override
    public void transform(float[] fArray, int n, float[] fArray2, int n2, int n3) {
        int n4;
        if (fArray == fArray2 && IterationStrategy.suggest(n, n4 = this.offsets.length, n2, n4, n3) != IterationStrategy.ASCENDING) {
            fArray = Arrays.copyOfRange(fArray, n, n + n3 * n4);
            n = 0;
        }
        while (--n3 >= 0) {
            for (n4 = 0; n4 < this.offsets.length; ++n4) {
                fArray2[n2++] = (float)((double)fArray[n++] + this.offsets[n4]);
            }
        }
    }

    @Override
    public void transform(double[] dArray, int n, float[] fArray, int n2, int n3) {
        while (--n3 >= 0) {
            for (int i = 0; i < this.offsets.length; ++i) {
                fArray[n2++] = (float)(dArray[n++] + this.offsets[i]);
            }
        }
    }

    @Override
    public void transform(float[] fArray, int n, double[] dArray, int n2, int n3) {
        while (--n3 >= 0) {
            for (int i = 0; i < this.offsets.length; ++i) {
                dArray[n2++] = (double)fArray[n++] + this.offsets[i];
            }
        }
    }

    @Override
    public Matrix derivative(DirectPosition directPosition) {
        return Matrices.createIdentity(this.offsets.length);
    }

    @Override
    protected int computeHashCode() {
        return Arrays.hashCode(this.offsets) + 31 * super.computeHashCode();
    }

    @Override
    protected boolean equalsSameClass(Object object) {
        TranslationTransform translationTransform = (TranslationTransform)object;
        return Arrays.equals(this.offsets, translationTransform.offsets) && Arrays.equals(this.errors, translationTransform.errors);
    }
}

