/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.storage;

import java.util.Date;
import java.util.List;
import org.exoplatform.addons.gamification.entities.domain.configuration.RuleEntity;
import org.exoplatform.addons.gamification.service.dto.configuration.Challenge;
import org.exoplatform.addons.gamification.service.dto.configuration.RuleDTO;
import org.exoplatform.addons.gamification.service.dto.configuration.constant.TypeRule;
import org.exoplatform.addons.gamification.service.mapper.EntityMapper;
import org.exoplatform.addons.gamification.service.mapper.RuleMapper;
import org.exoplatform.addons.gamification.storage.dao.RuleDAO;

public class RuleStorage {
    private RuleDAO ruleDAO;

    public RuleStorage(RuleDAO ruleDAO) {
        this.ruleDAO = ruleDAO;
    }

    public RuleDTO saveRule(RuleDTO ruleDTO) {
        RuleEntity ruleEntity = RuleMapper.ruleDTOToRule(ruleDTO);
        if (ruleEntity.getId() == null) {
            ruleEntity = (RuleEntity)this.ruleDAO.create(ruleEntity);
        } else if (!ruleEntity.isDeleted()) {
            ruleEntity.setLastModifiedDate(new Date());
            ruleEntity = (RuleEntity)this.ruleDAO.update(ruleEntity);
        }
        return RuleMapper.ruleToRuleDTO(ruleEntity);
    }

    public RuleDTO findEnableRuleByTitle(String ruleTitle) {
        return RuleMapper.ruleToRuleDTO(this.ruleDAO.findEnableRuleByTitle(ruleTitle));
    }

    public RuleDTO findRuleById(Long id) {
        return RuleMapper.ruleToRuleDTO((RuleEntity)this.ruleDAO.find(id));
    }

    public List<RuleDTO> findEnabledRulesByEvent(String event) {
        List<RuleEntity> entities = this.ruleDAO.findEnabledRulesByEvent(event);
        return RuleMapper.rulesToRuleDTOs(entities);
    }

    public RuleDTO findRuleByTitle(String ruleTitle) {
        return RuleMapper.ruleToRuleDTO(this.ruleDAO.findRuleByTitle(ruleTitle));
    }

    public RuleDTO findRuleByEventAndDomain(String event, String domain) {
        return RuleMapper.ruleToRuleDTO(this.ruleDAO.findRuleByEventAndDomain(event, domain));
    }

    public List<RuleDTO> getAllAutomaticRules() {
        return RuleMapper.rulesToRuleDTOs(this.ruleDAO.getAllAutomaticRules());
    }

    public List<RuleDTO> findAllRules() {
        return RuleMapper.rulesToRuleDTOs(this.ruleDAO.getAllRules());
    }

    public List<RuleDTO> getActiveRules() {
        return RuleMapper.rulesToRuleDTOs(this.ruleDAO.getActiveRules());
    }

    public List<RuleDTO> getAllRulesByDomain(String domain) {
        return RuleMapper.rulesToRuleDTOs(this.ruleDAO.getAllRulesByDomain(domain));
    }

    public List<RuleDTO> getAllRulesWithNullDomain() {
        return RuleMapper.rulesToRuleDTOs(this.ruleDAO.getAllRulesWithNullDomain());
    }

    public List<String> getAllEvents() {
        return this.ruleDAO.getAllEvents();
    }

    public List<String> getDomainListFromRules() {
        return this.ruleDAO.getDomainList();
    }

    public void deleteRule(RuleDTO rule) {
        RuleEntity ruleEntity = RuleMapper.ruleDTOToRule(rule);
        this.ruleDAO.update(ruleEntity);
    }

    public Challenge saveChallenge(Challenge challenge, String username) {
        RuleEntity challengeEntity = EntityMapper.toEntity(challenge);
        if (challenge.getId() == 0L) {
            challengeEntity.setId(null);
            challengeEntity.setCreatedBy(username);
            challengeEntity.setType(TypeRule.MANUAL);
            challengeEntity.setEvent(challengeEntity.getTitle());
            challengeEntity = (RuleEntity)this.ruleDAO.create(challengeEntity);
        } else {
            RuleEntity ruleEntity = (RuleEntity)this.ruleDAO.find(challengeEntity.getId());
            challengeEntity.setCreatedBy(ruleEntity.getCreatedBy());
            challengeEntity.setType(ruleEntity.getType());
            challengeEntity.setEvent(ruleEntity.getEvent());
            challengeEntity = (RuleEntity)this.ruleDAO.update(challengeEntity);
        }
        return EntityMapper.fromEntity(challengeEntity);
    }

    public Challenge getChallengeById(long challengeId) {
        RuleEntity challengeEntity = (RuleEntity)this.ruleDAO.find(Long.valueOf(challengeId));
        if (challengeEntity == null || challengeEntity.getType() == TypeRule.AUTOMATIC) {
            return null;
        }
        return EntityMapper.fromEntity(challengeEntity);
    }

    public List<RuleEntity> findAllChallengesByUser(int offset, int limit, List<Long> ids) {
        return this.ruleDAO.findAllChallengesByUser(offset, limit, ids);
    }

    public void deleteChallenge(Challenge challenge) {
        RuleEntity challengeEntity = EntityMapper.toEntity(challenge);
        this.ruleDAO.delete(challengeEntity);
    }

    public void clearCache() {
    }
}

