/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.storage.dao.jpa;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import javax.persistence.Tuple;
import javax.persistence.TypedQuery;
import org.apache.commons.collections.CollectionUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.social.core.jpa.storage.dao.jpa.MetadataItemDAO$AjcClosure1;
import org.exoplatform.social.core.jpa.storage.dao.jpa.MetadataItemDAO$AjcClosure3;
import org.exoplatform.social.core.jpa.storage.dao.jpa.MetadataItemDAO$AjcClosure5;
import org.exoplatform.social.core.jpa.storage.entity.MetadataItemEntity;

public class MetadataItemDAO
extends GenericDAOJPAImpl<MetadataItemEntity, Long> {
    private static final String METADATA_ID = "metadataId";
    private static final String METADATA_NAME = "metadataName";
    private static final String METADATA_TYPE = "metadataType";
    private static final String PARENT_OBJECT_ID = "parentObjectId";
    private static final String OBJECT_ID = "objectId";
    private static final String OBJECT_TYPE = "objectType";
    private static final String CREATOR_ID = "creatorId";
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    public List<MetadataItemEntity> getMetadataItemsByObject(String objectType, String objectId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SocMetadataItemEntity.getMetadataItemsByObject", MetadataItemEntity.class);
        query.setParameter(OBJECT_TYPE, (Object)objectType);
        query.setParameter(OBJECT_ID, (Object)objectId);
        return query.getResultList();
    }

    public Set<String> getMetadataNamesByObject(String objectType, String objectId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SocMetadataItemEntity.getMetadataNamesByObject", String.class);
        query.setParameter(OBJECT_TYPE, (Object)objectType);
        query.setParameter(OBJECT_ID, (Object)objectId);
        List resultList = query.getResultList();
        return resultList == null ? Collections.emptySet() : new HashSet(resultList);
    }

    public List<MetadataItemEntity> getMetadataItemsByMetadataAndObject(long metadataId, String objectType, String objectId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SocMetadataItemEntity.getMetadataItemsByMetadataAndObject", MetadataItemEntity.class);
        query.setParameter(METADATA_ID, (Object)metadataId);
        query.setParameter(OBJECT_TYPE, (Object)objectType);
        query.setParameter(OBJECT_ID, (Object)objectId);
        return query.getResultList();
    }

    public List<MetadataItemEntity> getMetadataItemsByMetadataTypeAndObject(long metadataType, String objectType, String objectId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SocMetadataItemEntity.getMetadataItemsByMetadataTypeAndObject", MetadataItemEntity.class);
        query.setParameter(METADATA_TYPE, (Object)metadataType);
        query.setParameter(OBJECT_TYPE, (Object)objectType);
        query.setParameter(OBJECT_ID, (Object)objectId);
        return query.getResultList();
    }

    public List<MetadataItemEntity> getMetadataItemsByMetadataNameAndTypeAndObjectAndMetadataItemProperty(String metadataName, long metadataType, String objectType, String propertyKey, String propertyValue, long offset, long limit) {
        try {
            Query query = this.getMetadataItemsByMetadataNameAndTypeAndObjectAndMetadataItemPropertyQuery(metadataName, metadataType, objectType, propertyKey, propertyValue);
            if (offset > 0L) {
                query.setFirstResult((int)offset);
            }
            if (limit > 0L) {
                query.setMaxResults((int)limit);
            }
            return query.getResultList();
        }
        catch (NoResultException e) {
            return Collections.emptyList();
        }
    }

    public List<MetadataItemEntity> getMetadataItemsByMetadataNameAndTypeAndObject(String metadataName, long metadataType, String objectType, long offset, long limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SocMetadataItemEntity.getMetadataItemsByMetadataTypeAndNameAndObject", MetadataItemEntity.class);
        query.setParameter(METADATA_NAME, (Object)metadataName);
        query.setParameter(METADATA_TYPE, (Object)metadataType);
        query.setParameter(OBJECT_TYPE, (Object)objectType);
        if (offset > 0L) {
            query.setFirstResult((int)offset);
        }
        if (limit > 0L) {
            query.setMaxResults((int)limit);
        }
        return query.getResultList();
    }

    public List<MetadataItemEntity> getMetadataItemsByMetadataTypeAndCreator(long metadataType, long creatorId, long offset, long limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SocMetadataItemEntity.getMetadataItemsByMetadataTypeAndCreator", MetadataItemEntity.class);
        query.setParameter(METADATA_TYPE, (Object)metadataType);
        query.setParameter(CREATOR_ID, (Object)creatorId);
        if (offset > 0L) {
            query.setFirstResult((int)offset);
        }
        if (limit > 0L) {
            query.setMaxResults((int)limit);
        }
        return query.getResultList();
    }

    public int countMetadataItemsByMetadataTypeAndCreator(long metadataType, long creatorId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SocMetadataItemEntity.countMetadataItemsByMetadataTypeAndCreator", Long.class);
        query.setParameter(METADATA_TYPE, (Object)metadataType);
        query.setParameter(CREATOR_ID, (Object)creatorId);
        return ((Long)query.getSingleResult()).intValue();
    }

    public List<String> getMetadataObjectIds(long metadataType, String metadataName, String objectType, long offset, long limit) {
        List result;
        TypedQuery query = this.getEntityManager().createNamedQuery("SocMetadataItemEntity.getMetadataObjectIds", Tuple.class);
        query.setParameter(METADATA_TYPE, (Object)metadataType);
        query.setParameter(METADATA_NAME, (Object)metadataName);
        query.setParameter(OBJECT_TYPE, (Object)objectType);
        if (offset > 0L) {
            query.setFirstResult((int)offset);
        }
        if (limit > 0L) {
            query.setMaxResults((int)limit);
        }
        if (CollectionUtils.isEmpty((Collection)(result = query.getResultList()))) {
            return Collections.emptyList();
        }
        return result.stream().map(tuple -> (String)tuple.get(0)).distinct().collect(Collectors.toList());
    }

    @ExoTransactional
    public int deleteMetadataItemsByObject(String objectType, String objectId) {
        String string = objectType;
        String string2 = objectId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)string, (Object)string2);
        Object[] objectArray = new Object[]{this, string, string2, joinPoint};
        MetadataItemDAO$AjcClosure1 metadataItemDAO$AjcClosure1 = new MetadataItemDAO$AjcClosure1(objectArray);
        return Conversions.intValue((Object)ExoTransactionalAspect.aspectOf().around(metadataItemDAO$AjcClosure1.linkClosureAndJoinPoint(69648)));
    }

    @ExoTransactional
    public int deleteMetadataItemsByParentObject(String objectType, String parentObjectId) {
        String string = objectType;
        String string2 = parentObjectId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object)string, (Object)string2);
        Object[] objectArray = new Object[]{this, string, string2, joinPoint};
        MetadataItemDAO$AjcClosure3 metadataItemDAO$AjcClosure3 = new MetadataItemDAO$AjcClosure3(objectArray);
        return Conversions.intValue((Object)ExoTransactionalAspect.aspectOf().around(metadataItemDAO$AjcClosure3.linkClosureAndJoinPoint(69648)));
    }

    @ExoTransactional
    public int deleteMetadataItemById(long id) {
        long l = id;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this), (Object)Conversions.longObject((long)l));
        Object[] objectArray = new Object[]{this, Conversions.longObject((long)l), joinPoint};
        MetadataItemDAO$AjcClosure5 metadataItemDAO$AjcClosure5 = new MetadataItemDAO$AjcClosure5(objectArray);
        return Conversions.intValue((Object)ExoTransactionalAspect.aspectOf().around(metadataItemDAO$AjcClosure5.linkClosureAndJoinPoint(69648)));
    }

    private Query getMetadataItemsByMetadataNameAndTypeAndObjectAndMetadataItemPropertyQuery(String metadataName, long metadataType, String objectType, String propertyKey, String propertyValue) {
        StringBuilder queryStringBuilder = null;
        queryStringBuilder = new StringBuilder("SELECT DISTINCT sm.* ");
        queryStringBuilder.append(" FROM SOC_METADATA_ITEMS sm \n");
        queryStringBuilder.append(" INNER JOIN SOC_METADATAS sm_ \n");
        queryStringBuilder.append(" ON sm.metadata_id = sm_.metadata_id \n");
        queryStringBuilder.append(" AND sm_.type = ").append(metadataType).append(" \n");
        queryStringBuilder.append(" AND sm_.name = '").append(metadataName).append("' \n");
        queryStringBuilder.append(" INNER JOIN SOC_METADATA_ITEMS_PROPERTIES sm_prop \n");
        queryStringBuilder.append(" ON sm.metadata_item_id = sm_prop.metadata_item_id ").append(" \n");
        queryStringBuilder.append(" AND sm_prop.name = '").append(propertyKey).append("' \n");
        queryStringBuilder.append(" AND sm_prop.value = '").append(propertyValue).append("' \n");
        queryStringBuilder.append(" WHERE sm.object_type = '").append(objectType).append("' \n");
        queryStringBuilder.append(" ORDER BY sm.created_date DESC, sm.metadata_id DESC");
        return this.getEntityManager().createNativeQuery(queryStringBuilder.toString(), MetadataItemEntity.class);
    }

    static {
        MetadataItemDAO.ajc$preClinit();
    }

    static /* synthetic */ int deleteMetadataItemsByObject_aroundBody0(MetadataItemDAO ajc$this, String objectType, String objectId, JoinPoint joinPoint) {
        Query query = ajc$this.getEntityManager().createNamedQuery("SocMetadataItemEntity.deleteMetadataItemsByObject");
        query.setParameter(OBJECT_TYPE, (Object)objectType);
        query.setParameter(OBJECT_ID, (Object)objectId);
        return query.executeUpdate();
    }

    static /* synthetic */ int deleteMetadataItemsByParentObject_aroundBody2(MetadataItemDAO ajc$this, String objectType, String parentObjectId, JoinPoint joinPoint) {
        Query query = ajc$this.getEntityManager().createNamedQuery("SocMetadataItemEntity.deleteMetadataItemsByParentObject");
        query.setParameter(OBJECT_TYPE, (Object)objectType);
        query.setParameter(PARENT_OBJECT_ID, (Object)parentObjectId);
        return query.executeUpdate();
    }

    static /* synthetic */ int deleteMetadataItemById_aroundBody4(MetadataItemDAO ajc$this, long id, JoinPoint joinPoint) {
        Query query = ajc$this.getEntityManager().createNamedQuery("SocMetadataItemEntity.deleteMetadataItemById");
        query.setParameter("id", (Object)id);
        return query.executeUpdate();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("MetadataItemDAO.java", MetadataItemDAO.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteMetadataItemsByObject", "org.exoplatform.social.core.jpa.storage.dao.jpa.MetadataItemDAO", "java.lang.String:java.lang.String", "objectType:objectId", "", "int"), 178);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteMetadataItemsByParentObject", "org.exoplatform.social.core.jpa.storage.dao.jpa.MetadataItemDAO", "java.lang.String:java.lang.String", "objectType:parentObjectId", "", "int"), 186);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteMetadataItemById", "org.exoplatform.social.core.jpa.storage.dao.jpa.MetadataItemDAO", "long", "id", "", "int"), 194);
    }
}

