/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.settings.jpa.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.exoplatform.commons.api.persistence.ExoEntity;
import org.exoplatform.settings.jpa.entity.ContextEntity;
import org.exoplatform.settings.jpa.entity.ScopeEntity;

@Entity(name="SettingsEntity")
@ExoEntity
@Table(name="STG_SETTINGS")
@NamedQueries(value={@NamedQuery(name="SettingsEntity.getSettingsByContextAndScope", query="SELECT s FROM SettingsEntity s WHERE s.context.type= :contextType AND s.context.name= :contextName AND s.scope.name= :scopeName AND s.scope.type= :scopeType "), @NamedQuery(name="SettingsEntity.getSettingsByContextAndScopeWithNullName", query="SELECT s FROM SettingsEntity s WHERE s.context.type= :contextType AND s.context.name= :contextName AND s.scope.name IS NULL AND s.scope.type= :scopeType "), @NamedQuery(name="SettingsEntity.getSettingByContextAndScopeAndKey", query="SELECT s FROM SettingsEntity s WHERE s.name = :settingName AND s.context.type= :contextType AND s.context.name= :contextName AND s.scope.name= :scopeName AND s.scope.type= :scopeType "), @NamedQuery(name="SettingsEntity.getSettingByContextAndScopeWithNullNameAndKey", query="SELECT s FROM SettingsEntity s WHERE s.name = :settingName AND s.context.type= :contextType AND s.context.name= :contextName AND s.scope.name IS NULL AND s.scope.type= :scopeType "), @NamedQuery(name="SettingsEntity.countSettingsByNameAndValueAndScope", query="SELECT count(s.id) FROM SettingsEntity s WHERE s.name = :settingName AND s.value LIKE :settingValue AND s.scope.name= :scopeName AND s.scope.type= :scopeType "), @NamedQuery(name="SettingsEntity.countSettingsByNameAndValueAndScopeWithNullName", query="SELECT count(s.id) FROM SettingsEntity s WHERE s.name = :settingName AND s.value LIKE :settingValue AND s.scope.name IS NULL AND s.scope.type= :scopeType "), @NamedQuery(name="SettingsEntity.getSettingsByContextByTypeAndName", query="SELECT s FROM SettingsEntity s WHERE s.context.type= :contextType AND s.context.name= :contextName ")})
public class SettingsEntity {
    @Id
    @Column(name="SETTING_ID")
    @SequenceGenerator(name="SEQ_STG_SETTINGS_COMMON_ID", sequenceName="SEQ_STG_SETTINGS_COMMON_ID", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_STG_SETTINGS_COMMON_ID")
    private long id;
    @Column(name="NAME")
    private String name;
    @Column(name="VALUE")
    private String value;
    @ManyToOne
    @JoinColumn(name="CONTEXT_ID")
    private ContextEntity context;
    @ManyToOne
    @JoinColumn(name="SCOPE_ID")
    private ScopeEntity scope;

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public SettingsEntity setName(String name) {
        this.name = name;
        return this;
    }

    public String getValue() {
        return this.value == null ? "" : this.value;
    }

    public SettingsEntity setValue(String value) {
        this.value = value;
        return this;
    }

    public ContextEntity getContext() {
        return this.context;
    }

    public SettingsEntity setContext(ContextEntity context) {
        this.context = context;
        return this;
    }

    public ScopeEntity getScope() {
        return this.scope;
    }

    public SettingsEntity setScope(ScopeEntity scope) {
        this.scope = scope;
        return this;
    }
}

