/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.analytics.listener.social;

import java.util.Date;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.exoplatform.analytics.model.StatisticData;
import org.exoplatform.analytics.utils.AnalyticsUtils;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.metadata.tag.model.TagName;

@Asynchronous
public class AnalyticsTagsListener
extends Listener<String, Set<TagName>> {
    private ActivityManager activityManager;
    private IdentityManager identityManager;

    public AnalyticsTagsListener(ActivityManager activityManager, IdentityManager identityManager) {
        this.activityManager = activityManager;
        this.identityManager = identityManager;
    }

    public void onEvent(Event<String, Set<TagName>> event) throws Exception {
        Set tagNames = (Set)event.getData();
        String activityId = (String)event.getSource();
        this.addEventStatistic(tagNames, activityId);
    }

    private void addEventStatistic(Set<TagName> tagNames, String activityId) {
        int numberOfTags = tagNames.size();
        ExoSocialActivity activity = this.activityManager.getActivity(activityId);
        String objectType = activity.getType() == null ? (activity.isComment() ? "COMMENT" : "ACTIVITY") : activity.getType();
        Identity audienceIdentity = this.activityManager.getActivityStreamOwnerIdentity(activity.getId());
        String username = this.getActivityPoster(activity);
        StatisticData statisticData = new StatisticData();
        statisticData.setModule("portal");
        statisticData.setSubModule("ui");
        statisticData.setOperation("Add tag");
        statisticData.setTimestamp(new Date().getTime());
        statisticData.setUserId(Long.parseLong(activity.getUserId()));
        statisticData.addParameter("username", (Object)username);
        statisticData.addParameter("type", (Object)objectType);
        statisticData.addParameter("spaceId", (Object)audienceIdentity.getId());
        for (int i = 0; i < numberOfTags; ++i) {
            AnalyticsUtils.addStatisticData((StatisticData)statisticData);
        }
    }

    private String getActivityPoster(ExoSocialActivity activity) {
        Validate.notNull((Object)activity.getUserId(), (String)"activity.getUserId() must not be null!");
        return this.identityManager.getIdentity(activity.getUserId()).getRemoteId();
    }
}

