/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.statement.replace;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import liquibase.repackaged.net.sf.jsqlparser.expression.Expression;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.ItemsList;
import liquibase.repackaged.net.sf.jsqlparser.schema.Column;
import liquibase.repackaged.net.sf.jsqlparser.schema.Table;
import liquibase.repackaged.net.sf.jsqlparser.statement.Statement;
import liquibase.repackaged.net.sf.jsqlparser.statement.StatementVisitor;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.PlainSelect;

public class Replace
implements Statement {
    private Table table;
    private List<Column> columns;
    private ItemsList itemsList;
    private List<Expression> expressions;
    private boolean useValues = true;
    private boolean useIntoTables = false;

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public boolean isUseIntoTables() {
        return this.useIntoTables;
    }

    public void setUseIntoTables(boolean bl2) {
        this.useIntoTables = bl2;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public ItemsList getItemsList() {
        return this.itemsList;
    }

    public void setColumns(List<Column> list) {
        this.columns = list;
    }

    public void setItemsList(ItemsList itemsList) {
        this.itemsList = itemsList;
    }

    public List<Expression> getExpressions() {
        return this.expressions;
    }

    public void setExpressions(List<Expression> list) {
        this.expressions = list;
    }

    public boolean isUseValues() {
        return this.useValues;
    }

    public void setUseValues(boolean bl2) {
        this.useValues = bl2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("REPLACE ");
        if (this.isUseIntoTables()) {
            stringBuilder.append("INTO ");
        }
        stringBuilder.append(this.table);
        if (this.expressions != null && this.columns != null) {
            stringBuilder.append(" SET ");
            int n2 = this.columns.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                stringBuilder.append(this.columns.get(i2)).append("=").append(this.expressions.get(i2));
                stringBuilder.append(i2 < n2 - 1 ? ", " : "");
            }
        } else if (this.columns != null) {
            stringBuilder.append(" ").append(PlainSelect.getStringList(this.columns, true, true));
        }
        if (this.itemsList != null) {
            if (this.useValues) {
                stringBuilder.append(" VALUES");
            }
            stringBuilder.append(" ").append(this.itemsList);
        }
        return stringBuilder.toString();
    }

    public Replace withUseValues(boolean bl2) {
        this.setUseValues(bl2);
        return this;
    }

    public Replace withUseIntoTables(boolean bl2) {
        this.setUseIntoTables(bl2);
        return this;
    }

    public Replace withTable(Table table) {
        this.setTable(table);
        return this;
    }

    public Replace withColumns(List<Column> list) {
        this.setColumns(list);
        return this;
    }

    public Replace withItemsList(ItemsList itemsList) {
        this.setItemsList(itemsList);
        return this;
    }

    public Replace withExpressions(List<Expression> list) {
        this.setExpressions(list);
        return this;
    }

    public Replace addColumns(Column ... columnArray) {
        List list = Optional.ofNullable(this.getColumns()).orElseGet(ArrayList::new);
        Collections.addAll(list, columnArray);
        return this.withColumns(list);
    }

    public Replace addColumns(Collection<? extends Column> collection) {
        List list = Optional.ofNullable(this.getColumns()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withColumns(list);
    }

    public Replace addExpressions(Expression ... expressionArray) {
        List list = Optional.ofNullable(this.getExpressions()).orElseGet(ArrayList::new);
        Collections.addAll(list, expressionArray);
        return this.withExpressions(list);
    }

    public Replace addExpressions(Collection<? extends Expression> collection) {
        List list = Optional.ofNullable(this.getExpressions()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withExpressions(list);
    }

    public <E extends ItemsList> E getItemsList(Class<E> clazz) {
        return (E)((ItemsList)clazz.cast(this.getItemsList()));
    }
}

