/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.management.rest.content;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.gatein.management.api.operation.model.NamedDescription;
import org.gatein.management.api.operation.model.ReadResourceModel;
import org.gatein.management.rest.content.Child;
import org.gatein.management.rest.content.Link;
import org.gatein.management.rest.content.LinkBuilder;
import org.gatein.management.rest.content.Operation;

@XmlRootElement(name="resource")
@XmlType(propOrder={"description", "children", "operations"})
public class Resource {
    private String description;
    @XmlElement
    private ChildrenContainer children;
    @XmlElement
    private OperationsContainer operations;

    public Resource() {
    }

    public Resource(UriInfo uriInfo, ReadResourceModel readResource) {
        this.description = readResource.getDescription();
        UriBuilder uriBuilder = uriInfo.getRequestUriBuilder();
        if (readResource.getOperations() != null) {
            ArrayList<Operation> operations = new ArrayList<Operation>(readResource.getOperations().size());
            for (NamedDescription operationDescribed : readResource.getOperations()) {
                Operation operation = new Operation(operationDescribed.getName(), operationDescribed.getDescription(), null);
                operations.add(operation);
                Link link = operationDescribed.getName().equals("read-resource") ? new LinkBuilder(uriBuilder).rel("self").build() : (operationDescribed.getName().equals("export-resource") ? new LinkBuilder(uriBuilder).rel("content").extension("zip").type("application/zip").replaceQuery("").method("get").build() : (operationDescribed.getName().equals("import-resource") ? new LinkBuilder(uriBuilder).rel("operation").replaceQuery("").type("application/zip").method("put").build() : new LinkBuilder(uriBuilder).rel("operation").replaceQueryParam("op", operationDescribed.getName()).build()));
                operation.setOperationLink(link);
            }
            this.operations = new OperationsContainer(operations);
        }
        LinkedHashSet<Child> children = new LinkedHashSet<Child>(readResource.getChildDescriptions().size());
        for (NamedDescription childDescribed : readResource.getChildDescriptions()) {
            Link link = new LinkBuilder(uriBuilder).rel("child").path(childDescribed.getName()).build();
            children.add(new Child(childDescribed.getName(), childDescribed.getDescription(), link));
        }
        this.children = new ChildrenContainer(children);
    }

    @XmlElement
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @XmlTransient
    public Set<Child> getChildren() {
        return this.children.children;
    }

    public void setChildren(Set<Child> children) {
        this.children = new ChildrenContainer(children);
    }

    @XmlTransient
    public List<Operation> getOperations() {
        return this.operations.operations;
    }

    public void setOperations(List<Operation> operations) {
        this.operations = new OperationsContainer(operations);
    }

    private static class OperationsContainer {
        @XmlElement(name="operation")
        private List<Operation> operations;

        private OperationsContainer() {
        }

        private OperationsContainer(List<Operation> operations) {
            this.operations = operations;
        }
    }

    private static class ChildrenContainer {
        @XmlElement(name="child")
        private Set<Child> children;

        private ChildrenContainer() {
        }

        private ChildrenContainer(Set<Child> children) {
            this.children = children;
        }
    }
}

