/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.navigation;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.exoplatform.commons.utils.Safe;
import org.exoplatform.portal.mop.navigation.HierarchyException;
import org.exoplatform.portal.mop.navigation.NodeChangeListener;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.navigation.NodeData;
import org.exoplatform.portal.mop.navigation.NodeState;
import org.exoplatform.portal.mop.navigation.NodeStore;

class NodePersister<N>
extends NodeChangeListener.Base<NodeContext<N>> {
    final Map<String, String> toPersist;
    final Set<String> toUpdate;
    private final NodeStore persistence;

    NodePersister(NodeStore persistence) {
        this.persistence = persistence;
        this.toPersist = new HashMap<String, String>();
        this.toUpdate = new HashSet<String>();
    }

    @Override
    public void onCreate(NodeContext<N> target, NodeContext<N> parent, NodeContext<N> previous, String name) throws HierarchyException {
        NodeData[] result = this.persistence.createNode(Safe.parseLong(parent.data.id), previous != null ? Long.valueOf(Safe.parseLong(previous.data.id)) : null, name, target.state);
        parent.data = result[0];
        this.toPersist.put(target.handle, result[1].id);
        target.data = result[1];
        target.handle = target.data.id;
        target.name = null;
        target.state = null;
        this.toUpdate.add(parent.handle);
        this.toUpdate.add(target.handle);
    }

    @Override
    public void onDestroy(NodeContext<N> target, NodeContext<N> parent) {
        if (target.isExpanded()) {
            for (NodeContext child = (NodeContext)target.getFirst(); child != null; child = (NodeContext)child.getNext()) {
                this.onDestroy(child, target);
            }
        }
        parent.data = this.persistence.destroyNode(Safe.parseLong(target.data.id));
        this.toUpdate.add(parent.handle);
        this.toPersist.values().remove(target.data.id);
        this.toUpdate.remove(target.data.id);
    }

    @Override
    public void onUpdate(NodeContext<N> source, NodeState state) throws HierarchyException {
        source.data = this.persistence.updateNode(Safe.parseLong(source.data.id), state);
        source.state = null;
        this.toUpdate.add(source.handle);
    }

    @Override
    public void onMove(NodeContext<N> target, NodeContext<N> from, NodeContext<N> to, NodeContext<N> previous) throws HierarchyException {
        NodeData[] result = this.persistence.moveNode(Safe.parseLong(target.data.id), Safe.parseLong(from.data.id), Safe.parseLong(to.data.id), previous != null ? Long.valueOf(Safe.parseLong(previous.data.id)) : null);
        from.data = result[1];
        to.data = result[2];
        target.data = result[0];
        this.toUpdate.add(target.handle);
        this.toUpdate.add(from.handle);
        this.toUpdate.add(to.handle);
    }

    @Override
    public void onRename(NodeContext<N> target, NodeContext<N> parent, String name) throws HierarchyException {
        NodeData[] result = this.persistence.renameNode(Safe.parseLong(target.data.id), Safe.parseLong(parent.data.id), name);
        target.data = result[0];
        target.name = null;
        parent.data = result[1];
        this.toUpdate.add(parent.handle);
        this.toUpdate.add(target.handle);
    }
}

