/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.listeners;

import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.social.core.activity.ActivityLifeCycleEvent;
import org.exoplatform.social.core.activity.ActivityListenerPlugin;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.metadata.tag.TagService;
import org.exoplatform.social.metadata.tag.model.TagObject;

public class ActivityTagMetadataListener
extends ActivityListenerPlugin {
    private ActivityManager activityManager;
    private TagService tagService;

    public ActivityTagMetadataListener(ActivityManager activityManager, TagService tagService) {
        this.activityManager = activityManager;
        this.tagService = tagService;
    }

    public void saveActivity(ActivityLifeCycleEvent event) {
        this.updateActivityTags(event.getActivity());
    }

    public void saveComment(ActivityLifeCycleEvent event) {
        this.updateActivityTags(event.getActivity());
    }

    public void updateActivity(ActivityLifeCycleEvent event) {
        this.updateActivityTags(event.getActivity());
    }

    public void updateComment(ActivityLifeCycleEvent event) {
        this.updateActivityTags(event.getActivity());
    }

    private void updateActivityTags(ExoSocialActivity activity) {
        String objectType = "activity";
        long creatorId = this.getPosterId(activity);
        Identity audienceIdentity = this.activityManager.getActivityStreamOwnerIdentity(activity.getId());
        long audienceId = Long.parseLong(audienceIdentity.getId());
        String content = this.getActivityBody(activity);
        Set tagNames = this.tagService.detectTagNames(content);
        this.tagService.saveTags(new TagObject(objectType, activity.getId(), activity.getParentId()), tagNames, audienceId, creatorId);
    }

    private long getPosterId(ExoSocialActivity activity) {
        String userId = activity.getUserId();
        if (StringUtils.isBlank((CharSequence)userId)) {
            userId = activity.getPosterId();
        }
        return StringUtils.isBlank((CharSequence)userId) ? 0L : Long.parseLong(userId);
    }

    private String getActivityBody(ExoSocialActivity activity) {
        String body = MapUtils.getString((Map)activity.getTemplateParams(), (Object)"comment");
        if (StringUtils.isNotBlank((CharSequence)body)) {
            return body;
        }
        if (StringUtils.isNotBlank((CharSequence)activity.getTitle())) {
            return activity.getTitle();
        }
        return activity.getBody();
    }
}

