/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.processor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.social.core.BaseActivityProcessorPlugin;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.metadata.MetadataService;
import org.exoplatform.social.metadata.model.MetadataObject;

public class MetadataActivityProcessor
extends BaseActivityProcessorPlugin {
    public static final String ACTIVITY_METADATA_OBJECT_TYPE = "activity";
    private MetadataService metadataService;

    public MetadataActivityProcessor(MetadataService metadataService, InitParams params) {
        super(params);
        this.metadataService = metadataService;
    }

    public void processActivity(ExoSocialActivity activity) {
        if (activity != null) {
            List metadataItems = this.metadataService.getMetadataItemsByObject(new MetadataObject(ACTIVITY_METADATA_OBJECT_TYPE, activity.getId()));
            HashMap metadatas = new HashMap();
            metadataItems.forEach(metadataItem -> {
                String type = metadataItem.getMetadata().getType().getName();
                if (metadatas.get(type) == null) {
                    metadatas.put(type, new ArrayList());
                }
                ((List)metadatas.get(type)).add(metadataItem);
            });
            activity.setMetadatas(metadatas);
        }
    }
}

