/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.poll.utils;

import io.meeds.poll.model.Poll;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;

public class PollUtils {
    private static final Log LOG = ExoLogger.getLogger(PollUtils.class);
    public static final String POLL_ACTIVITY_TYPE = "poll";
    public static final String POLL_ID = "pollId";
    public static final String CREATE_POLL = "meeds.poll.createPoll";
    public static final String VOTE_POLL = "meeds.poll.votePoll";

    private PollUtils() {
    }

    public static final long getCurrentUserIdentityId(IdentityManager identityManager, String currentUser) {
        Identity identity = identityManager.getOrCreateIdentity("organization", currentUser);
        return identity == null ? 0L : Long.parseLong(identity.getId());
    }

    public static Date toDate(ZonedDateTime datetime) {
        if (datetime == null) {
            return null;
        }
        return Date.from(datetime.toInstant());
    }

    public static void broadcastEvent(String eventName, Object source, Object data) {
        try {
            ListenerService listenerService = (ListenerService)CommonsUtils.getService(ListenerService.class);
            listenerService.broadcast(eventName, source, data);
        }
        catch (Exception e) {
            LOG.warn((Object)("Error when broadcasting event '" + eventName + "' using source '" + source + "' and data " + data), (Throwable)e);
        }
    }

    public static long getPollDuration(Poll poll) {
        long duration = Math.abs(poll.getEndDate().getTime() - poll.getCreatedDate().getTime());
        return TimeUnit.DAYS.convert(duration, TimeUnit.MILLISECONDS);
    }
}

