/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing;

import org.apache.sis.metadata.iso.extent.Extents;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.extent.GeographicBoundingBox;

public final class ExtentSelector<T> {
    private final GeographicBoundingBox areaOfInterest;
    private T best;
    private double largestArea;

    public ExtentSelector(Extent extent) {
        this.areaOfInterest = Extents.getGeographicBoundingBox((Extent)extent);
    }

    public boolean evaluate(Extent extent, T t) {
        double d = Extents.area((GeographicBoundingBox)Extents.intersection((GeographicBoundingBox)Extents.getGeographicBoundingBox((Extent)extent), (GeographicBoundingBox)this.areaOfInterest));
        if (!(this.best == null || d > this.largestArea || !Double.isNaN(d) && Double.isNaN(this.largestArea))) {
            return false;
        }
        this.largestArea = d;
        this.best = t;
        return true;
    }

    public T best() {
        return this.best;
    }
}

