/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.listeners;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.search.index.IndexingService;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.storage.api.ActivityStorage;
import org.exoplatform.social.core.storage.cache.CachedActivityStorage;
import org.exoplatform.social.metadata.MetadataService;
import org.exoplatform.social.metadata.model.MetadataItem;
import org.exoplatform.social.metadata.model.MetadataKey;
import org.exoplatform.social.metadata.model.MetadataObject;

public abstract class AbstractMetadataItemListener<S, D>
extends Listener<S, D> {
    private static final Log LOG = ExoLogger.getLogger(AbstractMetadataItemListener.class);
    private CachedActivityStorage cachedActivityStorage;
    private MetadataService metadataService;
    private IndexingService indexingService;

    protected AbstractMetadataItemListener(MetadataService metadataService, ActivityStorage activityStorage, IndexingService indexingService) {
        this.indexingService = indexingService;
        this.metadataService = metadataService;
        if (activityStorage instanceof CachedActivityStorage) {
            this.cachedActivityStorage = (CachedActivityStorage)activityStorage;
        }
    }

    protected void handleMetadataModification(MetadataItem metadataItem) {
        if (metadataItem != null) {
            ExoSocialActivity activity;
            String objectType = metadataItem.getObjectType();
            String objectId = metadataItem.getObjectId();
            if (this.isActivityEvent(objectType) && this.cachedActivityStorage != null && (activity = this.cachedActivityStorage.getActivity(objectId)) != null && activity.hasSpecificMetadataObject()) {
                MetadataObject metadataObject = activity.getMetadataObject();
                this.moveMetadataItemToTargetObject(metadataItem, metadataObject);
            }
            this.handleMetadataModification(objectType, metadataItem.getObjectId());
        }
    }

    protected void handleMetadataModification(String objectType, String objectId) {
        if (this.isActivityEvent(objectType)) {
            this.clearCache(objectId);
            this.reindexActivity(objectId);
        }
    }

    protected boolean isActivityEvent(String objectType) {
        return StringUtils.equals((CharSequence)objectType, (CharSequence)"activity");
    }

    private void moveMetadataItemToTargetObject(MetadataItem metadataItem, MetadataObject targetMetadataObject) {
        try {
            this.metadataService.deleteMetadataItem(metadataItem.getId(), false);
        }
        catch (Exception e) {
            LOG.warn((Object)"Unable to delete newly created item", (Throwable)e);
        }
        MetadataKey metadataKey = metadataItem.getMetadata().key();
        Map properties = metadataItem.getProperties();
        try {
            long creatorId = metadataItem.getCreatorId();
            this.metadataService.createMetadataItem(targetMetadataObject, metadataKey, properties, creatorId);
        }
        catch (Exception e) {
            LOG.warn("Unable to move Metadata item from {} to {}", new Object[]{metadataItem.getObject(), targetMetadataObject, e});
        }
    }

    private void reindexActivity(String activityId) {
        this.indexingService.reindex("activity", activityId);
    }

    private void clearCache(String activityId) {
        if (this.cachedActivityStorage != null) {
            this.cachedActivityStorage.clearActivityCached(activityId);
        }
    }
}

