/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.api.security;

import java.io.Serializable;
import org.gatein.api.internal.Parameters;
import org.gatein.api.internal.StringSplitter;
import org.gatein.api.security.Group;
import org.gatein.api.security.User;

public class Membership
implements Serializable {
    public static final String ANY = "*";
    private final String membershipType;
    private final Group group;

    public static Membership any(String ... group) {
        return new Membership(ANY, new Group(group));
    }

    public Membership(String membershipType, Group group) {
        this.membershipType = Parameters.requireNonNull(membershipType, "membershipType");
        this.group = Parameters.requireNonNull(group, "group");
    }

    public Membership(User user) {
        this.membershipType = user.getId();
        this.group = null;
    }

    public String getMembershipType() {
        return this.membershipType;
    }

    public Group getGroup() {
        return this.group;
    }

    public String toString() {
        if (this.group == null) {
            return this.membershipType;
        }
        return this.membershipType + ":" + this.group.getId();
    }

    public static Membership fromString(String membership) {
        Parameters.requireNonNull(membership, "membership");
        String[] parts = StringSplitter.splitter(":").split(membership);
        if (parts.length == 1) {
            return new Membership(new User(parts[0]));
        }
        if (parts.length == 2) {
            return new Membership(parts[0], new Group(parts[1]));
        }
        throw new IllegalArgumentException("Invalid membership string " + membership);
    }
}

