/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.template.metamodel;

import java.util.Collections;
import javax.lang.model.element.Element;
import juzu.impl.common.Name;
import juzu.impl.common.Path;
import juzu.impl.metamodel.Key;
import juzu.impl.plugin.template.metamodel.AbstractContainerMetaModel;
import juzu.impl.plugin.template.metamodel.AbstractEmitter;
import juzu.impl.plugin.template.metamodel.TagEmitter;
import juzu.impl.plugin.template.metamodel.TagMetaModel;
import juzu.impl.plugin.template.metamodel.Template;
import juzu.impl.plugin.template.metamodel.TemplateMetaModel;
import juzu.impl.tags.SimpleTag;
import juzu.impl.template.spi.TemplateProvider;
import juzu.template.TagHandler;

class TagContainerMetaModel
extends AbstractContainerMetaModel {
    static final Name NAME = Name.parse("tags");
    public static final Key<TagContainerMetaModel> KEY = Key.of(TagContainerMetaModel.class);

    TagContainerMetaModel() {
        super(NAME);
    }

    TagHandler resolveApplicationTagHandler(String name) {
        TagMetaModel tag = this.getChild(Key.of(name, TagMetaModel.class));
        if (tag != null) {
            TemplateMetaModel template = tag.getChild(TemplateMetaModel.KEY);
            Path.Absolute path = template.getPath();
            return new SimpleTag(name, path.getName().toString());
        }
        return null;
    }

    public Template add(String name, Path.Absolute path) {
        TagMetaModel ref = this.addChild(Key.of(name, TagMetaModel.class), new TagMetaModel(name));
        return this.add(path, Collections.singletonList(ref));
    }

    @Override
    protected TemplateProvider<?> resolveTemplateProvider(String ext) {
        return this.plugin.providers.get(ext);
    }

    @Override
    protected Element[] getElements(TemplateMetaModel template) {
        return new Element[]{this.application.getProcessingContext().get(this.application.getHandle())};
    }

    @Override
    protected AbstractEmitter createEmitter() {
        return new TagEmitter(this);
    }
}

