/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.register;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.registration.PostRegistrationService;
import org.exoplatform.portal.webui.register.UIRegisterInputSet;
import org.exoplatform.portal.webui.register.UIRegisterOAuth;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.organization.UserStatus;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.application.JavascriptManager;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.InitParams;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.config.annotation.ParamConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.exception.MessageException;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormInputWithActions;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.validator.Validator;

@ComponentConfigs(value={@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIFormWithTitle.gtmpl", events={@EventConfig(listeners={SubscribeActionListener.class}), @EventConfig(listeners={ResetActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(name="CheckUsernameAvailability", listeners={CheckUsernameAvailability.class}, phase=Event.Phase.DECODE)}, initParams={@ParamConfig(name="skipCaptcha", value="false")}), @ComponentConfig(id="UIRegisterFormOAuth", lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIFormWithTitleAndCloseIcon.gtmpl", events={@EventConfig(listeners={UIRegisterOAuth.SubscribeOAuthActionListener.class}), @EventConfig(listeners={UIRegisterOAuth.ResetActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIRegisterOAuth.CancelActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(name="CheckUsernameAvailability", listeners={CheckUsernameAvailability.class}, phase=Event.Phase.DECODE)}, initParams={@ParamConfig(name="skipCaptcha", value="true")})})
public class UIRegisterForm
extends UIForm {
    private static final String[] ACTIONS = new String[]{"Subscribe", "Reset", "Cancel"};
    static final String ATTR_USER = "UIRegisterForm$User";
    static final String SKIP_CAPTCHA_PARAM_NAME = "skipCaptcha";

    public UIRegisterForm(InitParams params) throws Exception {
        String skipCaptchaParam = params.getParam(SKIP_CAPTCHA_PARAM_NAME).getValue();
        boolean skipCaptcha = Boolean.parseBoolean(skipCaptchaParam);
        UIRegisterInputSet registerInput = new UIRegisterInputSet("RegisterInputSet", skipCaptcha);
        ArrayList<UIFormInputWithActions.ActionData> fieldActions = new ArrayList<UIFormInputWithActions.ActionData>();
        UIFormInputWithActions.ActionData checkAvailable = new UIFormInputWithActions.ActionData();
        checkAvailable.setActionListener("CheckUsernameAvailability");
        checkAvailable.setActionName("CheckUsernameAvailability");
        checkAvailable.setActionType(0);
        checkAvailable.setCssIconClass("SearchIcon");
        fieldActions.add(checkAvailable);
        registerInput.setActionField(UIRegisterInputSet.USER_NAME, fieldActions);
        this.addUIFormInput((UIFormInputSet)registerInput);
        this.setActions(ACTIONS);
    }

    private void resetInput() {
        ((UIRegisterInputSet)this.getChild(UIRegisterInputSet.class)).reset();
    }

    public void processAction(WebuiRequestContext context) throws Exception {
        super.processAction(context);
        if (context.getProcessRender()) {
            if (context instanceof PortletRequestContext) {
                PortletRequestContext prc = (PortletRequestContext)context;
                prc.getRequest().getPortletSession().removeAttribute("simpleCaptcha");
            }
            context.addUIComponentToUpdateByAjax(this.getChild(UIRegisterInputSet.class));
        }
    }

    public static class CancelActionListener
    extends EventListener<UIRegisterForm> {
        public void execute(Event<UIRegisterForm> event) throws Exception {
            PortalRequestContext prContext = Util.getPortalRequestContext();
            JavascriptManager jsManager = prContext.getJavascriptManager();
            jsManager.addJavascript((CharSequence)"history.go(-1);");
        }
    }

    public static class ResetActionListener
    extends EventListener<UIRegisterForm> {
        public void execute(Event<UIRegisterForm> event) throws Exception {
            UIRegisterForm registerForm = (UIRegisterForm)((Object)event.getSource());
            registerForm.resetInput();
        }
    }

    public static class CheckUsernameAvailability
    extends EventListener<UIRegisterForm> {
        private final Log log = ExoLogger.getLogger(CheckUsernameAvailability.class);
        static final String LISTENER_NAME = "CheckUsernameAvailability";

        public void execute(Event<UIRegisterForm> event) throws Exception {
            UIRegisterForm registerForm = (UIRegisterForm)((Object)event.getSource());
            OrganizationService orgService = (OrganizationService)registerForm.getApplicationComponent(OrganizationService.class);
            UIRegisterInputSet registerInput = (UIRegisterInputSet)registerForm.getChild(UIRegisterInputSet.class);
            UIFormStringInput userNameInput = registerInput.getUIStringInput(UIRegisterInputSet.USER_NAME);
            List validators = userNameInput.getValidators();
            for (Validator validator : validators) {
                try {
                    validator.validate((UIFormInput)userNameInput);
                }
                catch (MessageException e) {
                    event.getRequestContext().getUIApplication().addMessage(e.getDetailMessage());
                    return;
                }
            }
            String typedUsername = (String)userNameInput.getValue();
            WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
            UIApplication uiApp = context.getUIApplication();
            if (this.usernameIsUsed(typedUsername, orgService)) {
                uiApp.addMessage(new ApplicationMessage("UIAccountInputSet.msg.user-exist", (Object[])new String[]{typedUsername}, 1));
            } else {
                uiApp.addMessage(new ApplicationMessage("UIAccountInputSet.msg.user-not-exist", (Object[])new String[]{typedUsername}, 2));
            }
        }

        private boolean usernameIsUsed(String username, OrganizationService orgService) {
            UserHandler userHandler = orgService.getUserHandler();
            try {
                if (userHandler.findUserByName(username, UserStatus.ANY) != null) {
                    return true;
                }
            }
            catch (Exception ex) {
                this.log.error((Object)ex.getMessage(), (Throwable)ex);
            }
            return false;
        }
    }

    public static class SubscribeActionListener
    extends EventListener<UIRegisterForm> {
        public void execute(Event<UIRegisterForm> event) throws Exception {
            UIRegisterForm registerForm = (UIRegisterForm)((Object)event.getSource());
            OrganizationService orgService = (OrganizationService)registerForm.getApplicationComponent(OrganizationService.class);
            UserHandler userHandler = orgService.getUserHandler();
            WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
            UIRegisterInputSet registerInput = (UIRegisterInputSet)registerForm.getChild(UIRegisterInputSet.class);
            if (registerInput.save(userHandler, context)) {
                UIApplication uiApp = context.getUIApplication();
                uiApp.addMessage(new ApplicationMessage("UIRegisterForm.registerWithSuccess.message", null));
                PostRegistrationService postRegistrationService = (PostRegistrationService)uiApp.getApplicationComponent(PostRegistrationService.class);
                User user = (User)context.getAttribute(UIRegisterForm.ATTR_USER);
                postRegistrationService.sendMailAfterSuccessfulRegistration(user);
            }
            if (context instanceof PortletRequestContext) {
                PortletRequestContext prc = (PortletRequestContext)context;
                prc.getRequest().getPortletSession().removeAttribute("simpleCaptcha");
            }
        }
    }
}

