/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext;

import com.datical.liquibase.ext.SqlPlusFileCreator$FileTypeEnum;
import java.io.File;
import java.security.SecureRandom;
import java.util.Random;
import liquibase.Scope;
import liquibase.changelog.ChangeSet;
import liquibase.exception.CommandExecutionException;
import liquibase.util.FilenameUtil;
import liquibase.util.StringUtil;

public class SqlPlusFileCreator {
    private final ChangeSet changeSet;
    private final String filenameOverride;
    private final String pathOverride;
    private final boolean overwriteFile;
    private final boolean keepFile;

    public SqlPlusFileCreator(ChangeSet changeSet, String string, String string2, boolean bl2, boolean bl3) {
        this.changeSet = changeSet;
        this.filenameOverride = string;
        this.pathOverride = string2;
        this.overwriteFile = bl2;
        this.keepFile = bl3;
    }

    public File generateTemporaryFile(SqlPlusFileCreator$FileTypeEnum object) {
        Object object2 = Scope.getCurrentScope().getLog(this.getClass());
        String string = "liquibase-" + object.toString() + "-" + this.changeSet.getId() + "-" + this.changeSet.getAuthor() + "-";
        if (StringUtil.isNotEmpty(this.filenameOverride)) {
            string = this.filenameOverride;
        }
        string = FilenameUtil.sanitizeFileName(string);
        object2.info("Creating temporary " + (Object)object + " file for '" + string + "'");
        if (StringUtil.isEmpty(this.pathOverride)) {
            object2 = System.getProperty("java.io.tmpdir");
            if (StringUtil.isEmpty(this.filenameOverride)) {
                return this.deleteFileOnExitIfNeeded(File.createTempFile(string, object.extension), this.keepFile);
            }
            File file = new File((String)object2, this.filenameOverride + object.extension);
            SqlPlusFileCreator sqlPlusFileCreator = this;
            return sqlPlusFileCreator.deleteFileOnExitIfNeeded(sqlPlusFileCreator.safelyCreateNewFile(file, this.overwriteFile), this.keepFile);
        }
        object2 = new File(this.pathOverride);
        boolean bl2 = ((File)object2).mkdirs();
        if (!this.keepFile && bl2) {
            ((File)object2).deleteOnExit();
        }
        if (StringUtil.isEmpty(this.filenameOverride)) {
            object2 = new SecureRandom();
            object = new File(this.pathOverride, string + ((Random)object2).nextLong() + object.extension);
            SqlPlusFileCreator sqlPlusFileCreator = this;
            return sqlPlusFileCreator.deleteFileOnExitIfNeeded(sqlPlusFileCreator.safelyCreateNewFile((File)object, this.overwriteFile), this.keepFile);
        }
        object2 = new File(this.pathOverride, this.filenameOverride + object.extension);
        SqlPlusFileCreator sqlPlusFileCreator = this;
        return sqlPlusFileCreator.deleteFileOnExitIfNeeded(sqlPlusFileCreator.safelyCreateNewFile((File)object2, this.overwriteFile), this.keepFile);
    }

    private File safelyCreateNewFile(File file, Boolean bl2) {
        if (!file.exists()) {
            return this.createNewFile(file);
        }
        if (file.exists() && bl2 == null) {
            throw new CommandExecutionException("ERROR: Specified SQL Plus spool file " + file.getAbsolutePath() + " already exists, and liquibase.sqlplus.keep.temp.overwrite=NULL. It is unclear whether the file should be overwritten. To run this job, either adjust file name or path, or set liquibase.sqlplus.keep.temp.overwrite=TRUE.");
        }
        if (file.exists() && !bl2.booleanValue()) {
            throw new CommandExecutionException("ERROR: Specified SQL Plus spool file " + file.getAbsolutePath() + " already exists, and liquibase.sqlplus.keep.temp.overwrite=FALSE. To run this job, either adjust file name or path, or set liquibase.sqlplus.keep.temp.overwrite=TRUE.");
        }
        Scope.getCurrentScope().getUI().sendMessage("WARNING: Specified SQL Plus spool file " + file.getAbsolutePath() + " already existed, and was overwritten.");
        if (file.delete()) {
            return this.createNewFile(file);
        }
        throw new CommandExecutionException("Failed to create file " + file.getAbsolutePath() + " after deleting existing file.");
    }

    private File createNewFile(File file) {
        if (file.createNewFile()) {
            return file;
        }
        throw new CommandExecutionException("Failed to create file " + file.getAbsolutePath() + ".");
    }

    private File deleteFileOnExitIfNeeded(File file, Boolean bl2) {
        if (!bl2.booleanValue()) {
            file.deleteOnExit();
        }
        return file;
    }
}

