/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.security.oauth.web;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.User;
import org.exoplatform.web.security.AuthenticationRegistry;
import org.gatein.security.oauth.spi.OAuthPrincipal;
import org.gatein.security.oauth.spi.OAuthPrincipalProcessor;
import org.gatein.security.oauth.spi.SocialNetworkService;
import org.gatein.security.oauth.utils.OAuthUtils;
import org.gatein.sso.agent.filter.api.AbstractSSOInterceptor;

public class OAuthAuthenticationFilter
extends AbstractSSOInterceptor {
    private static Log log = ExoLogger.getLogger(OAuthAuthenticationFilter.class);
    private String loginUrl;
    private String registrationUrl;
    private boolean attachUsernamePasswordToLoginURL;
    private SocialNetworkService socialNetworkService;
    private AuthenticationRegistry authenticationRegistry;

    protected void initImpl() {
        String attachUsernamePasswordToLoginURLConfig;
        this.loginUrl = this.getInitParameter("loginUrl");
        this.registrationUrl = this.getInitParameter("registrationUrl");
        if (this.registrationUrl == null) {
            this.registrationUrl = "/" + this.getExoContainer().getContext().getName() + "/";
        }
        this.attachUsernamePasswordToLoginURL = (attachUsernamePasswordToLoginURLConfig = this.getInitParameter("attachUsernamePasswordToLoginURL")) == null ? true : Boolean.parseBoolean(attachUsernamePasswordToLoginURLConfig);
        log.debug((Object)("OAuthAuthenticationFilter configuration: loginURL=" + this.loginUrl + ", registrationUrl=" + this.registrationUrl + ", attachUsernamePasswordToLoginURL=" + this.attachUsernamePasswordToLoginURL));
        this.socialNetworkService = (SocialNetworkService)this.getExoContainer().getComponentInstanceOfType(SocialNetworkService.class);
        this.authenticationRegistry = (AuthenticationRegistry)this.getExoContainer().getComponentInstanceOfType(AuthenticationRegistry.class);
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if (httpRequest.getRemoteUser() != null) {
            chain.doFilter(request, response);
            return;
        }
        User oauthAuthenticatedUser = (User)this.authenticationRegistry.getAttributeOfClient(httpRequest, "_authenticatedPortalUser");
        if (oauthAuthenticatedUser != null) {
            chain.doFilter(request, response);
            return;
        }
        OAuthPrincipal principal = (OAuthPrincipal)this.authenticationRegistry.getAttributeOfClient(httpRequest, "_authenticatedOAuthPrincipal");
        if (principal != null) {
            this.processPrincipal(httpRequest, httpResponse, principal);
        } else {
            chain.doFilter(request, response);
        }
    }

    protected void processPrincipal(HttpServletRequest httpRequest, HttpServletResponse httpResponse, OAuthPrincipal principal) throws IOException {
        User portalUser = this.socialNetworkService.findUserByOAuthProviderUsername(principal.getOauthProviderType(), principal.getUserName());
        if (portalUser == null) {
            this.handleRedirectToRegistrationForm(httpRequest, httpResponse, principal);
        } else {
            this.handleRedirectToPortalLogin(httpRequest, httpResponse, portalUser, principal);
            this.cleanAuthenticationContext(httpRequest);
        }
    }

    protected void handleRedirectToRegistrationForm(HttpServletRequest httpRequest, HttpServletResponse httpResponse, OAuthPrincipal principal) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Not found portalUser with username " + principal.getUserName() + ". Redirecting to registration form"));
        }
        OAuthPrincipalProcessor principalProcessor = principal.getOauthProviderType().getOauthPrincipalProcessor();
        User gateInUser = principalProcessor.convertToGateInUser(principal);
        this.authenticationRegistry.setAttributeOfClient(httpRequest, "_authenticatedPortalUser", (Object)gateInUser);
        String registrationRedirectUrl = this.getRegistrationRedirectURL(httpRequest);
        registrationRedirectUrl = httpResponse.encodeRedirectURL(registrationRedirectUrl);
        httpResponse.sendRedirect(registrationRedirectUrl);
    }

    protected String getRegistrationRedirectURL(HttpServletRequest req) {
        String registrationURL = (String)req.getSession().getAttribute("_urlToRedirectAfterLinkSocialAccount");
        if (registrationURL == null) {
            registrationURL = this.registrationUrl;
        }
        return registrationURL;
    }

    protected void handleRedirectToPortalLogin(HttpServletRequest httpRequest, HttpServletResponse httpResponse, User portalUser, OAuthPrincipal principal) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Found portalUser " + portalUser + " corresponding to oauthPrincipal"));
        }
        this.authenticationRegistry.setAttributeOfClient(httpRequest, "_authenticatedPortalUserForJaas", (Object)portalUser);
        if (portalUser.isEnabled()) {
            this.socialNetworkService.updateOAuthAccessToken(principal.getOauthProviderType(), portalUser.getUserName(), principal.getAccessToken());
        }
        String loginRedirectURL = httpResponse.encodeRedirectURL(this.getLoginRedirectUrl(httpRequest, portalUser.getUserName()));
        httpResponse.sendRedirect(loginRedirectURL);
    }

    protected String getLoginRedirectUrl(HttpServletRequest req, String username) {
        StringBuilder url = new StringBuilder(this.loginUrl);
        if (this.attachUsernamePasswordToLoginURL) {
            String fakePassword = req.getSession().getId() + "_" + String.valueOf(System.currentTimeMillis());
            url.append("?username=").append(username).append("&password=").append(fakePassword);
            String initialURI = OAuthUtils.getURLToRedirectAfterLinkAccount((HttpServletRequest)req, (HttpSession)req.getSession());
            initialURI = OAuthUtils.encodeParam((String)initialURI);
            url.append("&").append("initialURI").append("=").append(initialURI);
        }
        return url.toString();
    }

    protected void cleanAuthenticationContext(HttpServletRequest httpRequest) {
        this.authenticationRegistry.removeAttributeOfClient(httpRequest, "_authenticatedOAuthPrincipal");
        this.authenticationRegistry.removeAttributeOfClient(httpRequest, "_authenticatedPortalUser");
    }
}

