/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.rest;

import java.text.ParseException;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.TemporalAdjusters;
import java.util.Date;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.exoplatform.addons.gamification.IdentityType;
import org.exoplatform.addons.gamification.service.configuration.DomainService;
import org.exoplatform.addons.gamification.service.configuration.RuleService;
import org.exoplatform.addons.gamification.service.effective.GamificationService;
import org.exoplatform.addons.gamification.service.effective.LeaderboardFilter;
import org.exoplatform.addons.gamification.service.effective.StandardLeaderboard;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;

@Path(value="/gamification/api/v1")
@RolesAllowed(value={"users"})
public class GamificationRestEndpoint
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(GamificationRestEndpoint.class);
    private final CacheControl cacheControl = new CacheControl();
    private GamificationService gamificationService;
    private IdentityManager identityManager;
    private DomainService domainService;
    private RuleService ruleService;

    public GamificationRestEndpoint(GamificationService gamificationService, IdentityManager identityManager, DomainService domainService, RuleService ruleService) {
        this.cacheControl.setNoCache(true);
        this.cacheControl.setNoStore(true);
        this.gamificationService = gamificationService;
        this.identityManager = identityManager;
        this.domainService = domainService;
        this.ruleService = ruleService;
    }

    @Path(value="points")
    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    public Response getAllPointsByUserId(@QueryParam(value="userId") String userId, @QueryParam(value="period") String period) {
        if (StringUtils.isBlank((String)userId)) {
            LOG.warn((Object)"Enable to serve request due to bad request parameter \u00abuserId\u00bb");
            return Response.ok((Object)new GamificationPoints().userId(userId).points(0L).code("2").message("userId parameter must be specified")).build();
        }
        try {
            Identity identity = this.identityManager.getOrCreateIdentity("organization", userId);
            Long earnedXP = 0L;
            if (period == null || StringUtils.equalsIgnoreCase((String)LeaderboardFilter.Period.ALL.name(), (String)period)) {
                earnedXP = this.gamificationService.findReputationByEarnerId(identity.getId());
            } else {
                period = period.toUpperCase();
                Date fromDate = null;
                switch (period) {
                    case "WEEK": {
                        fromDate = Date.from(LocalDate.now().with(DayOfWeek.MONDAY).atStartOfDay(ZoneId.systemDefault()).toInstant());
                        break;
                    }
                    case "MONTH": {
                        fromDate = Date.from(LocalDate.now().with(TemporalAdjusters.firstDayOfMonth()).atStartOfDay(ZoneId.systemDefault()).toInstant());
                    }
                }
                Date toDate = Date.from(LocalDate.now().atStartOfDay(ZoneId.systemDefault()).toInstant());
                earnedXP = this.gamificationService.findUserReputationScoreBetweenDate(identity.getId(), fromDate, toDate);
            }
            return Response.ok((Object)new GamificationPoints().userId(userId).points(earnedXP).code("0").message("Gamification API is called successfully")).build();
        }
        catch (Exception e) {
            LOG.error("Error while fetching earned points for user {} - Gamification public API", new Object[]{userId, e});
            return Response.ok((Object)new GamificationPoints().userId(userId).points(0L).code("2").message("Error while fetching all earned points")).build();
        }
    }

    @Path(value="points/date")
    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    public Response getAllPointsByUserIdByDate(@QueryParam(value="userId") String userId, @QueryParam(value="startDate") String startDateEntry, @QueryParam(value="endDate") String endDateEntry) {
        if (StringUtils.isBlank((String)userId)) {
            LOG.warn((Object)"Enable to serve request due to bad request parameter \u00abuserId\u00bb");
            return Response.ok((Object)new GamificationPoints().userId(userId).points(0L).code("2").message("userId parameter must be specified")).build();
        }
        try {
            Date startDate = DateUtils.parseDate((String)startDateEntry, (String[])new String[]{"yyyy-MM-dd HH:mm:ss", "dd-MM-yyyy"});
            Date endDate = DateUtils.parseDate((String)endDateEntry, (String[])new String[]{"yyyy-MM-dd HH:mm:ss", "dd-MM-yyyy"});
            if (startDate.after(endDate)) {
                return Response.ok((Object)new GamificationPoints().userId(userId).points(0L).code("1").message("date parameters are not correctly set")).build();
            }
            Identity identity = this.identityManager.getOrCreateIdentity("organization", userId);
            Long earnedXP = this.gamificationService.findUserReputationScoreBetweenDate(identity.getId(), startDate, endDate);
            return Response.ok((Object)new GamificationPoints().userId(userId).points(earnedXP).code("0").message("Gamification API is called successfully")).build();
        }
        catch (ParseException pe) {
            LOG.error("Error to parse parameters {} or {} ", new Object[]{startDateEntry, endDateEntry});
            return Response.serverError().cacheControl(this.cacheControl).entity((Object)"Error to parse startDate or endDate to Date object please use the following pattern : dd-MM-yyyy").build();
        }
        catch (Exception e) {
            LOG.error("Error while fetching earned points for user {} in the specified period - Gamification public API", new Object[]{userId, e});
            return Response.ok((Object)new GamificationPoints().userId(userId).points(0L).code("2").message("Error while fetching earned points by period")).build();
        }
    }

    @Path(value="leaderboard/date")
    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    public Response getLeaderboardByDate(@Context UriInfo uriInfo, @QueryParam(value="earnerType") String earnerType, @QueryParam(value="startDate") String startDateEntry, @QueryParam(value="endDate") String endDateEntry) {
        try {
            Date startDate = DateUtils.parseDate((String)startDateEntry, (String[])new String[]{"yyyy-MM-dd HH:mm:ss", "dd-MM-yyyy"});
            Date endDate = DateUtils.parseDate((String)endDateEntry, (String[])new String[]{"yyyy-MM-dd HH:mm:ss", "dd-MM-yyyy"});
            if (startDate.after(endDate)) {
                return Response.ok((Object)new GamificationPoints().code("2").message("Dates parameters are not set correctly")).build();
            }
            List<StandardLeaderboard> leaderboard = this.gamificationService.findAllLeaderboardBetweenDate(IdentityType.getType(earnerType), startDate, endDate);
            return Response.ok((Object)new GamificationPoints().code("0").leaderboard(leaderboard).message("Gamification API is called successfully")).build();
        }
        catch (ParseException pe) {
            LOG.error("Error to parse parameters {} or {} ", new Object[]{startDateEntry, endDateEntry});
            return Response.serverError().cacheControl(this.cacheControl).entity((Object)"Error to parse startDate or endDate to Date object please use the following pattern : dd-MM-yyyy").build();
        }
        catch (Exception e) {
            LOG.error("Error while building gloabl leaderboard between dates {} and {} - Gamification public API", new Object[]{startDateEntry, endDateEntry, e});
            return Response.ok((Object)new GamificationPoints().code("2").message("Error while fetching earned points by period")).build();
        }
    }

    @Path(value="domains")
    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    public Response getDomains() {
        try {
            return Response.ok(this.domainService.getEnabledDomains()).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error while fetching Enabled Domains", (Throwable)e);
            return Response.serverError().entity((Object)"Error while fetching enabled domains").build();
        }
    }

    @Path(value="events")
    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    public Response getAllEvents() {
        try {
            return Response.ok(this.ruleService.getAllEvents()).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error while fetching All Events", (Throwable)e);
            return Response.serverError().entity((Object)"Error while fetching all events").build();
        }
    }

    public static class GamificationPoints {
        private String userId;
        private Long points;
        private String code;
        private String message;
        private List<StandardLeaderboard> leaderboard;

        public GamificationPoints userId(String userId) {
            this.userId = userId;
            return this;
        }

        public GamificationPoints points(Long points) {
            this.points = points;
            return this;
        }

        public GamificationPoints code(String code) {
            this.code = code;
            return this;
        }

        public GamificationPoints message(String message) {
            this.message = message;
            return this;
        }

        public GamificationPoints leaderboard(List<StandardLeaderboard> leaderboard) {
            this.leaderboard = leaderboard;
            return this;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getUserId() {
            return this.userId;
        }

        public void setUserId(String userId) {
            this.userId = userId;
        }

        public Long getPoints() {
            return this.points;
        }

        public void setPoints(Long points) {
            this.points = points;
        }

        public List<StandardLeaderboard> getLeaderboard() {
            return this.leaderboard;
        }

        public void setLeaderboard(List<StandardLeaderboard> leaderboard) {
            this.leaderboard = leaderboard;
        }
    }
}

