/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.document.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValuesParam;
import org.exoplatform.services.document.DocumentReadException;
import org.exoplatform.services.document.impl.BaseDocumentReader;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class TextPlainDocumentReader
extends BaseDocumentReader {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.core.component.document.TextPlainDocumentReader");
    public static final String DEFAULT_ENCODING = "defaultEncoding";
    private String defaultEncoding;

    public TextPlainDocumentReader(InitParams params) {
        ValuesParam encoding = (ValuesParam)params.getParameter(DEFAULT_ENCODING);
        this.defaultEncoding = encoding != null && encoding.getValue() != null && !encoding.getValue().equalsIgnoreCase("") ? encoding.getValue() : null;
    }

    @Override
    public String[] getMimeTypes() {
        return new String[]{"text/plain", "script/groovy", "application/x-groovy", "application/x-javascript", "application/javascript", "text/javascript", "application/x-jaxrs+groovy", "text/css"};
    }

    @Override
    public String getContentAsText(InputStream is) throws IOException, DocumentReadException {
        if (this.defaultEncoding != null) {
            return this.getContentAsText(is, this.defaultEncoding);
        }
        return this.getContentAsText(is, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getContentAsText(InputStream is, String encoding) throws IOException, DocumentReadException {
        if (is == null) {
            throw new IllegalArgumentException("InputStream is null.");
        }
        try {
            int len;
            byte[] buffer = new byte[2048];
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            while ((len = is.read(buffer)) > 0) {
                bos.write(buffer, 0, len);
            }
            bos.close();
            if (bos.size() == 0) {
                String string = "";
                return string;
            }
            if (encoding != null) {
                String string = new String(bos.toByteArray(), encoding);
                return string;
            }
            String string = new String(bos.toByteArray());
            return string;
        }
        finally {
            block18: {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        if (!LOG.isTraceEnabled()) break block18;
                        LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                    }
                }
            }
        }
    }

    @Override
    public Properties getProperties(InputStream is) throws IOException, DocumentReadException {
        block2: {
            try {
                is.close();
            }
            catch (IOException e) {
                if (!LOG.isTraceEnabled()) break block2;
                LOG.trace((Object)("An exception occurred: " + e.getMessage()));
            }
        }
        return new Properties();
    }
}

