/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib;

import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import net.jcip.annotations.Immutable;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.time.CalendarDateUnit;
import ucar.nc2.time.CalendarPeriod;

@Immutable
public class TimeCoord {
    private CalendarDate runDate;
    private CalendarPeriod timeUnit;
    protected List<Integer> coords;
    protected List<Tinv> intervals;
    private String units;
    private int index;
    private final int code;

    public static int getOffset(CalendarDate refDate, CalendarDate cd, CalendarPeriod timeUnit) {
        long msecs = cd.getDifferenceInMsecs(refDate);
        return (int)Math.round((double)msecs / timeUnit.getValueInMillisecs());
    }

    public TimeCoord(int code, String udunitString, List coords) {
        Object atom;
        this.code = code;
        this.units = udunitString;
        CalendarDateUnit cdu = CalendarDateUnit.of(null, (String)udunitString);
        this.runDate = cdu.getBaseCalendarDate();
        this.timeUnit = cdu.getTimeUnit();
        Object v0 = atom = coords.size() > 0 ? coords.get(0) : null;
        if (atom instanceof Tinv) {
            this.coords = null;
            this.intervals = coords;
        } else {
            this.coords = coords;
            this.intervals = null;
        }
    }

    public TimeCoord(int code, CalendarDate runDate, CalendarPeriod timeUnit, List coords) {
        Object atom;
        this.code = code;
        this.runDate = runDate;
        this.timeUnit = timeUnit;
        Object v0 = atom = coords == null || coords.size() == 0 ? null : coords.get(0);
        if (atom instanceof CalendarDate) {
            ArrayList<Integer> offsets = new ArrayList<Integer>(coords.size());
            double duration = timeUnit.getValueInMillisecs();
            for (Object coord : coords) {
                CalendarDate cd = (CalendarDate)coord;
                long msecs = cd.getDifferenceInMsecs(runDate);
                int val = (int)Math.round((double)msecs / duration);
                offsets.add(val);
            }
            this.coords = offsets;
            this.intervals = null;
        } else if (atom instanceof TinvDate) {
            CalendarDate startDate = null;
            for (Object coord : coords) {
                TinvDate tinvd = (TinvDate)coord;
                if (startDate == null) {
                    startDate = tinvd.start;
                    continue;
                }
                if (!startDate.isAfter(tinvd.start)) continue;
                startDate = tinvd.start;
            }
            int count = 0;
            ArrayList<Tinv> offsets = new ArrayList<Tinv>(coords.size());
            for (Object coord : coords) {
                TinvDate tinvd = (TinvDate)coord;
                tinvd.index = count++;
                offsets.add(tinvd.convertReferenceDate(startDate, timeUnit));
            }
            this.runDate = startDate;
            this.coords = null;
            this.intervals = offsets;
        } else if (atom instanceof Tinv) {
            this.intervals = coords;
            this.coords = null;
        } else {
            this.coords = coords;
            this.intervals = null;
        }
    }

    public TimeCoord setIndex(int index) {
        this.index = index;
        return this;
    }

    public CalendarDate getRunDate() {
        return this.runDate;
    }

    public CalendarDateRange getCalendarRange() {
        CalendarDate rd = this.getRunDate();
        if (this.coords != null) {
            CalendarDate start = rd.add(this.timeUnit.multiply(this.coords.get(0).intValue()));
            CalendarDate end = rd.add(this.timeUnit.multiply(this.coords.get(this.coords.size() - 1).intValue()));
            return CalendarDateRange.of((CalendarDate)start, (CalendarDate)end);
        }
        CalendarDate start = rd.add(this.timeUnit.multiply(this.intervals.get(0).b1));
        CalendarDate end = rd.add(this.timeUnit.multiply(this.intervals.get(this.intervals.size() - 1).b2));
        return CalendarDateRange.of((CalendarDate)start, (CalendarDate)end);
    }

    public boolean isInterval() {
        return this.intervals != null;
    }

    public List<Integer> getCoords() {
        return this.coords;
    }

    public List<Tinv> getIntervals() {
        return this.intervals;
    }

    public String getUnits() {
        if (this.units != null) {
            return this.units;
        }
        CalendarPeriod.Field cf = this.timeUnit.getField();
        if (cf == CalendarPeriod.Field.Month || cf == CalendarPeriod.Field.Year) {
            return "calendar " + cf.toString() + " since " + this.runDate;
        }
        return this.timeUnit.getField().toString() + " since " + this.runDate;
    }

    public double getTimeUnitScale() {
        return this.timeUnit.getValue();
    }

    public CalendarPeriod getTimeUnit() {
        return this.timeUnit;
    }

    public int getCode() {
        return this.code;
    }

    public String getName() {
        return this.index == 0 ? "time" : "time" + this.index;
    }

    public String getType() {
        return this.isInterval() ? "interval" : "integers";
    }

    public int getSize() {
        return this.isInterval() ? this.intervals.size() : this.coords.size();
    }

    public String getTimeIntervalName() {
        if (!this.isInterval()) {
            return null;
        }
        int firstValue = -1;
        boolean same = true;
        for (Tinv tinv : this.intervals) {
            int value = tinv.b2 - tinv.b1;
            if (firstValue < 0) {
                firstValue = value;
                continue;
            }
            if (value == firstValue) continue;
            same = false;
        }
        if (same) {
            firstValue = (int)((double)firstValue * this.getTimeUnitScale());
            return firstValue + "_" + this.timeUnit.getField().toString();
        }
        return "Mixed_intervals";
    }

    public String toString() {
        Formatter out = new Formatter();
        out.format(" type=%-10s timeUnit=%s runDate= %-26s%n    ", this.getType(), this.timeUnit, this.runDate);
        if (this.isInterval()) {
            for (Tinv tinv : this.intervals) {
                out.format("%s, ", tinv);
            }
        } else {
            for (Integer val : this.coords) {
                out.format("%d, ", val);
            }
            out.format(" units (%s) since %s", this.timeUnit, this.runDate);
        }
        return out.toString();
    }

    public boolean equalsData(TimeCoord tother) {
        if (!this.runDate.equals((Object)tother.runDate)) {
            return false;
        }
        if (!this.timeUnit.equals((Object)tother.timeUnit)) {
            return false;
        }
        if (this.isInterval() != tother.isInterval()) {
            return false;
        }
        if (this.isInterval()) {
            if (this.intervals.size() != tother.intervals.size()) {
                return false;
            }
            for (int i = 0; i < this.intervals.size(); ++i) {
                if (this.intervals.get(i).equals(tother.intervals.get(i))) continue;
                return false;
            }
            return true;
        }
        if (this.coords.size() != tother.coords.size()) {
            return false;
        }
        for (int i = 0; i < this.coords.size(); ++i) {
            if (this.coords.get(i).equals(tother.coords.get(i))) continue;
            return false;
        }
        return true;
    }

    public int findInterval(Tinv tinv) {
        for (int i = 0; i < this.intervals.size(); ++i) {
            if (!this.intervals.get(i).equals(tinv)) continue;
            return i;
        }
        return -1;
    }

    public int findIdx(int offsetHour) {
        for (int i = 0; i < this.coords.size(); ++i) {
            if (!this.coords.get(i).equals(offsetHour)) continue;
            return i;
        }
        return -1;
    }

    public static int findCoord(List<TimeCoord> timeCoords, TimeCoord want) {
        if (want == null) {
            return -1;
        }
        for (int i = 0; i < timeCoords.size(); ++i) {
            if (!want.equalsData(timeCoords.get(i))) continue;
            return i;
        }
        timeCoords.add(want);
        return timeCoords.size() - 1;
    }

    public static class TinvDate
    implements Comparable<TinvDate> {
        private final CalendarDate start;
        private final CalendarDate end;
        public int index = -1;

        public TinvDate(CalendarPeriod period, CalendarDate end) {
            this.end = end;
            this.start = end.subtract(period);
        }

        public TinvDate(CalendarDate start, CalendarPeriod period) {
            this.start = start;
            this.end = start.add(period);
        }

        public CalendarDate getStart() {
            return this.start;
        }

        public CalendarDate getEnd() {
            return this.end;
        }

        public Tinv convertReferenceDate(CalendarDate refDate, CalendarPeriod timeUnit) {
            if (timeUnit == null) {
                return null;
            }
            int startOffset = timeUnit.getOffset(refDate, this.start);
            int endOffset = timeUnit.getOffset(refDate, this.end);
            return new Tinv(startOffset, endOffset);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TinvDate tinvDate = (TinvDate)o;
            if (this.end != null ? !this.end.equals((Object)tinvDate.end) : tinvDate.end != null) {
                return false;
            }
            return !(this.start != null ? !this.start.equals((Object)tinvDate.start) : tinvDate.start != null);
        }

        public int hashCode() {
            int result = this.start != null ? this.start.hashCode() : 0;
            result = 31 * result + (this.end != null ? this.end.hashCode() : 0);
            return result;
        }

        @Override
        public int compareTo(TinvDate that) {
            int c1 = this.start.compareTo(that.start);
            return c1 == 0 ? this.end.compareTo(that.end) : c1;
        }

        public String toString() {
            Formatter out = new Formatter();
            out.format("(%s,%s)", this.start, this.end);
            return out.toString();
        }
    }

    public static class Tinv
    implements Comparable<Tinv> {
        private final int b1;
        private final int b2;

        public Tinv(int b1, int b2) {
            this.b1 = b1;
            this.b2 = b2;
        }

        public int getBounds1() {
            return this.b1;
        }

        public int getBounds2() {
            return this.b2;
        }

        public int getIntervalSize() {
            return Math.abs(this.b2 - this.b1);
        }

        public Tinv convertReferenceDate(CalendarDate fromDate, CalendarPeriod fromUnit, CalendarDate toDate, CalendarPeriod toUnit) {
            CalendarDate start = fromDate.add(fromUnit.multiply(this.b1));
            CalendarDate end = fromDate.add(fromUnit.multiply(this.b2));
            int startOffset = TimeCoord.getOffset(toDate, start, toUnit);
            int endOffset = TimeCoord.getOffset(toDate, end, toUnit);
            return new Tinv(startOffset, endOffset);
        }

        public boolean equals(Object o) {
            if (!(o instanceof Tinv)) {
                return false;
            }
            Tinv tinv = (Tinv)o;
            if (this.b1 != tinv.b1) {
                return false;
            }
            return this.b2 == tinv.b2;
        }

        public int hashCode() {
            int result = this.b1;
            result = 31 * result + this.b2;
            return result;
        }

        @Override
        public int compareTo(Tinv o) {
            int c1 = this.b2 - o.b2;
            return c1 == 0 ? this.b1 - o.b1 : c1;
        }

        public String toString() {
            Formatter out = new Formatter();
            out.format("(%d,%d)", this.b1, this.b2);
            return out.toString();
        }

        public Tinv offset(double offset) {
            return new Tinv((int)(offset + (double)this.b1), (int)(offset + (double)this.b2));
        }
    }
}

