/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.util.validation.feature;

import java.util.EnumSet;
import java.util.Set;
import liquibase.repackaged.net.sf.jsqlparser.parser.feature.Feature;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.feature.FeatureSetValidation;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.feature.H2Version;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.feature.MariaDbVersion;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.feature.MySqlVersion;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.feature.OracleVersion;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.feature.PostgresqlVersion;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.feature.SQLVersion;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.feature.SqlServerVersion;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.feature.Version;

public enum DatabaseType implements FeatureSetValidation,
Version
{
    ANSI_SQL("ANSI SQL", (Version[])SQLVersion.values()),
    ORACLE(OracleVersion.values()),
    MYSQL(MySqlVersion.values()),
    SQLSERVER(SqlServerVersion.values()),
    MARIADB(MariaDbVersion.values()),
    POSTGRESQL(PostgresqlVersion.values()),
    H2(H2Version.values());

    public static final DatabaseType[] DATABASES;
    private String name;
    private Version[] versions;

    private DatabaseType(Version ... versionArray) {
        this.versions = versionArray;
    }

    private DatabaseType(String string2, Version ... versionArray) {
        this.name = string2;
        this.versions = versionArray;
    }

    public static DatabaseType get(String string) {
        return DatabaseType.valueOf(string.toUpperCase());
    }

    @Override
    public final String getName() {
        if (this.name == null) {
            return this.name();
        }
        return this.name;
    }

    @Override
    public final Set<Feature> getFeatures() {
        if (this.versions.length > 0) {
            return this.versions[this.versions.length - 1].getFeatures();
        }
        return EnumSet.noneOf(Feature.class);
    }

    @Override
    public final String getVersionString() {
        if (this.versions.length > 0) {
            return this.versions[this.versions.length - 1].getVersionString();
        }
        return null;
    }

    static {
        DATABASES = new DatabaseType[]{ORACLE, MYSQL, SQLSERVER, MARIADB, POSTGRESQL, H2};
    }
}

