/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.logging;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.sis.internal.system.OS;
import org.apache.sis.internal.util.AutoMessageFormat;
import org.apache.sis.internal.util.X364;
import org.apache.sis.io.IO;
import org.apache.sis.io.LineAppender;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.logging.PerformanceLevel;

public class MonolineFormatter
extends Formatter {
    private static final int NO_SOURCE = 0;
    private static final int LOGGER_SHORT = 1;
    private static final int LOGGER_LONG = 2;
    private static final int CLASS_SHORT = 3;
    private static final int CLASS_LONG = 4;
    private static final int METHOD = 5;
    private static final String[] FORMAT_LABELS = new String[6];
    private static final Level LEVEL_THRESHOLD;
    private static final Comparator<Level> COMPARATOR;
    private static final boolean SHOW_LEVEL = true;
    private static final int CONTINUATION_MARGIN = 4;
    private static final int CONTEXT_STACK_TRACE_ELEMENTS = 2;
    private static final int MAX_CAUSES = 10;
    private String header = "";
    private SortedMap<Level, X364> colors;
    private final boolean faintSupported;
    private transient int[] colorLevels;
    private transient String[] colorSequences;
    private final int levelWidth;
    private final long startMillis = System.currentTimeMillis();
    private SimpleDateFormat timeFormat;
    private transient AutoMessageFormat messageFormat;
    private transient String messagePattern;
    private int sourceFormat = 0;
    private final StringBuffer buffer;
    private final LineAppender writer;
    private final PrintWriter printer;

    public MonolineFormatter() {
        this(null);
    }

    public MonolineFormatter(Handler handler) {
        this.levelWidth = MonolineFormatter.levelWidth(handler != null ? handler.getLevel() : null);
        LogManager logManager = LogManager.getLogManager();
        String string = MonolineFormatter.class.getName();
        this.header = logManager.getProperty(string + ".header");
        if (this.header == null) {
            this.header = "";
        }
        try {
            this.timeFormat(logManager.getProperty(string + ".time"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Logging.configurationException(Logging.getLogger("org.apache.sis.util"), MonolineFormatter.class, "<init>", illegalArgumentException);
        }
        try {
            this.sourceFormat(logManager.getProperty(string + ".source"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Logging.configurationException(Logging.getLogger("org.apache.sis.util"), MonolineFormatter.class, "<init>", illegalArgumentException);
        }
        if (handler instanceof ConsoleHandler && X364.isAnsiSupported()) {
            this.resetLevelColors();
        }
        this.faintSupported = OS.current() != OS.MAC_OS;
        StringWriter stringWriter = new StringWriter();
        this.writer = new LineAppender((Appendable)stringWriter, System.lineSeparator(), true);
        this.buffer = stringWriter.getBuffer().append(this.header);
        this.printer = new PrintWriter(IO.asWriter(this.writer));
        this.writer.setTabulationWidth(4);
    }

    static int levelWidth(Level level) {
        int n = 0;
        int n2 = 0;
        block9: while (true) {
            Level level2;
            switch (n2) {
                case 0: {
                    level2 = Level.SEVERE;
                    break;
                }
                case 1: {
                    level2 = Level.WARNING;
                    break;
                }
                case 2: {
                    level2 = Level.INFO;
                    break;
                }
                case 3: {
                    level2 = Level.CONFIG;
                    break;
                }
                case 4: {
                    level2 = Level.FINE;
                    break;
                }
                case 5: {
                    level2 = Level.FINER;
                    break;
                }
                case 6: {
                    level2 = Level.FINEST;
                    break;
                }
                default: {
                    break block9;
                }
            }
            if (level != null && level2.intValue() < level.intValue()) break;
            int n3 = level2.getLocalizedName().length();
            if (n3 > n) {
                n = n3;
            }
            ++n2;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHeader() {
        String string;
        StringBuffer stringBuffer = this.buffer;
        synchronized (stringBuffer) {
            string = this.header;
        }
        return string.isEmpty() ? null : string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHeader(String string) {
        if (string == null) {
            string = "";
        }
        StringBuffer stringBuffer = this.buffer;
        synchronized (stringBuffer) {
            this.header = string;
            this.buffer.setLength(0);
            this.buffer.append(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTimeFormat() {
        StringBuffer stringBuffer = this.buffer;
        synchronized (stringBuffer) {
            return this.timeFormat != null ? this.timeFormat.toPattern() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimeFormat(String string) throws IllegalArgumentException {
        StringBuffer stringBuffer = this.buffer;
        synchronized (stringBuffer) {
            this.timeFormat(string);
        }
    }

    private void timeFormat(String string) throws IllegalArgumentException {
        if (string == null) {
            this.timeFormat = null;
        } else if (this.timeFormat == null) {
            this.timeFormat = new SimpleDateFormat(string);
            this.timeFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        } else {
            this.timeFormat.applyPattern(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSourceFormat() {
        StringBuffer stringBuffer = this.buffer;
        synchronized (stringBuffer) {
            return FORMAT_LABELS[this.sourceFormat];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSourceFormat(String string) throws IllegalArgumentException {
        StringBuffer stringBuffer = this.buffer;
        synchronized (stringBuffer) {
            this.sourceFormat(string);
        }
    }

    private void sourceFormat(String string) throws IllegalArgumentException {
        if (string == null) {
            this.sourceFormat = 0;
            return;
        }
        string = CharSequences.trimWhitespaces(string).toLowerCase(Locale.US);
        for (int i = 0; i < FORMAT_LABELS.length; ++i) {
            if (!string.equals(FORMAT_LABELS[i])) continue;
            this.sourceFormat = i;
            return;
        }
        throw new IllegalArgumentException(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLevelColor(Level level) {
        StringBuffer stringBuffer = this.buffer;
        synchronized (stringBuffer) {
            X364 x364;
            if (this.colors != null && (x364 = (X364)((Object)this.colors.get(level))) != null) {
                return x364.color;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLevelColor(Level level, String string) throws IllegalArgumentException {
        boolean bl = false;
        StringBuffer stringBuffer = this.buffer;
        synchronized (stringBuffer) {
            if (string != null) {
                X364 x364 = X364.forColorName(string).background();
                bl = this.colors().put(level, x364) != x364;
            } else if (this.colors != null) {
                boolean bl2 = bl = this.colors.remove(level) != null;
                if (this.colors.isEmpty()) {
                    this.colors = null;
                }
            }
            if (bl) {
                this.colorLevels = null;
                this.colorSequences = null;
            }
        }
    }

    private SortedMap<Level, X364> colors() {
        if (this.colors == null) {
            this.colors = new TreeMap<Level, X364>(COMPARATOR);
        }
        return this.colors;
    }

    private void resetLevelColors() {
        SortedMap<Level, X364> sortedMap = this.colors();
        sortedMap.clear();
        sortedMap.put(Level.ALL, X364.BACKGROUND_GRAY);
        sortedMap.put(Level.CONFIG, X364.BACKGROUND_BLUE);
        sortedMap.put(Level.INFO, X364.BACKGROUND_GREEN);
        sortedMap.put(Level.WARNING, X364.BACKGROUND_YELLOW);
        sortedMap.put(Level.SEVERE, X364.BACKGROUND_RED);
        sortedMap.put(PerformanceLevel.PERFORMANCE, X364.BACKGROUND_CYAN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetLevelColors(boolean bl) {
        StringBuffer stringBuffer = this.buffer;
        synchronized (stringBuffer) {
            if (bl) {
                this.resetLevelColors();
            } else {
                this.colors = null;
                this.colorLevels = null;
                this.colorSequences = null;
            }
        }
    }

    private String colorAt(Level level) {
        int n;
        if (this.colorSequences == null) {
            this.colorSequences = new String[this.colors.size()];
            this.colorLevels = new int[this.colorSequences.length];
            n = 0;
            for (Map.Entry<Level, X364> entry : this.colors.entrySet()) {
                this.colorSequences[n] = entry.getValue().background().sequence();
                this.colorLevels[n++] = entry.getKey().intValue();
            }
        }
        if ((n = Arrays.binarySearch(this.colorLevels, level.intValue())) < 0) {
            n = Math.max(~n - 1, 0);
        }
        return this.colorSequences[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String format(LogRecord logRecord) {
        StringBuffer stringBuffer;
        boolean bl = false;
        String string = "";
        String string2 = "";
        Level level = logRecord.getLevel();
        StringBuffer stringBuffer2 = stringBuffer = this.buffer;
        synchronized (stringBuffer2) {
            String string3;
            boolean bl2;
            boolean bl3 = bl2 = this.colors != null;
            if (bl2 && level.intValue() >= LEVEL_THRESHOLD.intValue()) {
                string = X364.BOLD.sequence();
                string2 = X364.NORMAL.sequence();
                bl = this.faintSupported;
            }
            stringBuffer.setLength(this.header.length());
            if (this.timeFormat != null) {
                Date date = new Date(Math.max(0L, logRecord.getMillis() - this.startMillis));
                this.timeFormat.format(date, stringBuffer, new FieldPosition(0));
                stringBuffer.append(' ');
            }
            int n = stringBuffer.length();
            String string4 = "";
            String string5 = "";
            if (bl2) {
                string4 = this.colorAt(level);
                string5 = X364.BACKGROUND_DEFAULT.sequence();
            }
            int n2 = stringBuffer.append(string4).append(string).length();
            int n3 = stringBuffer.append(level.getLocalizedName()).length() - n2;
            stringBuffer.append(string2).append(CharSequences.spaces(this.levelWidth - n3));
            n += stringBuffer.length() - string2.length() - n2;
            stringBuffer.append(string5).append(' ');
            switch (this.sourceFormat) {
                case 1: 
                case 2: {
                    string3 = logRecord.getLoggerName();
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    string3 = logRecord.getSourceClassName();
                    break;
                }
                default: {
                    string3 = null;
                }
            }
            if (string3 != null) {
                switch (this.sourceFormat) {
                    case 1: 
                    case 3: 
                    case 5: {
                        string3 = string3.substring(string3.lastIndexOf(46) + 1);
                    }
                }
                if (this.sourceFormat == 5) {
                    string3 = string3 + '.' + logRecord.getSourceMethodName();
                }
                stringBuffer.append(string).append('[').append(string3).append(']').append(string2).append(' ');
            }
            String string6 = this.writer.getLineSeparator();
            String string7 = System.lineSeparator();
            if (string6.length() != string7.length() + n + 1) {
                int n4 = Math.min(4, n);
                string6 = string7 + string4 + '\u2503' + CharSequences.spaces(n4 - 1) + string5 + CharSequences.spaces(n - n4 + 1);
                this.writer.setLineSeparator(string6);
            }
            if (bl) {
                stringBuffer.append(X364.FAINT.sequence());
            }
            Throwable throwable = logRecord.getThrown();
            String string8 = this.formatMessage(logRecord);
            int n5 = 0;
            if (string8 != null) {
                n5 = CharSequences.skipTrailingWhitespaces(string8, 0, string8.length());
            }
            try {
                if (string8 != null) {
                    this.writer.append(string8, 0, n5);
                }
                if (throwable != null) {
                    if (string8 != null) {
                        this.writer.append("\nCaused by: ");
                    }
                    if (level.intValue() >= LEVEL_THRESHOLD.intValue()) {
                        throwable.printStackTrace(this.printer);
                    } else {
                        MonolineFormatter.printAbridged(throwable, this.writer, logRecord.getLoggerName(), logRecord.getSourceClassName(), logRecord.getSourceMethodName());
                    }
                }
                this.writer.flush();
            }
            catch (IOException iOException) {
                throw new UncheckedIOException(iOException);
            }
            int n6 = stringBuffer.length();
            do {
                n5 = CharSequences.skipTrailingWhitespaces(stringBuffer, 0, n6);
                n6 = stringBuffer.lastIndexOf(string6);
                stringBuffer.setLength(n5);
            } while ((n5 -= n6) > 0 && n5 <= string6.length());
            if (bl) {
                stringBuffer.append(X364.NORMAL.sequence());
            }
            if ((n6 = CharSequences.indexOf((CharSequence)stringBuffer, 9475, n6 + string7.length(), n6 + string6.length())) >= 0) {
                stringBuffer.setCharAt(n6, '\u2579');
            }
            return stringBuffer.append(string7).toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String formatMessage(LogRecord logRecord) {
        char c;
        int n;
        Object[] objectArray;
        String string = logRecord.getMessage();
        ResourceBundle resourceBundle = logRecord.getResourceBundle();
        if (resourceBundle != null) {
            string = resourceBundle.getString(string);
        }
        if ((objectArray = logRecord.getParameters()) != null && objectArray.length != 0 && (n = string.indexOf(123)) >= 0 && ++n < string.length() && (c = string.charAt(n)) >= '0' && c <= '9') {
            StringBuffer stringBuffer = this.buffer;
            synchronized (stringBuffer) {
                if (this.messageFormat == null) {
                    this.messageFormat = new AutoMessageFormat(string);
                } else if (!string.equals(this.messagePattern)) {
                    this.messageFormat.applyPattern(string);
                }
                this.messagePattern = string;
                int n2 = this.buffer.length();
                try {
                    this.messageFormat.configure(objectArray);
                    string = this.messageFormat.format(objectArray, this.buffer, new FieldPosition(0)).substring(n2);
                }
                finally {
                    this.buffer.setLength(n2);
                }
            }
        }
        return string;
    }

    private static void printAbridged(Throwable throwable, Appendable appendable, String string, String string2, String string3) throws IOException {
        StackTraceElement stackTraceElement = null;
        for (int i = 0; i < 10; ++i) {
            StackTraceElement stackTraceElement2;
            int n;
            StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
            int n2 = stackTraceElementArray.length;
            boolean bl = string != null;
            boolean bl2 = true;
            for (n = 0; n < stackTraceElementArray.length; ++n) {
                stackTraceElement2 = stackTraceElementArray[n];
                String string4 = stackTraceElement2.getClassName();
                if (string4 == null) continue;
                if (bl && string4.startsWith(string)) {
                    n2 = n;
                    bl = false;
                }
                if (!string4.contains(string2)) continue;
                String string5 = stackTraceElement2.getMethodName();
                if (string5 != null && string5.equals(string3)) {
                    n2 = n;
                    break;
                }
                if (bl2) {
                    n2 = n;
                    bl2 = false;
                }
                bl = false;
            }
            if (n2 < (n = stackTraceElementArray.length)) {
                stackTraceElement2 = stackTraceElementArray[n2];
                if (stackTraceElement2.equals(stackTraceElement)) {
                    n = 2;
                }
                stackTraceElement = stackTraceElement2;
            }
            n = Math.min(n2 + 3, n);
            appendable.append(String.valueOf(throwable)).append('\n');
            for (int j = 0; j < n; ++j) {
                int n3;
                if (j == 2 && (n3 = n2 - 4) > 1) {
                    MonolineFormatter.more(appendable, n3, true);
                    j += n3;
                }
                if (j == n2) {
                    appendable.append("  \u2192");
                }
                appendable.append("\tat ").append(String.valueOf(stackTraceElementArray[j])).append('\n');
            }
            MonolineFormatter.more(appendable, stackTraceElementArray.length - n, false);
            throwable = throwable.getCause();
            if (throwable == null) break;
            appendable.append("Caused by: ");
        }
    }

    private static void more(Appendable appendable, int n, boolean bl) throws IOException {
        if (n > 0) {
            appendable.append("... ").append(String.valueOf(n)).append(" more");
            if (bl) {
                appendable.append(" ...");
            }
            appendable.append('\n');
        }
    }

    public static MonolineFormatter install() throws SecurityException {
        return MonolineFormatter.install(Logging.getLogger(""), null);
    }

    public static MonolineFormatter install(Logger logger, Level level) throws SecurityException {
        ArgumentChecks.ensureNonNull("logger", logger);
        MonolineFormatter monolineFormatter = null;
        for (Handler handler : logger.getHandlers()) {
            if (!(handler instanceof ConsoleHandler)) continue;
            Formatter object2 = handler.getFormatter();
            if (object2 instanceof MonolineFormatter) {
                monolineFormatter = (MonolineFormatter)object2;
            } else {
                monolineFormatter = new MonolineFormatter(handler);
                handler.setFormatter(monolineFormatter);
            }
            if (level == null) break;
            handler.setLevel(level);
            break;
        }
        if (monolineFormatter == null) {
            logger.setUseParentHandlers(false);
            Object object = logger;
            while (((Logger)object).getUseParentHandlers() && (object = ((Logger)object).getParent()) != null) {
                for (Handler handler : ((Logger)object).getHandlers()) {
                    if (handler instanceof ConsoleHandler) continue;
                    logger.addHandler(handler);
                }
            }
            object = new ConsoleHandler();
            if (level != null) {
                ((Handler)object).setLevel(level);
            }
            monolineFormatter = new MonolineFormatter((Handler)object);
            ((Handler)object).setFormatter(monolineFormatter);
            logger.addHandler((Handler)object);
        }
        return monolineFormatter;
    }

    static {
        MonolineFormatter.FORMAT_LABELS[1] = "logger:short";
        MonolineFormatter.FORMAT_LABELS[2] = "logger:long";
        MonolineFormatter.FORMAT_LABELS[3] = "class:short";
        MonolineFormatter.FORMAT_LABELS[4] = "class:long";
        MonolineFormatter.FORMAT_LABELS[5] = "class.method";
        LEVEL_THRESHOLD = Level.INFO;
        COMPARATOR = (level, level2) -> {
            int n;
            int n2 = level.intValue();
            if (n2 < (n = level2.intValue())) {
                return -1;
            }
            if (n2 > n) {
                return 1;
            }
            return 0;
        };
    }
}

