/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.eviction.impl;

import java.util.List;
import java.util.Map;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.impl.ImmutableContext;
import org.infinispan.eviction.EvictionManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.CacheMgmtInterceptor;
import org.infinispan.interceptors.InterceptorChain;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.notifications.cachelistener.CacheNotifier;

@ThreadSafe
public class EvictionManagerImpl<K, V>
implements EvictionManager<K, V> {
    private CacheNotifier<K, V> cacheNotifier;
    private InterceptorChain interceptorChain;
    private Configuration cfg;

    @Inject
    public void initialize(CacheNotifier<K, V> cacheNotifier, Configuration cfg, InterceptorChain chain) {
        this.cacheNotifier = cacheNotifier;
        this.cfg = cfg;
        this.interceptorChain = chain;
    }

    @Override
    public void onEntryEviction(Map<? extends K, InternalCacheEntry<? extends K, ? extends V>> evicted) {
        ImmutableContext ctx = ImmutableContext.INSTANCE;
        this.cacheNotifier.notifyCacheEntriesEvicted(evicted.values(), ctx, null);
        if (this.cfg.jmxStatistics().enabled()) {
            this.updateEvictionStatistics(evicted);
        }
    }

    private void updateEvictionStatistics(Map<? extends K, InternalCacheEntry<? extends K, ? extends V>> evicted) {
        List<CommandInterceptor> interceptors = this.interceptorChain.getInterceptorsWhichExtend(CacheMgmtInterceptor.class);
        if (!interceptors.isEmpty()) {
            CacheMgmtInterceptor mgmtInterceptor = (CacheMgmtInterceptor)interceptors.get(0);
            mgmtInterceptor.addEvictions(evicted.size());
        }
    }
}

