/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.jpa.dao;

import java.util.List;
import javax.persistence.NoResultException;
import javax.persistence.TypedQuery;
import org.exoplatform.wiki.jpa.dao.WikiBaseDAO;
import org.exoplatform.wiki.jpa.entity.WikiEntity;
import org.exoplatform.wiki.mow.api.WikiType;

public class WikiDAO
extends WikiBaseDAO<WikiEntity, Long> {
    public List<Long> findAllIds(int offset, int limit) {
        return this.getEntityManager().createNamedQuery("wiki.getAllIds").setFirstResult(offset).setMaxResults(limit).getResultList();
    }

    public WikiEntity getWikiByTypeAndOwner(String wikiType, String wikiOwner) {
        if (wikiType.toUpperCase().equals(WikiType.GROUP.name())) {
            wikiOwner = this.validateGroupWikiOwner(wikiOwner);
        }
        TypedQuery query = this.getEntityManager().createNamedQuery("wiki.getWikiByTypeAndOwner", WikiEntity.class).setParameter("type", (Object)wikiType).setParameter("owner", (Object)wikiOwner);
        try {
            return (WikiEntity)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<WikiEntity> getWikisByType(String wikiType) {
        TypedQuery query = this.getEntityManager().createNamedQuery("wiki.getWikisByType", WikiEntity.class).setParameter("type", (Object)wikiType);
        return query.getResultList();
    }
}

