/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.feature.AbstractOperation;
import org.apache.sis.feature.DefaultAssociationRole;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.feature.DenseFeature;
import org.apache.sis.feature.FeatureFormat;
import org.apache.sis.feature.FeatureType;
import org.apache.sis.feature.FieldType;
import org.apache.sis.feature.NamedFeatureType;
import org.apache.sis.feature.SparseFeature;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.collection.Containers;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.util.GenericName;
import org.opengis.util.NameFactory;
import org.opengis.util.ScopedName;

public class DefaultFeatureType
extends AbstractIdentifiedType
implements FeatureType {
    private static final long serialVersionUID = -4357370600723922312L;
    private final boolean isAbstract;
    private transient boolean isSimple;
    private transient boolean isSparse;
    private transient boolean isResolved;
    private final Set<DefaultFeatureType> superTypes;
    private transient Set<GenericName> assignableTo;
    private final List<AbstractIdentifiedType> properties;
    private transient Collection<AbstractIdentifiedType> allProperties;
    private transient Map<String, AbstractIdentifiedType> byName;
    private transient Map<String, Integer> indices;
    static final Integer OPERATION_INDEX = -1;

    /*
     * WARNING - void declaration
     */
    public DefaultFeatureType(Map<String, ?> map, boolean bl, DefaultFeatureType[] defaultFeatureTypeArray, AbstractIdentifiedType ... abstractIdentifiedTypeArray) {
        super(map);
        void var6_8;
        ArgumentChecks.ensureNonNull((String)"properties", (Object)abstractIdentifiedTypeArray);
        this.isAbstract = bl;
        if (defaultFeatureTypeArray == null) {
            this.superTypes = Collections.emptySet();
        } else {
            this.superTypes = CollectionsExt.immutableSet((boolean)true, (Object[])defaultFeatureTypeArray);
            for (FeatureType featureType : this.superTypes) {
                if (!(featureType instanceof NamedFeatureType)) continue;
                throw new IllegalArgumentException(Resources.format((short)18, featureType.getName()));
            }
        }
        ArrayList arrayList = new ArrayList(abstractIdentifiedTypeArray.length);
        boolean n = false;
        while (var6_8 < abstractIdentifiedTypeArray.length) {
            AbstractIdentifiedType abstractIdentifiedType = abstractIdentifiedTypeArray[var6_8];
            ArgumentChecks.ensureNonNullElement((String)"properties", (int)var6_8, (Object)abstractIdentifiedType);
            arrayList.add(abstractIdentifiedType);
            ++var6_8;
        }
        this.computeTransientFields(arrayList);
        int n2 = arrayList.size();
        switch (n2) {
            case 0: {
                this.properties = Collections.emptyList();
                break;
            }
            case 1: {
                this.properties = Collections.singletonList((AbstractIdentifiedType)arrayList.get(0));
                break;
            }
            default: {
                this.properties = UnmodifiableArrayList.wrap((Object[])arrayList.toArray(new AbstractIdentifiedType[n2]));
            }
        }
        for (AbstractIdentifiedType abstractIdentifiedType : this.allProperties) {
            if (!(abstractIdentifiedType instanceof AbstractOperation)) continue;
            for (String string : ((AbstractOperation)abstractIdentifiedType).getDependencies()) {
                if (this.byName.containsKey(string)) continue;
                throw new IllegalArgumentException(Resources.format((short)8, abstractIdentifiedType.getName(), string, super.getName()));
            }
        }
        this.isResolved = this.resolve(this, this.properties, null, this.isSimple);
    }

    @Override
    GenericName createName(NameFactory nameFactory, String string) {
        return nameFactory.createTypeName(null, (CharSequence)string);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.computeTransientFields(this.properties);
        this.isResolved = this.isSimple;
    }

    private void computeTransientFields(List<AbstractIdentifiedType> list) {
        Object object;
        int n = Containers.hashMapCapacity((int)list.size());
        this.byName = new LinkedHashMap<String, AbstractIdentifiedType>(n);
        this.indices = new LinkedHashMap<String, Integer>(n);
        this.assignableTo = new HashSet<GenericName>(4);
        this.assignableTo.add(super.getName());
        this.scanPropertiesFrom(this, list);
        this.allProperties = UnmodifiableArrayList.wrap((Object[])this.byName.values().toArray(new AbstractIdentifiedType[this.byName.size()]));
        this.isSimple = true;
        int n2 = 0;
        int n3 = 0;
        for (Map.Entry<String, AbstractIdentifiedType> object2 : this.byName.entrySet()) {
            int genericName;
            int abstractIdentifiedType;
            object = object2.getValue();
            if (object instanceof DefaultAttributeType) {
                abstractIdentifiedType = ((DefaultAttributeType)object).getMinimumOccurs();
                this.isSimple &= abstractIdentifiedType == (genericName = ((DefaultAttributeType)object).getMaximumOccurs());
            } else if (object instanceof FieldType) {
                abstractIdentifiedType = ((FieldType)object).getMinimumOccurs();
                genericName = ((FieldType)object).getMaximumOccurs();
                this.isSimple = false;
            } else {
                if (!DefaultFeatureType.isParameterlessOperation((AbstractIdentifiedType)object)) continue;
                this.indices.put(object2.getKey(), OPERATION_INDEX);
                continue;
            }
            if (genericName == 0) continue;
            this.isSimple &= genericName == 1;
            this.indices.put(object2.getKey(), n2++);
            if (abstractIdentifiedType == 0) continue;
            ++n3;
        }
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (AbstractIdentifiedType abstractIdentifiedType : this.allProperties) {
            GenericName genericName = abstractIdentifiedType.getName();
            while (genericName instanceof ScopedName && genericName != (genericName = ((ScopedName)genericName).tail()) && (object = genericName.toString()) != null && !((String)(object = ((String)object).trim())).isEmpty()) {
                linkedHashMap.put(object, linkedHashMap.containsKey(object) ? null : abstractIdentifiedType);
            }
        }
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            Integer n4;
            AbstractIdentifiedType abstractIdentifiedType = (AbstractIdentifiedType)entry.getValue();
            if (abstractIdentifiedType != null && this.byName.putIfAbsent((String)(object = (String)entry.getKey()), abstractIdentifiedType) == null && (n4 = this.indices.get(abstractIdentifiedType.getName().toString())) != null && this.indices.put((String)object, n4) != null) {
                throw new AssertionError(object);
            }
        }
        this.byName = CollectionsExt.compact(this.byName);
        this.indices = CollectionsExt.compact(this.indices);
        this.assignableTo = CollectionsExt.unmodifiableOrCopy(this.assignableTo);
        int n5 = this.indices.size();
        this.isSparse = n5 > 24 && n3 <= n5 / 2;
    }

    private void scanPropertiesFrom(DefaultFeatureType defaultFeatureType, Collection<? extends AbstractIdentifiedType> collection) {
        for (DefaultFeatureType object2 : defaultFeatureType.getSuperTypes()) {
            if (!this.assignableTo.add(object2.getName())) continue;
            this.scanPropertiesFrom(object2, object2.getProperties(false));
        }
        int n = -1;
        Iterator<? extends AbstractIdentifiedType> iterator = collection.iterator();
        while (iterator.hasNext()) {
            AbstractIdentifiedType abstractIdentifiedType = iterator.next();
            String string = DefaultFeatureType.toString(abstractIdentifiedType.getName(), defaultFeatureType, "properties", ++n);
            AbstractIdentifiedType abstractIdentifiedType2 = this.byName.put(string, abstractIdentifiedType);
            if (abstractIdentifiedType2 == null) continue;
            if (abstractIdentifiedType2.equals(abstractIdentifiedType)) {
                this.byName.put(string, abstractIdentifiedType2);
                if (defaultFeatureType != this) continue;
                iterator.remove();
                continue;
            }
            if (DefaultFeatureType.isAssignableIgnoreName(abstractIdentifiedType2, abstractIdentifiedType)) continue;
            GenericName genericName = DefaultFeatureType.ownerOf(this, collection, abstractIdentifiedType2);
            throw new IllegalArgumentException(Resources.format((short)15, genericName != null ? genericName : "?", string));
        }
    }

    private static GenericName ownerOf(DefaultFeatureType defaultFeatureType, Collection<? extends AbstractIdentifiedType> collection, AbstractIdentifiedType abstractIdentifiedType) {
        if (collection.contains(abstractIdentifiedType)) {
            return defaultFeatureType.getName();
        }
        for (DefaultFeatureType defaultFeatureType2 : defaultFeatureType.getSuperTypes()) {
            GenericName genericName = DefaultFeatureType.ownerOf(defaultFeatureType2, defaultFeatureType2.getProperties(false), abstractIdentifiedType);
            if (genericName == null) continue;
            return genericName;
        }
        return null;
    }

    private boolean resolve(DefaultFeatureType defaultFeatureType, Map<FeatureType, Boolean> map) {
        defaultFeatureType.isResolved = this.resolve(defaultFeatureType, defaultFeatureType.properties, map, defaultFeatureType.isResolved);
        return defaultFeatureType.isResolved;
    }

    private boolean resolve(DefaultFeatureType defaultFeatureType, Collection<? extends AbstractIdentifiedType> collection, Map<FeatureType, Boolean> map, boolean bl) {
        if (!bl) {
            bl = true;
            for (DefaultFeatureType abstractIdentifiedType : defaultFeatureType.getSuperTypes()) {
                bl &= this.resolve(abstractIdentifiedType, map);
            }
            for (AbstractIdentifiedType abstractIdentifiedType : collection) {
                Boolean bl2;
                if (!(abstractIdentifiedType instanceof DefaultAssociationRole)) continue;
                if (!((DefaultAssociationRole)abstractIdentifiedType).resolve(this, this.properties)) {
                    bl = false;
                    continue;
                }
                DefaultFeatureType defaultFeatureType2 = ((DefaultAssociationRole)abstractIdentifiedType).getValueType();
                if (defaultFeatureType2 == this) continue;
                if (map == null) {
                    map = new IdentityHashMap<FeatureType, Boolean>(8);
                }
                if ((bl2 = map.put(defaultFeatureType2, Boolean.FALSE)) == null) {
                    bl2 = this.resolve(defaultFeatureType2, map);
                    map.put(defaultFeatureType2, bl2);
                }
                bl &= bl2.booleanValue();
            }
        }
        return bl;
    }

    static boolean isParameterlessOperation(AbstractIdentifiedType abstractIdentifiedType) {
        if (abstractIdentifiedType instanceof AbstractOperation) {
            ParameterDescriptorGroup parameterDescriptorGroup = ((AbstractOperation)abstractIdentifiedType).getParameters();
            return (parameterDescriptorGroup == null || parameterDescriptorGroup.descriptors().isEmpty()) && ((AbstractOperation)abstractIdentifiedType).getResult() != null;
        }
        return false;
    }

    public final boolean isAbstract() {
        return this.isAbstract;
    }

    final boolean isSparse() {
        return this.isSparse;
    }

    public boolean isSimple() {
        return this.isSimple;
    }

    static boolean maybeAssignableFrom(DefaultFeatureType defaultFeatureType, DefaultFeatureType defaultFeatureType2) {
        return defaultFeatureType2.assignableTo.contains(defaultFeatureType.getName());
    }

    @Override
    public boolean isAssignableFrom(DefaultFeatureType defaultFeatureType) {
        if (defaultFeatureType == this) {
            return true;
        }
        ArgumentChecks.ensureNonNull((String)"type", (Object)defaultFeatureType);
        if (!DefaultFeatureType.maybeAssignableFrom(this, defaultFeatureType)) {
            return false;
        }
        for (Map.Entry<String, AbstractIdentifiedType> entry : this.byName.entrySet()) {
            AbstractIdentifiedType abstractIdentifiedType;
            try {
                abstractIdentifiedType = defaultFeatureType.getProperty(entry.getKey());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
            if (DefaultFeatureType.isAssignableIgnoreName(entry.getValue(), abstractIdentifiedType)) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isAssignableIgnoreName(AbstractIdentifiedType abstractIdentifiedType, AbstractIdentifiedType abstractIdentifiedType2) {
        int n;
        int n2;
        AbstractIdentifiedType abstractIdentifiedType3;
        AbstractIdentifiedType abstractIdentifiedType4;
        if (abstractIdentifiedType == abstractIdentifiedType2) return true;
        if (abstractIdentifiedType instanceof DefaultAttributeType) {
            abstractIdentifiedType4 = (DefaultAttributeType)abstractIdentifiedType;
            if (abstractIdentifiedType2 instanceof DefaultAttributeType) {
                abstractIdentifiedType3 = (DefaultAttributeType)abstractIdentifiedType2;
            } else {
                if (!DefaultFeatureType.isParameterlessOperation(abstractIdentifiedType2)) return false;
                AbstractIdentifiedType abstractIdentifiedType5 = ((AbstractOperation)abstractIdentifiedType2).getResult();
                if (!(abstractIdentifiedType5 instanceof DefaultAttributeType)) return false;
                abstractIdentifiedType3 = (DefaultAttributeType)abstractIdentifiedType5;
            }
            if (!((DefaultAttributeType)abstractIdentifiedType4).getValueClass().isAssignableFrom(((DefaultAttributeType)abstractIdentifiedType3).getValueClass()) || (n2 = ((DefaultAttributeType)abstractIdentifiedType4).getMinimumOccurs()) > ((DefaultAttributeType)abstractIdentifiedType3).getMinimumOccurs() || (n = ((DefaultAttributeType)abstractIdentifiedType4).getMaximumOccurs()) < ((DefaultAttributeType)abstractIdentifiedType3).getMaximumOccurs() || abstractIdentifiedType3 != abstractIdentifiedType2 && (n2 > 1 || n < 1)) {
                return false;
            }
        }
        if (abstractIdentifiedType instanceof DefaultAssociationRole) {
            DefaultFeatureType defaultFeatureType;
            abstractIdentifiedType4 = (DefaultAssociationRole)abstractIdentifiedType;
            if (abstractIdentifiedType2 instanceof DefaultAssociationRole) {
                abstractIdentifiedType3 = (DefaultAssociationRole)abstractIdentifiedType2;
            } else {
                if (!DefaultFeatureType.isParameterlessOperation(abstractIdentifiedType2)) return false;
                AbstractIdentifiedType abstractIdentifiedType6 = ((AbstractOperation)abstractIdentifiedType2).getResult();
                if (!(abstractIdentifiedType6 instanceof DefaultAssociationRole)) return false;
                abstractIdentifiedType3 = (DefaultAssociationRole)abstractIdentifiedType6;
            }
            n2 = ((DefaultAssociationRole)abstractIdentifiedType4).getMinimumOccurs();
            if (n2 > ((DefaultAssociationRole)abstractIdentifiedType3).getMinimumOccurs() || (n = ((DefaultAssociationRole)abstractIdentifiedType4).getMaximumOccurs()) < ((DefaultAssociationRole)abstractIdentifiedType3).getMaximumOccurs() || abstractIdentifiedType3 != abstractIdentifiedType2 && (n2 > 1 || n < 1)) {
                return false;
            }
            DefaultFeatureType defaultFeatureType2 = ((DefaultAssociationRole)abstractIdentifiedType4).getValueType();
            if (defaultFeatureType2 != (defaultFeatureType = ((DefaultAssociationRole)abstractIdentifiedType3).getValueType()) && !defaultFeatureType2.isAssignableFrom(defaultFeatureType)) {
                return false;
            }
        }
        if (!(abstractIdentifiedType instanceof AbstractOperation)) return true;
        abstractIdentifiedType4 = (AbstractOperation)abstractIdentifiedType;
        if (abstractIdentifiedType2 instanceof AbstractOperation) {
            AbstractOperation abstractOperation = (AbstractOperation)abstractIdentifiedType2;
            if (!Objects.equals(((AbstractOperation)abstractIdentifiedType4).getParameters(), abstractOperation.getParameters())) {
                return false;
            }
            abstractIdentifiedType3 = abstractOperation.getResult();
        } else {
            if (!DefaultFeatureType.isParameterlessOperation(abstractIdentifiedType)) return false;
            abstractIdentifiedType3 = abstractIdentifiedType2;
        }
        AbstractIdentifiedType abstractIdentifiedType7 = ((AbstractOperation)abstractIdentifiedType4).getResult();
        if (abstractIdentifiedType7 == abstractIdentifiedType3 || !(abstractIdentifiedType7 instanceof DefaultFeatureType ? !(abstractIdentifiedType3 instanceof DefaultFeatureType) || !((FeatureType)((Object)abstractIdentifiedType7)).isAssignableFrom((DefaultFeatureType)abstractIdentifiedType3) : abstractIdentifiedType7 != null && (abstractIdentifiedType3 == null || !DefaultFeatureType.isAssignableIgnoreName(abstractIdentifiedType7, abstractIdentifiedType3)))) return true;
        return false;
    }

    public final Set<DefaultFeatureType> getSuperTypes() {
        return this.superTypes;
    }

    @Override
    public Collection<AbstractIdentifiedType> getProperties(boolean bl) {
        return bl ? this.allProperties : this.properties;
    }

    public AbstractIdentifiedType getProperty(String string) throws IllegalArgumentException {
        AbstractIdentifiedType abstractIdentifiedType = this.byName.get(string);
        if (abstractIdentifiedType != null) {
            return abstractIdentifiedType;
        }
        throw new IllegalArgumentException(AbstractFeature.propertyNotFound(this, this.getName(), string));
    }

    final Map<String, Integer> indices() {
        return this.indices;
    }

    public AbstractFeature newInstance() throws IllegalStateException {
        if (this.isAbstract) {
            throw new IllegalStateException(Resources.format((short)1, this.getName()));
        }
        return this.isSparse ? new SparseFeature(this) : new DenseFeature(this);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.superTypes.hashCode() + 37 * this.properties.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            DefaultFeatureType defaultFeatureType = (DefaultFeatureType)object;
            return this.isAbstract == defaultFeatureType.isAbstract && this.superTypes.equals(defaultFeatureType.superTypes) && this.properties.equals(defaultFeatureType.properties);
        }
        return false;
    }

    public String toString() {
        return FeatureFormat.sharedFormat(this);
    }
}

