/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.security.oauth.web.google;

import com.google.api.services.oauth2.model.Userinfo;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.gatein.security.oauth.google.GoogleAccessTokenContext;
import org.gatein.security.oauth.google.GoogleProcessor;
import org.gatein.security.oauth.spi.InteractionState;
import org.gatein.security.oauth.spi.OAuthPrincipal;
import org.gatein.security.oauth.spi.OAuthProviderType;
import org.gatein.security.oauth.utils.OAuthUtils;
import org.gatein.security.oauth.web.OAuthProviderFilter;

public class GoogleFilter
extends OAuthProviderFilter<GoogleAccessTokenContext> {
    @Override
    protected OAuthProviderType<GoogleAccessTokenContext> getOAuthProvider() {
        return this.getOauthProvider("GOOGLE", GoogleAccessTokenContext.class);
    }

    @Override
    protected void initInteraction(HttpServletRequest request, HttpServletResponse response) {
        request.getSession().removeAttribute("_authState");
        request.getSession().removeAttribute("_verificationState");
    }

    @Override
    protected OAuthPrincipal<GoogleAccessTokenContext> getOAuthPrincipal(HttpServletRequest request, HttpServletResponse response, InteractionState<GoogleAccessTokenContext> interactionState) {
        GoogleAccessTokenContext accessTokenContext = (GoogleAccessTokenContext)interactionState.getAccessTokenContext();
        Userinfo userInfo = ((GoogleProcessor)this.getOauthProviderProcessor()).obtainUserInfo(accessTokenContext);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Obtained tokenResponse from Google authentication: " + accessTokenContext));
            this.log.trace((Object)("User info from Google: " + userInfo));
        }
        OAuthPrincipal oauthPrincipal = OAuthUtils.convertGoogleInfoToOAuthPrincipal((Userinfo)userInfo, (GoogleAccessTokenContext)accessTokenContext, this.getOAuthProvider());
        return oauthPrincipal;
    }
}

