/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.file.resource;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.exoplatform.commons.file.model.FileInfo;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.resource.BinaryProvider;
import org.exoplatform.commons.file.resource.FileUtils;

public class MemoryProvider
implements BinaryProvider {
    protected final Map<String, byte[]> store;
    protected String location;

    public MemoryProvider() {
        this(new HashMap<String, byte[]>());
    }

    public MemoryProvider(Map<String, byte[]> store) {
        this.store = store;
        this.location = "java:" + System.identityHashCode(this);
    }

    @Override
    public boolean exists(String name) {
        return this.store.containsKey(name);
    }

    @Override
    public byte[] getBytes(String name) {
        return this.store.get(name);
    }

    @Override
    public InputStream getStream(String name) {
        byte[] data = this.store.get(name);
        return data == null ? null : new ByteArrayInputStream(data);
    }

    @Override
    public String getFilePath(FileInfo fileInfo) throws IOException {
        return "java";
    }

    @Override
    public String getFilePath(String name) throws IOException {
        return "java";
    }

    @Override
    public URL getURL(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long lastModified(String name) {
        return 0L;
    }

    @Override
    public void put(String name, InputStream data) throws IOException {
        this.store.put(name, FileUtils.readBytes(data));
    }

    @Override
    public void put(FileItem fileItem) throws IOException {
        this.store.put(fileItem.getFileInfo().getChecksum(), FileUtils.readBytes(fileItem.getAsStream()));
    }

    @Override
    public void put(String name, byte[] data) throws IOException {
        this.store.put(name, data);
    }

    @Override
    public void remove(String name) {
        this.store.remove(name);
    }

    @Override
    public boolean remove(FileInfo fileInfo) throws FileNotFoundException {
        return this.store.remove(fileInfo.getChecksum()) != null;
    }

    @Override
    public String getLocation() {
        return "java";
    }

    public String toString() {
        return this.getLocation();
    }
}

